# Expresiones Regulares

Las expresiones regulares son usadas para encontrar en textos ciertos
patrones, ya sea un grupo de palabras que se repite, unos carácteres
entre otros\...

## Basicas 1

En un texto como\...

    El perro feo se comio 25 cocos con trigo, luego se tiro un peo.

\
[La expresión regular más sencilla es la que indica varios o un sólo
carácter:]{.underline}\
**o**\
`El perr<font color='red'>o</font> fe<font color='red'>o</font>...`{=html}\
**feo**\
`El perro <font color='red'>feo</font> se comio 25 cocos con trigo, luego se tiro un peo.`{=html}\
\
[Podemos elegir \"una u otra\", por ejemplo\...]{.underline}\
**feo\|peo**\
`El perro <font color='red'>feo</font> se comio 25 cocos con trigo, luego se tiro un <font color='red'>peo</font>.`{=html}\
*Si no indicasemos nada seleccionaría todo.*\
\
[Un punto significa un carácter cualquiera (excepto el de
newline)]{.underline}\
**.e**\
`El <font color='red'>pe</font>rro <font color='red'>fe</font>o <font color='red'>se</font> comio 25 cocos con trigo, l<font color='red'>ue</font>go <font color='red'>se</font> tiro un <font color='red'>pe</font>o.`{=html}\
\
[Para buscar el punto tendremos que usar el \"carácter de
escape\"]{.underline}\
**\\.**\
`El perro feo se comio 25 cocos con trigo, luego se tiro un peo<font color='red'>.</font>`{=html}\
**\\n** *Corresponde al newline*\
**\\t** *Corresponde a una tabulación*\
**\\b** *Corresponde al carácter en blanco*\
**\^** *Es el inicio de línea*\
**\\b.e\\b**\
`El perro feo <font color='red'>se</font> comio 25 cocos con trigo, luego <font color='red'>se</font> tiro un peo.`{=html}\
**\\b.e.\\b**\
`El perro <font color='red'>feo</font> se comio 25 cocos con trigo, luego se tiro un <font color='red'>peo</font>.`{=html}

## Basicas 2

[El signo + indica que el carácter que le precede debe aparecer *al
menos* una vez]{.underline}\
**ho+la** encontraría: *hola, hoola, hooola*.\
\
[En cambio el signo \* indica que puede o no aparecer una o más
veces]{.underline}\
**0\*42** encontraría: *42, 0042, 042*.\
\
[? indica que ha de aparecer 0 o una vez el carácter que le
precede]{.underline}\
**cas?quivano** encontraría *caquivano y casquivano*.\
\
[Los paréntesis indican \'agrupar\']{.underline}\
Por ejemplo **(p\|m)adre** encontraría tanto *padre* como *madre*. O
**(des)?amor** encontraría *amor* y *desamor*.\
\
[Los corchetes]{.underline}\
Son usados para elegir entre dos letras **\[tT\]he** encontraría *the,
The* pero no tHe.\
Para indicar rangos **\[a-z\]** encontraría todas las minusculas,
**\[a-zA-Z\]** todas las letras, mayusculas o minusculas. Por ejemplo:
**\[a-zA-B\]ola** encontraría *aola, cola, mola, Bola, bola\...* pero no
4ola, Cola, %ola\... Otro rango sería el **\[0-9\]**, o simplemente
indicar los carácteres (para signos especiales no son necesarios el
carácter de escape): **\[x.+3\]avier**, encontraría *xavier, +avier,
.avier, 3avier*.\
\
[Grupos]{.underline}\
Existen palabras que agrupan conjuntos de carácteres, por ejemplo los
que encuentran números y letras, espacios en blanco\... *- Esto no es
compatible con todos los sistemas -*.

-   **\[:alnum:\]** alfanuméricos (letras y números)
-   **\[:alpha:\]** alfabéticos (letras)
-   **\[:cntrl:\]** de control
-   **\[:digit:\]** dígitos
-   **\[:graph:\]** gráficos
-   **\[:lower:\]** minúsculas
-   **\[:print:\]** imprimibles
-   **\[:punct:\]** de puntuación
-   **\[:space:\]** espacios
-   **\[:upper:\]** mayúsculas
-   **\[:xdigit:\]** dígitos hexadecimales

\
[Repeticiones]{.underline}\
En un texto como este:

    Xooo
    oXoo
    ooXo
    oooX

**o{3}** encontraría:
`X<font color='red'>ooo</font> y <font color='red'>ooo</font>X`{=html}\
**o{2,3}** , dos o tres o\'s, encontraría:
`X<font color='red'>ooo</font> oX<font color='red'>oo</font> <font color='red'>oo</font>Xo <font color='red'>ooo</font>X`{=html}
; que es lo mismo que encontraría **o{2,}**, es decir, 2 o más.\
\
[Algunas expresiones regulares]{.underline}\
\*\* \_.\*\_ \*\* La cadena máxima que esté entre dos signos: \'\_\'. Es
decir, cogería frases enteras, algo así: \"\_hola \_caracola\_ qué haces
aquí tan sola?\_\"\
**\_(.\*?)\_** Cogería palabras sueltas: \"\_caracola\_\"\

## Xtra

-   **(?!pattern)** Mira si no cumple con el patrón.

## Ejemplos

## Archivos y artículos

-   ![Artículo de la wikipedia](/otros/regex/regex_in_wikipedia.pdf)
-   `<a href="./myfiles/otros/regex/video_regex.rar">Video</a>`{=html}
-   Cheat Sheet:\

![cheat sheet](/otros/regex/regular_expressions_cheat_sheet.png)
