# Conceptos matemáticos

-   [Ejemplos de este apartado](/numbers/maths/examples)

## Matemáticas básicas

### Combinaciones y permutaciones

En las combinaciones no importa el orden (ensalada combinación de frutas
y verduras), en cambio sí que importa en las permutaciones (la
combinación de la caja fuerte es realmente una permutación).

-   <http://www.disfrutalasmatematicas.com/combinatoria/combinaciones-permutaciones.html>

#### Permutaciones con repetición

Cuando tienes *n* opciones y se ha de elegir *r* veces las permutaciones
posibles son:\
\<m\>n\^r\</m\>\
Por ejemplo una cerradura de 3 dígitos, 10 números a elegir:\
\<m\>10\^3 = 1000\</m\>

#### Permutaciones sin repetición

Cuando tienes *n* elementos a colocar. No se puede colocar un elemento
más de una vez. Las permutaciones posibles son:\
\<m\>n!\</m\> Por ejemplo de cuantas formas distintas podemos colocar a
5 personas:\
\<m\>5! = 120\</m\>\

#### Permutaciones sin repetición en un subgrupo

Si tenemos *n* elementos y queremos ver cómo se podrían colocar un
subgrupo de *r* de estos elementos (escogiendo siempre uno distinto).
Las permutaciones posibles son:\
\<m\>{n!} / {(n-r)!}\</m\>\
Por ejemplo, tenemos 10 personas y 2 premios a dar, el número de formas
en el que lo podríamos dar los podríamos dar:\
\<m\>{10!}/{8!} = 90\</m\>

#### Combinaciones sin repetición

Un ejemplo sería el de los números de la lotería\...

#### Combinaciones con repetición

### Funciones

Las funciones *f(x)* son conversores de un número real a otro. Cada
valor de *x* es mapeado en un resultado, por ejemplo, *f(x) = 0* mapea
todos los números a 0. Las funciones más importantes son\...

#### Funciones lineales

\<m\>f(x) = ax\</m\>\
Donde *a* es un factor constante que es el *slope*, si x incrementa en 1
entonces *f(x)* se incrementa en *a*.

#### Potencias

\<m\>f(x) = x\^k\</m\>\
![](/numbers/potencias.png){width="800"}\

  ------------------ ------------- -------- ------------- -------- ------------- ---------- ----- -------- ----- ---------
  \<m\>sqrt(x) = x   {1/2}\</m\>   \<m\>x   n x           m = x    {n+m}\</m\>   \<m\>x     n x   -m = x   n/x   m\</m\>
  \<m\>x             0 = 1\</m\>   \<m\>x   1 = x\</m\>   \<m\>x   -1 = 1/{x     n}\</m\>                        
  ------------------ ------------- -------- ------------- -------- ------------- ---------- ----- -------- ----- ---------

#### Polinomios

\<m\>p(x) = a_1 x\^1 + a_2 x\^2 + \... + a_n x\^n\</m\>\
Los polinomios son sumas de potencias multiplicadas por coeficientes
constantes.\
La potencia mayor es el grado del polinomio.

#### Logaritmos

:!:\
\<m\>3\^4 = 81 right log_3 81 = 4\</m\>\
\<m\>log_i z = {ln(z)}/{ln(i)}\</m\>

### Ponderar

Consiste en equilibrar un valor.\
Imaginemos por ejemplo que queremos diferenciar el coste de un viaje que
hace una furgoneta, en ello influye la distancia (en un 80%) y el peso
que el vehículo lleva (en un 20%). Para saber pues el coste sólo tenemos
que *ponderar* por dos constantes para dar estos pesos (0.8 y 0.2):

-   *Caso 1*: Furgoneta que recorre 3km con un peso de 10kg -\>
    `coste = (3*0.8) + (10*0.2) = 4.4`
-   *Caso 2*: Furgoneta que recorre 5km con un peso de 1kg -\>
    `coste = (5*0.8) + (1*0.2) = 4.2`

Los valores no siempre han de sumar 1.

### Radianes

El radián es el ángulo necesario para conseguir un arco de longitud
igual al del radio de una circunferencia.\
\
![](/numbers/radian.png){.align-center width="150"} Su símbolo es
\<m\>rad\</m\>. Y su equivalencia\...\
\<m\>1rad = {360º}/{2 pi} = {180º} / pi approx 57º17\'45\"\</m\>\
\
\<m\>1º = {2 pi}/360 = {2 pi} /{180º} approx 0,01745\</m\>\
\
Es decir:\
\<m\>radian = {angulo} pi/180\</m\>\
\<m\>angulo = {radian}180/pi\</m\>\
![Tabla de
equivalencias](/numbers/tabla_equiv_rad-grad.png){.align-center
width="500"}

-   ![Explicación de radianes](/numbers/radianes.rar)

```{=html}
<!-- -->
```
    #define RadsToDegrees( radian ) ((radian) * (180.0f / M_PI))
    #define DegreesToRads( degrees ) ((degrees) * (M_PI/ 180.0f))

## Trigonometría

Antes de nada tengamos claros un par de conceptos:\

-   Los catetos en un triangulo rectángulo son los lados que forman el
    ángulo recto, el otro lado es llamado hipotenusa.
-   **Teorema de pitágoras**: //En un triángulo rectángulo, la suma del
    cuadrado de los catetos es igual al cuadrado de la hipotenusa. //Es
    decir, \<m\>a\^2 + b\^2 = h\^2\</m\> siendo a y b los catetos y h la
    hipotenusa.

E indicar donde están los ejemplos:

-   [Ejemplos de
    Trigonometria](/numbers/maths/examples#ejemplos_trigonometria)

### Funciones trigonométricas

Teniendo el siguiente triángulo:\
![](/numbers/triangulo.png){width="300"}\

  ---------------------------------------------------------- --------------------------------------------------------- ----------------------------------------------------------
  \<m\>sin alpha = y / r = {cat opuest} / hipotenusa\</m\>   \<m\>cos alpha = x / r = {cat adyac} / hipotenusa\</m\>   \<m\>tan alpha = y / x = {sin alpha} / {cos alpha}\</m\>
  \<m\>cot alpha = x / y = 1 / {tan alpha}\</m\>             \<m\>sec alpha = r / x = 1 / {cos alpha}\</m\>            \<m\>csc alpha = r / y = 1 / {sin alpha}\</m\>
  ---------------------------------------------------------- --------------------------------------------------------- ----------------------------------------------------------

Algunas igualdades que tenemos que tener en cuenta:

  ----------------------- ------------------------- ------------------------------- ----------------------------------
  \<m\>sin 0 = 0\</m\>\   \<m\>sin pi = 0\</m\>\    \<m\>sin 1.5 pi = -1\</m\>\     \<m\>sin 2 pi = sin 0 = 0\</m\>\
  \<m\>cos 0 = 1\</m\>\   \<m\>cos pi = -1\</m\>\   \<m\>cos 1.5 pi = 0\</m\>\      \<m\>cos 2 pi = cos 0 = 1\</m\>\
  \<m\>tan 0 = 0\</m\>    \<m\>tan pi = 0\</m\>     \<m\>tan 1.5 pi = infty\</m\>   \<m\>tan 2 pi = tan 0 = 0\</m\>

  ----------------------- ------------------------- ------------------------------- ----------------------------------

#### Seno

![](/numbers/600px-ondasenoidal3.svg.png){width="400"}
![](/numbers/650px-funtrir100.svg.png){width="400"}

#### Coseno

![](/numbers/800px-funtrir010.svg.png){width="400"}

#### Tangente

Teniendo en cuenta que la tangente es \<m\>{cateto opuesto}/{cateto
contiguo}\</m\> entonces la tangente de 90º es \<m\>infty\</m\>:\
\
\<m\>tan(90) = {sen(90)}/{cos(90)} = 1/0 = infty\</m\>

### Identidades trigonométricas

Son igualdades con operaciones trigonometricas que se cumplen para
cualquier valor de \<m\>alpha\</m\>.\
Entre otras tenemos:\
\<m\>sin alpha \* csc alpha = 1\</m\>\
\
\<m\>cos alpha \* sec alpha = 1\</m\>\
\
\<m\>tan alpha \* cot alpha = 1\</m\>\
\
\<m\>sin\^2 alpha + cos\^2 alpha = 1\</m\>\
\

## Sistemas de coordenadas

Es un conjunto de valores y posiciones que permiten definir de forma
inequivoca una posición en un espacio.

### Coordenadas cartesianas

Se subdivide en\...

-   Sistema de coordenadas en la recta, cuando es de dimensión 1, es
    decir, cuando las operaciones se realizan en el eje *x*.
-   Sistema de coordenadas en el plano. Cuando es de dimensión 2; un
    punto en este sistema se compone de dos coordenadas *x* e *y*.
-   Sistema de coordenadas en el espacio. Cuando es de dimensión 3,
    donde un punto se compone de tres coordenadas *x*, *y* y *z*.

### Coordenadas polares (o cilindricas)

![](/numbers/coordpolar.png){width="250"}\
En este sistema, un punto **P** es representado por los valores **r** y
\<m\>alpha\</m\>.\
La transformación de las coordenadas *x* e *y* de un sistema cartesiano
corresponden a los valores\...\
\<m\>x = r cos alpha\</m\>\
\<m\>y = r sin alpha\</m\>\
\... de un sistema de coordenadas polares.

-   Mira el ejemplo 1 de [sistemas de
    coordenadas](/numbers/maths/examples#ejemplos_de_sistemas_de_coordenadas).

En un sistema de coordenadas polares para medir ángulos utilizamos
radianes en vez de grados.\
La longitud del ángulo de rotación la calculamos como: `α · radio`.

### Coordenadas esféricas

![](/numbers/coordesf.png){width="250"}\
Las coordenadas *x, y, z* de un sistema cartesiano, se representan en un
sistema esférico mediante *r*, \<m\>alpha\</m\>, \<m\>beta\</m\>. Siendo
\<m\>beta\</m\> llamado el ángulo polar, que satisface la siguiente
igualdad: \<m\>0 \<= beta \<= pi\</m\>.\
Las coordenadas cartesianas pasan a ser esféricas mediante:\
\<m\>x = r sin beta cos alpha\</m\>\
\<m\>y = r sin beta sin alpha\</m\>\
\<m\>z = r cos beta\</m\>\

## Geometría

### Conceptos

#### Tipos de polígonos

  --------------------------------------- ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
  ![](/numbers/convexo.png){width="80"}   **Polígono convexo** es aquel en el que todos sus ángulos interiores miden menos de 180 grados, esto hace que cualquier recta que pase por un lado de un polígono convexo deja a todo el polígono completamente en uno de los semiplanos definidos por la recta.
  ![](/numbers/concavo.png){width="80"}   **Polígono cóncavo** es aquel en el que al menos uno de sus ángulos interiores mide más de 180 grados.
  --------------------------------------- ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------

### Distancia entre dos puntos

#### Distancia Euclídea

Teniendo dos puntos, \<m\>P_1 = (x_1, y_1)\</m\> y \<m\>P_2 = (x_2,
y_2)\</m\>. La distancia Euclídea se define como: \<m\>sqrt{(x_1 -
x_2)\^2 + (y_1 - y_2)\^2}\</m\>, es decir,
\<m\>d=sqrt{sum{i=1}{n}{}(p_1 - q_1)\^2 + (p_2 - q_2)\^2 + \... + (p_n -
q_n)\^2}\</m\>, es decir, \<m\>d=sqrt{sum{i=1}{n}{}(p_i -
q_i)\^2}\</m\>\
![](/numbers/euclidean.gif)

#### Distancia Manhattan

Teniendo dos puntos, \<m\>P_1 = (x_1, y_1)\</m\> y \<m\>P_2 = (x_2,
y_2)\</m\>. La distancia Manhattan se define como: \<m\>delim{\|}{x_1 -
x_2}{\|} + delim{\|}{y_1 - y_2}{\|}\</m\>, es decir,
\<m\>sum{i=n}{n}{}delim{\|}{p_i - p_i}{\|}\</m\>\
![](/numbers/manhattan.gif)

### Ecuación de una recta

La ecuación de una recta es:\
\<m\>y = mx + b\</m\>\
Donde *m* es la pendiente (o en inglés *slope*) de la recta, es decir el
ángulo, y *b* es el punto donde la recta cruza con el eje y, es decir,
(0, b).\
\
La pendiente mide el cambio vertical en función del cambio horizontal o,
en otras palabras, cual es el ratio de crecimiento en el tiempo. Para
encontrar la pendiente de una recta teniendo dos puntos haremos:\
\<m\>m = (y_2 - y_1)/(x_2 - x_1)\</m\>

#### Un ejemplo

Queremos saber la ecuación de la recta que pasa por los puntos (--2, 4)
y (1, 2).\
Primero buscaremos la pendiente: \<m\>m = {4 - 2}/{-2-1}=-2/3\</m\>\
Luego buscaremos la b, para cualquiera de los dos puntos, por ejemplo
(-2, 4): \<m\>4 = (-- 2/3)(--2) + b =\> b = 8/3\</m\>\
Es decir, la ecuación de la recta es: \<m\>y = (-- 2/3)x + 8/3\</m\>

#### Notas

-   Dos rectas serán perpendiculares cuando el producto de las
    pendientes de como resultado -1.
-   ![Código fuente sobre cómo hacer una línea y su
    perpendicular](/numbers/line.zip).

## Notas

-   Cuando hablamos de un escalar hablamos de un número cualquiera en
    \<m\>bbR\</m\>.
-   Nombree de las letras griegas comunmente utilizadas:

![](/numbers/alfabeto.gif)

### Trucos matemáticos

-   Si queremos saber `X%` de `Y` haremos: `Y * (X / 100)`.

#### Calculo de raíz cuadrada por método Newton

Código en Scala:

``` scala
def abs(x: Double) = if (x > 0) x else -x 

def sqrtIter(guess: Double, x: Double): Double =
  if (isGoodEnough(guess, x)) guess
  else sqrtIter(improve(guess, x), x)

def isGoodEnough(guess: Double, x: Double) =
  abs(guess * guess - x) < 0.0001

def improve(guess: Double, x: Double): Double =
  (guess + x / guess) / 2 

def sqrt(x: Double) = sqrtIter(1.0, x) 

sqrt(4)  
```
