# Octave

[Página del proyecto](http://www.gnu.org/software/octave/)\
\
Octave es un lenguaje de programación enfocado a las matemáticas y con
sintaxis parecida (o idéntica) a la de [MATLAB](/math_langs/matlab).\
\
[QtOctave](http://qtoctave.wordpress.com/what-is-qtoctave/) es el
entorno para Octave que emula al de MATLAB.

## Básico

### Funciones básicas

-   `help command`, muestra la ayuda para un comando.

### Matrices

``` matlab
A = [1 2 3]                 % Matriz de una fila y tres columnas
B = [1; 2; 3]                   % Matriz de tres filas y una columna
C = [1 2; 3 4; 5 6]             % Matriz de tres filas y dos columnas
D = A * B                   % Multiplicación de las matrices A y B
```

#### Funciones

-   `rand(n, m)`, crea una matriz de `n` filas por `m` columnas.
-   `pinv(A)`, crea la matriz inversa de `A`.

### Ecuaciones

``` matlab
function y = f(x)
  y = x^3 + x^2 - 3*x - 3
endfunction
fsolve("f", 1.)
```

``` matlab
function g = h (x)
  g(1) = -2*x(1)^2 + 3*x(1)*x(2)   + 4*sin(x(2)) - 6;
  g(2) =  3*x(1)^2 - 2*x(1)*x(2)^2 + 3*cos(x(1)) + 4;
endfunction
fsolve ("h", [1; 2])
```
