# Processing

Es un lenguaje open source basado en java enfocado a la \"programación
visual\" y de dispositivos electrónicos; su principal meta es la de
permitir a los programadores novatos aprender fácilmente viendo un
resultado rápido de sus programas. Se desarrolla sobre un IDE denominado
*sketchbook* y a los programas *sketches* (de *sketch*) que realmente es
una clase derivada de la `PApplet` de Java.\
\
Cuando programas en Processing todas las clases adicionales que se
añadan se traducirán como clases anidades al compilarlo en Java. Y, por
lo tanto, no se podrán utilizar las variables y métodos estáticos (a no
ser que indique explicitamente).

## Básico

Una vez tengas abierto el editor podrás escribir código directamente,
sin necesidad de crear ninguna función o clase:

``` java
fill(0,0,255);
rect(0,0,100,100);
print("Now YES! We can!");
```

La acción de ejetuar este código lo que hace es traducirlo a una clase
Java que luego es compilada. Esta clase puede ser utilizada como Applet
en una página web o como aplicación\\presentación en el escritorio.\
Cuando queramos cargar elementos (imágenes, vídeos\...) deberemos crear
una carpeta denominada `data` en el mismo directorio que el fichero .pde
de processing, ahí será donde la aplicación vaya a buscarlo.

### Código

#### Creación de una clase

``` java
class Point {
  float x;
  float y;
  Point (float _x, float _y) {
    x = _x;
    y = _y;
  }
}
```

#### Array

``` java
Point[] pts = new Point [5];
```

### Una aplicación de Processing

Hay dos funciones fundamentales en una aplicación de *Processing*, la
primera es `setup()` que el código que contiene será el primer código
que se ejecute cuando inicie una aplicación, la segunda es `draw()` que
se llama repetidas veces mientras la aplicación esté en funcionamiento.
Podríamos decir que la función `setup()` es la que se utiliza para
inicializar el programa y la `draw()` lo que ocurre en cada frame.

#### Funciones

-   `void size(width, height)`, indica el tamaño (en pixels) que tendrá
    la aplicación.
-   `void frameRate(fr)`, determina el número de frames por segundo que
    mostrará tu aplicación (cuántas veces en un segundo se llamará al
    método draw).
-   `void print (data)`, muestra un mensaje por la consola del IDE de
    Processing.

``` java
int i = 0;

void setup () {
  size(300, 300);
  frameRate(1);
}

void draw () {
  print (i + "\n");
  i++;
}
```

-   `void noLoop()` indica que no se haga un redibujado, sino que sea
    sólo una ejecución.

### Dibujo

-   `void rect(x,y,width,height)`
-   `void ellipse(x,y,width,height)`
-   `void line(x1,y1,x2,y2)`

#### Colores

Los colores en *Processing* se definen en formato hexadecimal, el
compilador entiende tanto el formato `0xFF00FF` como el `#FF00FF`.\
Si quisieramos utilizar RGB (con 255 posibles valores para cada color)
llamaríamos a la función `color(R,G,B)` devuelve un objeto del tipo
`color`.\
También podemos indicar el alpha, por ejemplo para un azul con el 50% de
alpha haríamos: `0x800000FF`.

#### Función fill()

Define el color con el que *Processing* dibujará las próxias figuras.
Tiene las siguientes sobrecargas:

-   `fill (gray)`, indica un valor de gris de 0 a 255.
-   `fill (gray, alpha)`
-   `fill (R, G, B)`, valores de 0 a 255.
-   `fill (color)`, pasándole un objeto del tipo `color`.
-   `fill (color, alpha)`
-   `fill (hex)`
-   `fill (hex, alpha)`

#### Funciones avanzadas de dibujo

-   `background()`, indica el color del fondo de la aplicación (utiliza
    la misma sobrecarga que `fill`).
-   `line(x1, y1, z1, x2, y2, z2)` dibuja una línea 3D.
-   `stroke(color)`, indica el color de las líneas.
-   `strokeWeight(weight)`, indica el ancho de las líneas.
-   `curve(x1,y1,x2,y2,x3,y3,x4,y4)` (también existe una sobreescritura
    para las 3 dimensiones con z1, z2, z3 y z4).
-   `beginShape()` y `endShape()` permiten dibujar formas personalizas
    utilizando las funciones `vertex()` y `curveVertex()`. Por ejemplo
    para dibujar una línea\...

``` java
void setup () {
  size(300, 300);
}

void draw () {
  background(255);
  fill(0);
  beginShape();
  vertex(0,0);
  vertex(300,300);
  endShape();
}
```

#### Texto

-   `PFont createFont(string, int)` carga una fuente del sistema.
-   `void textFont (PFont , int)` indica qué fuente es la que se
    utilizará para escribir.
-   `text (string, intX, intY)` escribe un texto.

``` java
PFont arial;

void setup () {
  size (300, 300);
  arial = createFont("Arial", 32);
  textFont(arial, 15);
}

void draw () {
  background(0);
  text (mouseX + " " + mouseY, mouseX, mouseY);
}
```

### Interactuando con el usuario

#### Mouse

Para saber las coordenadas actuales del mouse existen dos variables
globales: `mouseX` y `mouseY`.\
Podemos agregar una función llamada `void mousePressed()`, esta se
ejecutará cada vez que el botón del ratón se pulse.\
La función `void mouseReleased()` será llamada cuando se deje de pulsar
el botón del ratón.\
La función `void mouseDragged()` se llamará cuando se esté moviendo el
mouse con el botón pulsado, dentro de esta función existirán las
variables `pmouseX` y `pmouseY` que indicarán cuando se inició el
*drag*.

``` java
void setup () {
  size (300, 300);
}

void draw () { }

void mouseDragged () {
  line(pmouseX, pmouseY, mouseX, mouseY);
}
```

#### Teclado

La función `void keyPressed()` se llamará cuando el usuario pulse una
tecla.\
Existen dos variables globales para el uso del teclado en una aplicación
de *Processing*, la `keyPressed` que indica si hay una tecla pulsada y
la `key` que indica qué tecla es.

``` java
void setup () { }

void draw () {
  if (keyPressed)
    print(key);
}
```

### Otros básicos

#### Librerías

En en [el apartado de
librerías](http://processing.org/reference/libraries/) de la web de
*processing* podrás encontrar librerías disponibles para este lenguaje
en formato *.jar* y existen de todo tipo (para controlar el audio, el
WiiMote\...). Una vez las descargues sólo has de descomprimir el archivo
en la carpeta *libraries* de processing.

#### Imágenes

Recuerda colocar las imágenes en la carpeta `data`, luego tendrás que
utilizar la clase `PImage` para almacenar una imágen cargada mediante
`loadImage()` y dibujarla mediante la función `image()`.

``` java
PImage img;
void setup () {
  img = loadImage ("image.png");
  size(300,300);
}

void draw () {
  background(0);
  image (img, mouseX, mouseY);
}
```

#### Archivos

Los archivos a leer han de estar en la carpeta `data`. Existen dos
funciones para recopilar información de archivos: Con `loadStrings()`
cargamos un archivo de texto en un array de strings (también podríamos
hacer lo contrario, guardar un array de strings como archivo de texto,
con `saveStrings`). Con `loadBytes()` cargamos datos binarios.

``` java
void setup () {
  String[] txt = loadStrings("file.txt");
  for (int i=0; i<txt.length; i++) {
    print (txt[i] + "\n");
  }
  saveStrings ("data/copy.txt", txt);
}
```

La función `loadStrings()` acepta una url, esta puede ser de un archivo
online.

``` java
loadStrings("http://www.prueba.com/data.php");
```

#### Transformaciones

Como ocurre con [OpenGL](/fw/ogl) podemos realizar transformaciones
geométricas sobre la vista para que lo dibujado se muestre alterado
según esta.\
Para ello utilizamos las funciones `pushMatrix`, para iniciar una
transformación, y `popMatrix` para acabarla.\
Las funciones de transformación son:

-   `translate(x,y)`, para realizar una traslación.
-   `rotate(angle)`, para realizar una rotación. `Angle` tiene que estar
    dado como radianes.
-   `scale(fValue)`, para realizar un escalado.

``` java
int ang = 0;

void setup()
{
  size(200,200);
}

void draw()
{
  background(255);
  stroke(128);
  strokeWeight(3);
  pushMatrix();
  translate(100,100);
  rotate(radians(ang));
  rect(-40, -40, 80, 80);
  popMatrix();
  ang++;
}
```

### Otras funciones

-   `saveFrame` para guardar el frame actual como imágen.
-   Remarcar también que podemos acceder a las variables `height` y
    `width` que nos indicarán el tamaño actual de la ventana.

#### Funciones matemáticas

-   `sqrt(number)`: Devuelve la raíz cuadrada del número.
-   `pow(number, exponent)`: Eleva el número al exponente dado.
-   `radians(angle)`: Devuelve los radianes de un ángulo expresado en
    grados.
-   `degrees(radians)`: Devuelve los grados de un ángulo expresado en
    radianes.

### Otras clases

#### PVector

La clase `PVector` nos facilita las operaciones con vectores mediante el
uso de sus métodos Métodos:

-   `set()`, asigna los valores para la x, la y y la z del vector.
-   `get()`, recoge los valores de la x, la y y la z.
-   `mag()`, calcula la magnitud (tamaño) del vector.
-   `add()`, suma otro vector al vector.
-   `sub()`, resta un vector al vector.
-   `mult()`, multiplica el vector por un escalar.
-   `div()`, divide el vector por un escalar.
-   `dist()`, calcula la distancia euclidea entre dos puntos.
-   `dot()`, calcula el producto escalar.
-   `cross()`, calcula el producto cruzado.
-   `normalize()`, normaliza un vector.
-   `limit()`, limita la magnitud del vector.
-   `angleBetween()`, calcula el ángulo entre dos vectores.
-   `array()`, retorna la representación del vector como un array.

El siguiente código\...

``` java
float x = 100;
float y = 100;
float xspeed = 1;
float yspeed = 3.3;
x = x + xspeed;
y = y + yspeed;
```

Podríamos llegar a escribirlo como\...

``` java
PVector location = new PVector(100, 100);
PVector velocity = new PVector(1, 3.3);
location.add(velocity);
```

## Avanzado

## Otros

### Como\...

#### Trucos gráficos

-   Para crear **motion blur**, en cada frame en vez de indicar \"borrar
    todo el backgraund\" lo que haríamos es dibujar un cuadrado blanco
    pero con alpha:

``` java
void draw() {
  // backgraund(255);
  noStroke();
  fill(255,10);
  rect(0,0,width,height);
  // Rutina de dibujo
```

### Ejemplos

-   ![Mapa de elecciones](/highlevel/processing/electionmap.zip), carga
    un SVG y lo edita dinámicamente.

### Links

-   <http://processing.org/>
-   <http://processing.org/reference/>
