# Unity 3D plugins

## AdMob Plugin

Plugin para añadir publicidad a los juegos, existe para Android y para
iPhone. It\'s a plugin to add advertising banners into the games. There
are two versions, Android and iOS:

-   [Android](https://code.google.com/p/google-mobile-dev/downloads/detail?name=UnityPlugin_Android_1.0.zip)
-   [iOS](https://code.google.com/p/google-mobile-dev/downloads/detail?name=UnityPlugin_iOS_1.1.zip)
-   [Presentation](http://googleadsdeveloper.blogspot.com.es/2013/07/admob-plugin-for-unity3d.html)

Each one of them has a README file. Fundamentally to install it you\'ll
need to go to Assets option menu and Import asset package. Last step to
use it is to drag the prefab into the scene (inside Plugins/AdMobPlugin
folder).

Main functions:

-   `AdMobPlugin.CreateBannerView ("AD_UNIT_ID", AdMobPlugin.AdSize.Banner, bool);`
    creates the banner, the bool value tells if it will be placed
    horizontal or vertically.
-   `AdMobPlugin.RequestBannerAd(bool, string);`, the bool tells if it
    is needed to add extra features to the banner. They will be assigned
    via JSON through the string value.
-   `AdMobPlugin.HideBannerView();` hides the banner.
-   `AdMobPlugin.ShowBannerView();` shows a hidden banner.

It also allows to register the next events:

``` csharp
public static event Action ReceivedAd;
public static event Action<string> FailedToReceiveAd;
public static event Action ShowingOverlay;
public static event Action DismissedOverlay;
public static event Action LeavingApplication;
```

## SimpleJSON

-   [Documentation](http://wiki.unity3d.com/index.php/SimpleJSON)

To parse to\\from JSON data.

## UniBill

-   [Documentation](http://outlinegames.com/unibill-documentation/)

It\'s a plugin to implement the payments platforms to adquire money from
your game at any moment.

## Uniject

-   [Documentation and source
    code](https://github.com/banderous/Uniject)

Plugin to make unit tests, dependency injection and inversion control
over Unity3d project.

## Google Play Games

-   [Source
    code](https://github.com/playgameservices/play-games-plugin-for-unity)

Also called PGP Plugin, it allows to take profit from Google Play Games
platform and its services.
[Here](https://developers.google.com/games/services/) is the oficial
webpage where its capabilities are listed. It interacts with the unity
social API to provide an unified platform.

## Anti-Cheat Toolkit

-   [Presentation](http://blog.codestage.ru/unity-plugins/act/)
-   [In assets
    store](https://www.assetstore.unity3d.com/#/content/10395)

It\'s a plugin to hide values in memory and in disk, this way they are
not so easy to hack and access them. It allows to crypt type values like
bool, byte, uint, int, float, double, string or Vector3. Also
PlayerPrefs can be hidden.

## GameAnalytics

-   [In assets store](https://www.assetstore.unity3d.com/#/content/6755)
-   [In GitHub](https://github.com/GameAnalytics/GA-Unity-SDK)
-   [Official page](http://www.gameanalytics.com/)
-   [Instructions](http://support.gameanalytics.com/hc/en-us/articles/200841316-Download-and-setup)

This plugins sends data to gameanalytics.com, which offers you a
dashboard where game statiscs are shown.

To install it you\'ll need to go to Assets\>Import Package\>Custom
Package and browse to the package location on your hard disk. Leave all
the files checked and click "Import".

## TouchScript

-   [Source Code](https://github.com/InteractiveLab/TouchScript)
-   [Documentation](http://interactivelab.github.io/TouchScript/tutorials.internals.html)

To detect hand gestures

## NGUI

-   [Web page](http://www.tasharen.com/?page_id=140)
-   [Documentation](http://www.tasharen.com/ngui/docs/)

### Start with NGUI

First of all you should copy the NGUI folder into the Assets folder.
Open the unity interface an `Ctrl+R`.

To create an interface you will need to do
`Main Menu -> NGUI -> Create -> 2D UI`. It will create a new camera
which you should put into a new layer.

You will add widgets to the scene, then attach a label script, a button
script, etc.

### Atlas

An atlas is an image file which contains several other subimages that
can be rotated and disorganized to optimize space. It\'s used as unique
texture\\image for game elements, it\'s generated a text file which is
attached to the atlas to indicate image coordinates and orientation. It
improves the performance in the graphics engine when use it as a simple
texture for several elements.

In NGUI you can create an Atlas using the Atlas Maker tool and adding
sprites to it, then you will create a material. This material will be
assigned to the NGUI widgets (buttons, 2d sprites\...) and it will be
specified which sprite is the selected one.

#### Notes

-   The render mode for atlas is given into the UIAtlas settings menú.

### How to\...

#### Make a label follow a GameObject

Being in the GameObject script\...\
Being the guiCamera the NGUI camera\...\
Being the continueLabelPosition variable for margins in the image\...\

``` csharp
Vector3 pos = Camera.main.WorldToViewportPoint(transform.position);
theLabel.transform.position = guiCamera.ViewportToWorldPoint(pos + continueLabelPosition);
pos = theLabel.transform.localPosition;
pos.x = Mathf.RoundToInt(pos.x);
pos.y = Mathf.RoundToInt(pos.y);
pos.z = 0f;
theLabel.transform.localPosition = pos;
theLabel.text = (GameManager.instance.continueTimeLeft-1).ToString();
```
