# Qt4

-   [Documentación](http://doc.qt.digia.com/stable/index.html)
-   [Lista de clases](http://doc.qt.digia.com/stable/classes.html)

## Conceptos

### Clases importantes

-   `QApplication`, es la clase que gestiona el bucle principal de una
    aplicación con GUI y todo lo que lo envuelve (inicialización de la
    aplicación, finalización, sesión\...).
-   `QCoreApplication`, es la clase que gestiona una aplicación Qt sin
    GUI.

#### QStrings

Para trabajar con strings, si queremos mostrarlos por consola haremos
(el segundo necesita incluir `QTextStream`):

``` cpp
std::cout << qPrintable(d.getValue()) << std::endl;
QTextStream(stdout) << d.getValue();
```

Para compararlos:

``` cpp
int x = QString::compare("aUtO", "AuTo", Qt::CaseInsensitive);  // x == 0
int y = QString::compare("auto", "Car", Qt::CaseSensitive);     // y > 0
int z = QString::compare("auto", "Car", Qt::CaseInsensitive);   // z < 0
```

#### Leer archivos

``` cpp
QFile file("/home/hamad/lesson11.txt");
if(!file.open(QIODevice::ReadOnly)) {
    QMessageBox::information(0, "error", file.errorString());
}
QTextStream in(&file);
while(!in.atEnd()) {
    QString line = in.readLine();    
    QStringList fields = line.split(",");    
    model->appendRow(fields);    
}
file.close();
```

### El sistema de meta-objetos

Es el procedimiento que Qt tiene de trabajar. Es el que añade al sistema
de C++ la capacidad de utilizar signals y slots, información en tiempo
de ejecución y propiedades dinámicas. En el entran en juego los
siguientes elementos:

-   Clase `QObject`, clase base para los objetos Qt.
-   Macro `Q_OBJECT` que se añade a la clase y activa las propiedades de
    los meta-objetos en dicha clase.
-   El `moc` (compilador de meta-objetos).

El `moc` lee los ficheros C++ y para las declaraciones `Q_OBJECT`
produce archivos C++ que serán los que se acabarán siendo compilados por
el compilador.

#### El moc

#### QObject

Métodos de un QObject:

-   `metaObject()` retorna el meta-objeto asociado.
-   `className()` retorna un string con el nombre de la clase en tiempo
    de ejecución.
-   `inherits()` función que retorna si un QObject es una instancia de
    una clase dentro del árbol de herencia.
-   `tr()` y `trUtf8()` para traducir strings en utf8.
-   `setProperty()` y `getProperty()` para dar valores a propiedades a
    partir de su nombre.
-   `newInstance()` construye una nueva instancia de la clase.

#### Problemas con los que te puedes encontrar

-   Si hay errores de referencias no definicas al compilar es posible
    que no se esté utilizando correctamente el moc.
-   Si otras librerías implementan varialbes llamadas `signals` o
    `slots` puede que al compilar hayan errores. Para evitarlos se ha de
    utilizar el símbolo de preprocesador `#undef`.

### Signals y Slots

Es la forma que tiene Qt de manejar los eventos. Un `signal` se emite
cuando un evento concreto ocurre, un `slot` es una función que se llama
cuando ese signal se ha producido.

-   La definición de un signal ha de coincidir con la del slot que la
    recibe.
-   Las clases que hereden de QObject o de sus subclases pueden contener
    signals y slots.
-   Puedes conectar tantos slots a un signal como desees igual que un
    slot puede ser conectado a varios signals.
-   También es posible conectar un signal a otro, esto emitiría el
    segundo cuando el primero fuese llamado.
-   Los signals y slots se declaran en la clase en un apartado concreto
    para ellos.
-   La sintaxis para conectar un signal a un slot es la siguiente:

```{=html}
<!-- -->
```
    connect(&obj_signal, SIGNAL(funcionSignal(type_pars)), &obj_slot, SLOT(funcionSlot(type_pars));

-   Si no hay ningún slot conectado a un signal, cuando se emita el
    signal no ocurrirá nada.
-   Se pueden emitir signals usando la clausula `emit` de la siguiente
    forma `emit funcion_signal(pars)`.
-   Se pueden desconectar todos los slots de un signal utilizando la
    clausula `disconnect()`.
-   Se puede indicar que una conexión no puede duplicarse (un mismo slot
    conectado a un mismo signal varias veces) pasandole a `connect` el
    flag `Qt::UniqueConnection`. Cuando ocurra la conexión duplicada se
    retornará false.
-   Cuando el signal se emite los slots son ejecutados inmediatamente.
    Se pueden usar `queued connections` para que se ejecuten
    independientemente del curso de la aplicación.
-   Cuando se utiliza algún framework que tenga las clausulas `emit`,
    `signals` o `slot` declaradas podremos seguir utilizando las de Qt
    mediante las macros `Q_SIGNALS`, `Q_SIGNAL`, `Q_SLOT`, `Q_SLOTS` y
    `Q_EMIT`. Colocando en la configuración del proyecto lo siguiente:

```{=html}
<!-- -->
```
    CONFIG += no_keywords

-   Podemos pasar parámetros al a los slots según el objeto que lo llame
    utilizando la clase `QSignalMapper`.
-   Qt también da la posibilidad de acceder a un puntero al objeto que
    llamó a un slot mediante la función `sender()`.

Sintaxis de los apartados de signals y slots en la definición de una
clase:

``` cpp
class Counter : public QObject {
  Q_OBJECT
public:
  Counter() { m_value = 0; }
  int value() const { return m_value; }
public slots:
  void setValue(int value);
signals:
  void valueChanged(int newValue);
private:
  int m_value;
};
```

Sintaxis de una conexión:

``` cpp
Counter a, b;
QObject::connect(&a, SIGNAL(valueChanged(int)), &b, SLOT(setValue(int)));
```

## Componentes

### QWidget

Es la clase base para todos los objetos GUI. Recibe los eventos (ratón,
teclado\...) de la ventana y se pinta a sí mismo en la pantalla.\
Todo widget es rectangular y se ordena en Z-order en la ventana donde es
colocado. Si no se coloca en ninguna ventana entonces él mismo será la
ventana. Las ventanas tienen un frame y una barra de título (aunque se
pueden crear sin ellos). En Qt las clases especiales para crear ventanas
son `QMainWindow` y `QDialog`.\
El constructor acepta los siguientes argumentos:

1.  `QWidget *parent`, el widget padre, si es 0 (por defecto) el widget
    será una ventana.
2.  `Qt::WindowFlags f`, las flagas correspondientes a la ventana
    creada.

### QMainWindow

Es la ventana para la aplicación principal. Tendrá la siguiente
estructura (requerirá siempre deun widget central):\
![](/fw/qt4/mainwindowlayout.png){width="300"}\
Es decir, si queremos añadirle un layout lo que tendremos que hacer es
añadir un widget y a este el layout.

### QDialog

Es la base clase para crear ventanas de diálogo. Estas son utilizadas
para que el usuario realice pequeñas tareas. Pueden ser modales o no,
devolver un valor y tener botones por defecto.

-   El método `exec()` muestra el diálogo y hasta que no se cierre no
    continua con la ejecución. El `show()` sí continua.
-   El método\\signal `accept()` cerrará el formulario indicando que el
    usuario acepta.

### Menús principales y acciones

Para crear un menú dentro de una QMainWindow lo que haremos será llamar
a `menuBar()->addMenu()` que devolverá un objeto `QMenu` al cual
podremos añadir objetos `QAction` (acciones dentro del programa que se
pueden enlazar a menús, atajos de teclado\...).

Siendo `openDialog` y `exitAct` objetos `QAction` dentro de la clase,
`fileMenu` un objeto `QMenu`, y `createDialog` un slot público dentro de
esta también.

``` cpp
void MainWindow::createActions() {
    openDialog = new QAction("Hola", this);
    connect(openDialog, SIGNAL(triggered()), this, SLOT(createDialog()));
    exitAct = new QAction ("Exit", this);
    connect(exitAct, SIGNAL(triggered()), qApp, SLOT(closeAllWindows()));
}

void MainWindow::createMenus() {
    fileMenu = menuBar()->addMenu("File");
    fileMenu->addSeparator();
    fileMenu->addAction(openDialog);
    fileMenu->addAction(exitAct);
}

void MainWindow::createDialog() {
    std::cout << "abre!" << std::endl;
}
```

### Layouts

-   `QHBoxLayout` y `QVBoxLayout`, para colocar los controles uno al
    lado del otro en horizontal y en vertical respectivamente.

### Componentes para tratar con OpenGL

En la configuración ha de estar agregada la opción de trabajar con
opengl:

    QT       += core gui opengl

Y se ha de incluir `QtOpenGL`.

#### QGLWidget

Un objeto QGLWidget es un widget para renderizar gráficos OpenGL en
aplicaciones Qt. Se hereda de él y se usa la subclase como cualquier
QWidget. Las funciones para reescribir son:

-   `paintGL()`, que renderiza la escena OpenGL y se llama siempre que
    el widget necesita ser actualizado.
-   `resizeGL()`, para configurar el viewport, la proyección\... Se
    llama cada vez que el widget ha cambiado de tamaño.
-   `initializeGL()`, para inicializar el contexto de OpenGL.

Cómo hacer otras funciones con él:

-   Si necesitas lanzar un repintado has de llamar a `updateGL()`.
-   Si necesitas llamar a funciones OpenGL desde otros lugares (p.ej. el
    constructor), antes se ha de hacer una llamada a `makeCurrent()`.

#### QGLShaderProgram y QGLShader

`QGLShader` es la clase que recoge código GLSL para ser compilado y
`QGLShaderProgram` se encarga de realizar dicha compilación de los
diferentes shaders pasados (se han de crear durante la inicialización de
OpenGL).\
Debemos indicar en el constructor `QGLShader` qué tipo de shader es
(QGLShader::Vertex o QGLShader::Fragment).\
Para posteriormente pasar valores a los atributos de input a los shaders
debemos usar el método `bindAttributeLocation` pasándole el nombre de
este y su posición (antes de linkar el programa). Si no se enlazasen las
posiciones entonces serían cogidas automáticamente. Para lincar el
programa se utiliza `link()` y luego, para enlazarlo al contexto actual,
`bind()`.

``` cpp
QGLShader *vshader = new QGLShader(QGLShader::Vertex, this);
QGLShader *fshader = new QGLShader(QGLShader::Fragment, this);

// Se lee el contenido de dos ficheros de código glsl y se vuelcan sobre shader_source

vshader->compileSourceFile(vShaderFile); // De archivo

const char *fsrc =
         "uniform sampler2D texture;\n"
         "varying mediump vec4 texc;\n"
         "void main(void)\n"
         "{\n"
         "    gl_FragColor = texture2D(texture, texc.st);\n"
         "}\n";
fshader->compileSourceCode(fsrc);

QGLShaderProgram *program = new QGLShaderProgram(this);
program->addShader(vshader);
program->addShader(fshader);

program->bindAttributeLocation("vPosition", PROGRAM_VERTEX_ATTRIBUTE);
program->bindAttributeLocation("vColor", PROGRAM_COLOR_ATTRIBUTE);
program->link();

program->bind();
```

### Otros

#### QTimer

Para utilizarlo has de incluir `QTimer`.\
Su uso es algo así:

``` cpp
QTimer *timer = new QTimer(this);
connect(timer, SIGNAL(timeout()), this, SLOT(processOneThing()));
timer->start();
```

### Cómo\...

-   Cerrar la aplicación? Llamando al método `closeAllWindows()` de la
    aplicación.
-   Mostrar un diálogo de abrir fichero
    `QString fileName = QFileDialog::getOpenFileName(this);`.

#### \... Gestionar los eventos de ratón\\teclado en un widget?

Sobreescribiendo los métodos `mousePressEvent`, `mouseMoveEvent`,
`keyPressEvent`\...\
Aquí algunos ejemplos:

``` cpp
void Window::keyPressEvent(QKeyEvent *e) {
    if (e->key() == Qt::Key_Escape)
        close();
    else
        QWidget::keyPressEvent(e);
}
```

## Herramientas

-   **qtdemo**: Ejemplos de código fuente de la SDK.
-   **qtconfig**: Configura el aspecto y el comportamiento de las
    interficies creadas con Qt en esa máquina.

### QtCreator

### Diseñador

-   Si queremos acceder a los elementos agregados por el diseñador desde
    el código lo haremos a partir del objeto `ui` que hay en la clase:

``` cpp
// en clase MainWindow, npd es un QDialog:
connect(this->ui->actionNew_Planet, SIGNAL(triggered()), npd, SLOT(show()));
```

### Cómo\...

#### \... Configurar un proyecto C++ simple, sin utilizar Qt?

Para añadir librerías lo haremos desde el archivo .pro agregando (este
ejemplo utiliza GLUT):

    LIBS += -lglut -lGL -lGLU

## Notas

-   `qobject_cast()` permite realizar un cast dinámico de un objeto.
    Retorna puntero nulo si el cast es incompatible o un puntero al
    objeto si es compatible.

``` cpp
if (QLabel *label = qobject_cast<QLabel *>(obj)) {
   label->setText(tr("Ping"));
} else if (QPushButton *button = qobject_cast<QPushButton *>(obj)) {
   button->setText(tr("Pong!"));
}
```
