# OpenTK

OpenTK es una librería que engloba una serie de clases las cuales
enlazan el código .NET con otras librerías multimedia tales como OpenGL,
OpenAL\... Permitiendo también gestionar fácilmente gráficos, audio,
entrada por teclado\...

-   [Página de OpenTK](http://www.opentk.com/).
-   ![Compilado de la librería de finales del
    2010](/fw/othersnet/opentk-2010-10-06.zip).

## Uso básico

Si descomprimimos el .zip encontraremos una carpeta en la que si nos
vamos a la siguiente ruta `/Binaries/OpenTK/Release` tendremos acceso al
archivo `OpenTK.dll` al cual podemos enlazarlo con nuestro proyecto a
partir de las dependencias. Una vez lo hagamos ya podremos utilizarlo.

### Lo básico

El siguiente es un ejemplo básico de uso de gráficos:

``` csharp
using System;
using OpenTK;
using OpenTK.Graphics;
using OpenTK.Graphics.OpenGL;
using OpenTK.Input;

namespace StarterKit
{
    class Game : GameWindow
    {
        public Game()
            : base(800, 600, GraphicsMode.Default, "OpenTK Quick Start Sample")
        {
            VSync = VSyncMode.On;
        }

        protected override void OnLoad(EventArgs e)
        {
            base.OnLoad(e);
            GL.ClearColor(0.1f, 0.2f, 0.5f, 0.0f);
            GL.Enable(EnableCap.DepthTest);
        }

    protected override void OnResize(EventArgs e)
        {
            base.OnResize(e);

            GL.Viewport(ClientRectangle.X, ClientRectangle.Y, ClientRectangle.Width, ClientRectangle.Height);

            Matrix4 projection = Matrix4.CreatePerspectiveFieldOfView((float)Math.PI / 4, Width / (float)Height, 1.0f, 64.0f);
            GL.MatrixMode(MatrixMode.Projection);
            GL.LoadMatrix(ref projection);
        }

        protected override void OnUpdateFrame(FrameEventArgs e)
        {
            base.OnUpdateFrame(e);

            if (Keyboard[Key.Escape])
                Exit();
        }

        protected override void OnRenderFrame(FrameEventArgs e)
        {
            base.OnRenderFrame(e);

            GL.Clear(ClearBufferMask.ColorBufferBit | ClearBufferMask.DepthBufferBit);

            Matrix4 modelview = Matrix4.LookAt(Vector3.Zero, Vector3.UnitZ, Vector3.UnitY);
            GL.MatrixMode(MatrixMode.Modelview);
            GL.LoadMatrix(ref modelview);

            GL.Begin(BeginMode.Triangles);

            GL.Color3(1.0f, 1.0f, 0.0f); GL.Vertex3(-1.0f, -1.0f, 4.0f);
            GL.Color3(1.0f, 0.0f, 0.0f); GL.Vertex3(1.0f, -1.0f, 4.0f);
            GL.Color3(0.2f, 0.9f, 1.0f); GL.Vertex3(0.0f, 1.0f, 4.0f);

            GL.End();

            SwapBuffers();
        }

        static void Main()
        {
            using (Game game = new Game())
            {
                game.Run(30.0);
            }
        }
    }
}
```

-   En el método `OnUpdateFrame` meteríamos toda la lógica del sistema.
-   En el método `OnRenderFrame` meteríamos todo el apartado de dibujo.
-   `OnResize` se llama cada vez que se hace un cambio de tamaño de la
    ventana.
-   En el `Main`, al hacer `game.Run(30.0)` estamos diciendo que se haga
    un render tantas veces como sea necesario pero sólo 30 updates por
    segundo.

### La clase GameWindow

-   La propiedad `WindowBorder` permite indicar como será el borde de la
    ventana.

## Librerías

### Gráficos (OpenGL)

### Audio (OpenAL)

## Cómo\...
