# OpenGL (Xtra 2)

## GLUT

GLUT (openGL Utility Toolkit) es una librería para escribir programas
con interface gráfica OpenGL de forma fácil, por lo que da la
posibilidad de aprender a programar con OpenGL de una forma muy sencilla

### Instalación y uso

#### En Linux

Podremos instalar el paquete `freeglut`, luego para compilar
utilizaremos la siguiente línea:

    $ g++ -Wall -o "%e" "%f" -I/usr/include/ImageMagick/ -lglut -lGL -lGLU -lMagick++

#### En Windows

-   ![GLUT 3.7.6](/fw/ogl/glut-3.7.6-bin.zip)

Descomprimiremos este archivo en la carpeta del proyecto y agregaremos
las siguientes librerías `opengl32.lib` y `glut32.lib`. Luego haremos un
include de `glut.h`.

### Funciones

#### Inicio

-   `glutInit()`: Inicializa GLUT para ser utilizado. Debería recibir
    por parámetro los parámetros que recibe la función main.
-   `glutInitDisplayMode()`: Inicializa el display mode, indica cómo se
    mostrarán los ventanas creadas a partir de GLUT. Acepta un
    `unsigned int` como parámetro correspondiente a las distintas flags
    combinadas por OR (\|):
    -   `GLUT_RGBA`
    -   `GLUT_RGB`
    -   `GLUT_INDEX`
    -   `GLUT_SINGLE`
    -   `GLUT_DOUBLE`, double buffering.
    -   `GLUT_ACCUM`
    -   `GLUT_ALPHA`
    -   `GLUT_DEPTH`
    -   `GLUT_STENCIL`
    -   `GLUT_MULTISAMPLE`
    -   `GLUT_STEREO`
    -   `GLUT_LUMINANCE`

#### Ventana

-   `glutInitWindowSize`, recibe dos `int` que indican el tamaño de la
    ventana (ancho y alto).
-   `glutInitWindowPosition`, recibe dos `int` que indican la posición
    inicial de la ventana.
-   `glutCreateWindow`, crea la ventana, recibe una cadena de carácteres
    correspondientes al título.

#### Dibujo

-   `glutDisplayFunc`, indica cual es la función encargada de dibujar.
    Recibe `(void(*func)(void))`, es decir, el nombre de la función que
    devuelve `void` y no recibe parámetros.
-   `glutPostRedisplay`, ordena el redibujo.

#### Teclado

-   `glutKeyboardFunc`, indica la función que se llamará cuando se
    realice una pulsación de teclado. Recibe por parámetro el nombre de
    la función, teniendo que ser esta con el siguiente formato:
    `(void(*func)(unsigned char key, int x, int y))`.
-   `glutKeyboardUpFunc`, con el mismo formato que la anterior, indica
    cuando se levanta una tecla.

#### Otras

-   `glutMainLoop` función que inicia el *main loop* de glut, por lo
    tanto muestra la ventana, la mantiene abierta y se va llamando al
    bucle principal del programa.
-   `glutIdleFunc` indica la función que se ejecutará cuando se haga una
    iteración del main loop.
-   `glutTimerFunc` indica cada cuanto se ejecutará la función del main
    loop.

### Ejemplos

#### Simple

``` c
#include "glut.h"

void renderScene(void) {
    glClear(GL_COLOR_BUFFER_BIT);
    glBegin(GL_TRIANGLES);
        glVertex3f(-0.5,-0.5,0.0);
        glVertex3f(0.5,0.0,0.0);
        glVertex3f(0.0,0.5,0.0);
    glEnd();
    glFlush();
}

void main(int argc, char **argv) {
    glutInit(&argc, argv);
    glutInitDisplayMode(GLUT_DEPTH | GLUT_SINGLE | GLUT_RGBA);
    glutInitWindowPosition(100,100);
    glutInitWindowSize(320,320);
    glutCreateWindow("3D Tech- GLUT Tutorial");
    glutDisplayFunc(renderScene);
    glutMainLoop();
}
```

## OpenGL en Linux

Antes de empezar a desarrollar para Linux en OpenGL es necesario saber
si nuestro sistema puede renderizar código OpenGL, para ello
utilizaremos el comando `glxinfo` de la siguiente forma:

    glxinfo | grep "rendering"

Este comando puede servirnos también para saber qué versión tenemos y la
marca de los drivers:

    glxinfo | grep "version"
    glxinfo | grep "vendor"

Para comprobar el funcionamiento de OpenGL en Linux ejecutaremos el
comando `glxgears`.\
En caso de no funcionar deberíamos instalar [Mesa
3d](http://www.mesa3d.org/).

### X11 (X Window)

Al desarrollar en X11 será necesario hacer dos cosas:

-   Añadir la librería `X11` al preprocesador compilando con: `-lX11`
-   Incluir dicha librería, con: \'\'#include \<X11/Xlib.h\> \'\'

Una vez realizados los pasos anteriores podremos usar las funciones para
el servidor X. Las que nos importan ahora son:

-   **XOpenDisplay** para que devuelva el objeto `Display` sobre el que
    se creará la ventana, para ello le preguntamos al sistema utilizando
    la función `getenv`.
-   **XCloseDisplay** para liberar el objeto `Display`.

``` cpp
Display *dpy = XOpenDisplay(getenv("DISPLAY"));
XCloseDisplay(dpy);
```

### GLX

GLX es la librería que proporciona un enlace entre las X y OpenGL
activando la posibilidad de dibujo 3d sobre las ventanas. Para
desarrollar con esta debemos añadir la librería **GL** (compilando con
`-lGL`).\
La versión actual de GLX es la 1.3 que corresponde a la OpenGL 1.2.\

## OpenGL ES

## WebGL
