# log4j

Herramienta para el registro de datos\\sucesos en el código (logs) de
forma secuencial en [Java](/highlevel/java).

## Loggers, appenders y layouts

### Loggers

Permiten activar y desactivar ciertas sentencias de log. Se gestionan en
una relación padre-hijo a partir de un nombre separado por puntos, donde
el padre es el elemento anterior al otro. Por ejemplo `com.foo` es padre
de `com.foo.bar`.\
Siempre existirá el logger root (al cual no puede accederse por el
nombre). Para utilizarlo llamaremos al método estático
**`Logger.getRootLogger`** (para llamar a otro utilizaremos
**`Logger.getLogger`**).\

Los métodos que utilizaremos generalmente serán:

-   **public void \[nivel\] (Object message)**, pudiendo ser nivel
    `debug`, `info`, `warn`, `error`, `fatal` o `log`; son métodos que
    imprimen en un nivel concreto de un logger. Por ejemplo si `objLog`
    es un objeto de la clase `Logger` llamando a su método
    `objLog.info("...")` enviará una petición de loggin a nivel de
    `INFO`.
-   **public void log(Level l, Object message)**, método genérico para
    imprimir a partir de un nivel indicado.

Los niveles que pueden asignarse a un logger son `DEBUG`, `INFO`,
`WARN`, `ERROR` y `FATAL` definidos en la clase
`org.apache.log4j.Level`. Si no se llega a asignar un nivel a un logger
entonces lo heredará de su antecesor.\

En el siguiente ejemplo únicamente root tiene un nivel asignado (Proot)
y este es heredado.

  Nombre   Nivel     Definitivo
  -------- --------- ------------
  root     Proot     Proot
  X        ninguno   Proot
  X.Y      ninguno   Proot
  X.Y.Z    ninguno   Proot

En este todos los loggers tienen un nivel, no existe herencia:

  Nombre   Nivel   Definitivo
  -------- ------- ------------
  root     Proot   Proot
  X        Px      Px
  X.Y      Pxy     Pxy
  X.Y.Z    Pxyz    Pxyz

En el siguiente tanto X como X.Y.Z no utilizan la herencia porque tienen
un nivel asignado. X.Y hereda de X.

  Nombre   Nivel     Definitivo
  -------- --------- ------------
  root     Proot     Proot
  X        Px        Px
  X.Y      ninguno   Px
  X.Y.Z    Pxyz      Pxyz

Una petición de log estará abilitada si en el logger en el que se
realiza tiene un nivel superior a otro ya abilitado. El orden de los
niveles es el siguiente: `DEBUG < INFO < WARN < ERROR < FATAL`.\
Al hacer `Logger x = Logger.getLogger("wombat");` y
`Logger y = Logger.getLogger("wombat");` los objetos `x` e `y` de la
clase logger tendrá la misma instancia, por lo que no nos tenemos que
preocupar de pasar el objeto entre métodos de código.

### Appenders

Un appender es un destino donde se puede mostrar el log (consola,
ficheros, componentes GUI, socket (para acceder a un servidor
remoto)\...).\
Un logger puede tener asociado más de un appender.\
De la misma forma que en la activación de un logger influye los loggers
\"padre\" en la adición de appenders ocurre lo mismo. Es decir, si un
appender de consola es asignado al root todos los logs imprimirán por
consola. Aun así cambiar esto llamando a `setAdditivity` con false.\
El método `addAppender` es el que asigna un appender a un logger.

### Layouts

Los layouts (PatternLayout) son el formato que tendrá el logger. Se
asignan como si escribiesemos un printf de C, del estilo
\"`%r [%t] %-5p %c - %m%n`\". Y podemos escribir:

-   %r : El número de milisegundos que han pasado desde que se inició el
    programa.
-   %t : El thread que lo ha llamado.
-   %-5p : El nivel de sentencia.
-   %c : El nombre del log.
-   %m : El mensaje con el que se ha llamado.

## Configuración

Podemos indicar como queremos configurar log4j mediante el método
**configure** las clases **PropertyConfigurator** y
**BasicConfigurator**. Mediante BasicConfigurator indicamos que se
configure de forma standard: un logger root con nivel DEBUG y un
ConsoleAppender, el formato de salida será el siguiente
`%-4r [%t] %-5p %c %x - %m%n`. PropertyConfigurator nos permite indicar
un archivo externo donde guardar la configuración, el formato de este
será como el que sigue:

    # Set root logger level to DEBUG and its only appender to A1.
    log4j.rootLogger=DEBUG, A1
    # A1 is set to be a ConsoleAppender.
    log4j.appender.A1=org.apache.log4j.ConsoleAppender

    # A1 uses PatternLayout.
    log4j.appender.A1.layout=org.apache.log4j.PatternLayout
    log4j.appender.A1.layout.ConversionPattern=%-4r [%t] %-5p %c %x - %m%n

También podremos indicar la configuración mediante un formato xml.
