# FMOD

Para utilizarla debemos incluir en el código `fmod.h` y vincular
`fmodvc.lib` (si usamos Visual Studio).

## Inicializar

Antes de utilizar fmod debemos inicializar el sistema de sonido, para
ello utilizamos **FSOUND_Init**.

``` cpp
FSOUND_Init(44100, 32, 0);
```

1.  El primer parámetro es el ratio de salida, entre 4000hz y 65535hz.
2.  El segundo el número máximo de canales gestionados por software, el
    máximo gestionado por hardware lo podemos hacer haciendo una llamada
    a **FSOUND_GetMaxChannels**.
3.  El último son las flags, opciones que queramos pasarle.

## Reproducir sonidos

Cuando queramos reproducir sonidos pequeños mediante ficheros (mp3, wav,
ogg\...) que se vayan a reproducir varias veces y que queramos cargar en
memoria, utilizaremos la función **FSOUND_Sample_Load** para cargar el
fichero en memoria y **FSOUND_PlaySound** (o **FSOUND_PlaySoundEx**)
para reproducirlo.\
**FSOUND_Sample_Load** devuelve un puntero a un **FSOUND_SAMPLE** y
recibe como parámetros:

1.  El indice de sonido, un int de valor 0 o mayor. Cada sonido debe
    tener un indice, si un indice vuelve a ser asignado el sonido se
    reemplaza.
2.  Ruta del archivo o puntero a los datos ya cargados en memoria.
3.  El modo, uno de los FSOUND_MODES, el más general es `FSOUND_NORMAL`.
4.  Los dos siguientes pueden ser asignados a 0.

**FSOUND_PlaySound** únicamente recibe como parámetros el canal y el
puntero al FSOUND_SAMPLE deseado. Si dos sonidos están en el mismo
canal, cuando uno se reproduzca el otro quedará en silencio. Para
reproducirlos a la vez han de estar en distintos canales. Aunque como
canal podemos pasarle `FSOUND_FREE` que eligirá automáticamente uno
libre. Retorna el número de canal asignado.\
\

## Reproducir streams

Primero deberemos abrir el stream mediante **FSOUND_Stream_Open** la
cual recibe el nombre y el modo, el cual puede ser FSOUND_NORMAL, los
otros dos argumentos pueden ser asignados a 0.\
Para reproducir un stream utilizaremos **FSOUND_Stream_Play** que recibe
el canal y el FSOUND_STREAM creado por la anterior función, devuelve un
int correspondiente al canal.

## General

### Asignar volumen

Podemos asignar el volumen de un canal mediate **FSOUND_SetVolume**,
esta función acepta un int, el número de canal, y un valor entre 0 y 255
correspondiente al volumen.\
Como canal podemos pasarle FSOUND_ALL y afectará a todos los canales.\
Si el canal no está en uso el volumen no se asignará.

### Crear un bucle

Para ello utilizaremos FSOUND_SetLoopMode, indicando el canal y tipo de
bucle (generalmente usaremos FSOUND_LOOP_NORMAL).

``` cpp
FSOUND_SetLoopMode(ch, FSOUND_LOOP_NORMAL);
```

Para quitar el bucle lo llamaremos con FSOUND_LOOP_OFF.\
Si el canal no está en uso el bucle no se asignará.

### Pausar

**FSOUND_SetPaused** recibe un canal y un bool, si es true el canal será
pausado, si es false se reproducirá.

### Otros

-   Coger el `FSOUND_SAMPLE` de un canal mediante
    **FSOUND_GetCurrentSample**.
-   **FSOUND_IsPlaying** retorna si un canal está sonando o no.
