# Flask

## Básico

### Static files

Por defecto los ficheros estáticos están en el directorio `static`. Este
puede ser cambiado desde la definición de la aplicación:

``` python
app = Flask(__name__, static_folder='my_html', static_url_path='')
```

De esta forma decimos que el directorio `my_html` queda redireccionado a
la raíz.\
También podemos decir que el fichero `index.html` dentro del directorio
`my_html` (recordemos que ahora está mapeado como `static`) será la raíz
del programa:

``` python
@app.route('/')
def home():
    return redirect(url_for('static', filename='index.html'))
```

## Cómo\...

### Utilizar websockets

Para ello necesitas el módulo `gevent-websocket`.\
Para mostrarlo usando el siguiente ejemplo:

      app/
      ├── html/
      │   ├── test.html
      │   └── jquery.min.js
      └── test.py

En test.html:

``` html
<!doctype html>
<html>                                                                           
<head>                                                                           
    <title>Flask/Gevent WebSocket Test</title>                                                   
    <script type="text/javascript" src="jquery.min.js"></script>
    <script type="text/javascript" charset="utf-8">                              
        $(document).ready(function(){                                            
            var ws;
            $('form').submit(function(event){   
                ws.send($('#data').val());
                console.log('2. message send: ' + $('#data').val());
                return false;                                                    
            });                                                                  
            if ("WebSocket" in window) {                                         
                ws = new WebSocket("ws://" + document.domain + ":5000/api");
                console.log('1. web socket created');
                ws.onmessage = function (msg) {
                    console.log('3. message received:' + msg);
                    $("#log").append("<p>"+msg.data+"</p>");                   
                };                                                               
            } else {                                                             
                alert("WebSocket not supported");                                
            }                                                                    
        });                                                                      
    </script>                                                                    
</head>                                                                          
<body>                                                                           
    <h1>Send:</h1>                                                               
    <form method='POST' action='#'>
        <textarea name='data' id="data"></textarea>
        <div><input type='submit'></div>
    </form>
    <h1>Receive:</h1>
    <div id="log"></div>
</body>
</html>
```

En `test.py`:

``` python
#!/usr/bin/python
# -*- coding: utf-8 *-*

from geventwebsocket.handler import WebSocketHandler
from gevent.pywsgi import WSGIServer
from flask import Flask, request, redirect, url_for
 
app = Flask(__name__, static_folder='html', static_url_path='')
 
@app.route('/')
def index():
    return redirect(url_for('static', filename='test.html'))
 
@app.route('/api')
def api():
    if request.environ.get('wsgi.websocket'):
        ws = request.environ['wsgi.websocket']
        while True:
            message = ws.receive()
            ws.send(message)
    else:
        print 'No support for websockets!'
    return
 
if __name__ == '__main__':
    http_server = WSGIServer(('',5000), app, handler_class=WebSocketHandler)
    http_server.serve_forever()
```

### Notas

#### Apagar el server?

``` python
def shutdown_server():
    func = request.environ.get('werkzeug.server.shutdown')
    if func is None:
        raise RuntimeError('Not running with the Werkzeug Server')
    func()
```

El server está programado para finalizar la última petición y apagarse.

#### Recibir JSON

``` javascript
$.ajax({
    type: 'POST',
    contentType: 'application/json',
    data: JSON.stringify(post_obj),
    dataType: 'json',
    url: '/some/url',
    success: function (e) {
        console.log(e);
    }
});
```

``` python
content = request.json['content']
```
