# Arduino

Arduino es a la vez una placa (de la que existen varios modelos), un
lenguaje de programación y un IDE (creado en Java). Todos muy
relacionados entre ellos y con una meta, la de simplificar la creación
de aplicaciones\\objetos interactivos.

## Modelos de Arduino

### Duemilanove

![](/arduino/duemilanove.png)\
Se conecta al ordenador mediante un cable USB standard. Es una placa
basada en el ATmega128 y tiene 14 pines digitales IO (de los cuales 6
pueden ser usados como outputs [PWM](/electr/basica#complejos)), 6
inputs análogos, un cristal oscilador de 16Mhz, la conexión USB, un
conector de power, un cabezal [ICSP](/electr/basica#conceptos1) y un
botón de reset. Su nombre viene del año de salida, el 2009, en italiano.

#### Los pines

Cada uno de los 14 pines pueden ser usados como de input o de output.
Operan a 5 voltios y cada pin provee o recibe un másximo de 40mA y tiene
una [resistencia pull-up](/electr/basica#complejos) interna
(desconectada por defecto) de 20-50kOhms.\
Aún así algunos pines tienen una función específica:

-   Serial 0 (RX) y 1 (TX), usados para recibir (RX) y transmitir (TX)
    una señal de datos serie TTL.
-   Interruptores exteros: Estos pins pueden ser configurados para
    realizar una interrupción a bajo nivel.
-   PWM: Los pines 3, 5, 6, 9, 10 y 11 proveen una salida PWM
    (analógica).
-   LED: El pin 13. Ya existe de por sí un LED conectado al pin 13 de la
    placa, cuando el pin está en valor alto el LED está activo y cuando
    está en valor bajo inactivo.
-   Reset: Poniendo en LOW se reseta el microcontrolador.
-   :!: Algunos más.

#### Energía

El Duemilanove puede ser alimentado mediante la conexión USB o a partir
de una fuente de energía externa. La fuente de energía se selecciona
automáticamente.\
Cuando la energía viene de un adaptador AC-to-DC este puede ser
conectado al conector de 2,1mm de la placa. Si viene de una batería
pueden ser insertados al los pines de Gnd y Vin.\
La placa puede operar entre 6 y 20 voltios, aunque se recomienda entre 7
y 12.\
Los pines de energía son:

-   **VIN**: El voltaje de entrada de la placa, cuando se usa un fuente
    externa se provee la energía a partir de este pin.
-   **5V**:
-   **3V3**:
-   **GND**: Pin de tierra.

#### Memoria

El ATmega128 tiene 16kb de memoria flash para almacenar el código y el
ATmega328 tiene 32kb, de los cuales 2kb son para el bootloader.\
El ATmega128 tiene 1kb de SRAM y 512bytes de EEPROM, en cambio el
ATmega328 tiene 2kb de SRAM y 1kb de EEPROM.

#### Relación de pines del ATmega168/328 con los de la placa

![](/arduino/atmega168pinmap2.png){width="350"}

#### Datasheet

-   ![Datasheed Arduino
    Duemilanove](/arduino/arduino-duemilanove-schematic.pdf)

### Mini

En comparación con el Duemilanove es mucho más pequeño, necesita un
adaptador USB ya que no lo tiene integrado, también se requiere una
protoboard ya que no se le pueden conectar directamente los dispositivos
y tampoco contiene un LED conectado directamente en placa.

### Mega

### Pro

### Pro Mini

## Como\...

## Notas

-   Los *shields* son los componentes que se han creado para ser usados
    como complemento a Arduino.

### Links

-   [Web oficial de Arduino](http://www.arduino.cc/)
