# MongoDB

## First steps

### Getting started

#### Installation (Ubuntu)

    $ sudo apt-key adv --keyserver hkp://keyserver.ubuntu.com:80 --recv 7F0CEB10
    $ echo 'deb http://downloads-distro.mongodb.org/repo/ubuntu-upstart dist 10gen' | sudo tee /etc/apt/sources.list.d/mongodb.list
    $ sudo apt-get update
    $ sudo apt-get install mongodb-org

Si en /etc/apt/sources.list.d aparece el fichero `mongod` sin extensión,
entonces tendrás que renombrarlo a `mongod.list`.\
Probablemente tengas que lanzar `sudo apt-get install mongodb-server`

#### Run Mongo

    $ sudo start mongod

\... or\...

    $ sudo service mongod start

#### Stop Mongo

    $ sudo stop mongod

#### Accessing Mongo console

    $ mongo

#### Mongo principles

A Mongo server contain multiple data bases. Data bases are collection
containers and a collection is a documents container. Documents are
equivalents to records.\
Documents inside a collection can have different fields, they are stored
as BSON objects and accessed as JSON objects as well.\
A namespace in Mongo is the concatenation of database and collection
names. For an example `acme.users` namespace, `acme` is the database
name and `users` is the collection name. We could also have a collection
called `users.history`, then the namespace would be
`acme.users.history`.

### Operations

By default you access to the `test` database.

-   You can list your current database with `db` command.
-   List your databases with `show dbs` command.
-   Create and switch to a new (newdb) data base with `use newdb`
    command.
-   `help` to display help.
-   `show collections` lists available collections.

### In a nutshell\...

#### \... Insert data

    j = { name : "mongo" }
    k = { x : 3 }
    db.testData.insert( j )
    db.testData.insert( k )

#### \... List inserted data

    db.testData.find()

### Configuration

#### Allow external connections

You should edit `/etc/mongodb.conf` file and change the bind_ip and port
values. These would be the values:

    bind_ip = 0.0.0.0
    port = 27017

## Notes

-   Logs are found in `/var/log/mongodb`
-   `Robomongo` is a good ubuntu GUI client for MongoDB.

### Recover MongoDB after crash

When the system crashes MongoDB remains locked (error is shown in logs
as *mongodb exception in initandlisten old lock file*). You chan do two
things to unlock it:

-   If this is a development machine, you can remove the lock file
    manually. It\'s in `/var/lib/mongodb/mongod.lock` or it could be
    named `mongo.lock`.
-   The safer route is to follow [MongoDB\'s Durability and Repair
    guide](http://docs.mongodb.org/manual/tutorial/recover-data-following-unexpected-shutdown/).
    In summary, for a machine with the above configuration, you should
    execute the following commands:

```{=html}
<!-- -->
```
    $ sudo -u mongodb mongod --repair --dbpath /var/lib/mongodb/
    $ sudo service mongodb start
