# Subversion (SVN)

Es una herramienta para gestionar repositorios de archivos y controlar
sus distintas versiones. El repositorio se encuentra en un servidor y es
una especie de directorio donde se almacenan documentos que varian con
el paso del tiempo y este recuerda sus distintas versiones.

## El server

### Mediante comandos

Los comandos **svnserve** y **svnadmin** nos servirán para gestionar un
servidor común de Subversion siguiendo los siguientes pasos:

1.  Elegimos una carpeta donde se almacenarán los repositorios, en este
    caso es */home/alfred/svnpath*.
2.  Creamos el directorio para un repositorio (dentro de la carpeta
    escogida): `mkdir prueba`
3.  Mientras este directorio esté vacío podremos registrar el
    repositorio en subversion haciendo
    `svnadmin create /home/alfred/svnpath/prueba`.
4.  Edita el fichero `conf/svnserve.conf` que se habrá creado en el
    repositorio. Más adelante existe un apartado sobre ficheros de
    configuración, échale un vistazo.
5.  Inicia el servidor: `svnserve -d -r /home/alfred/svnpath`. El
    parámetro *-d* hace que se inicie como daemon, el *-r* que el
    cliente no pueda salir del path indicado. El puerto por defecto
    es 3690. Para acceder al repositorio creado utilizaremos la
    dirección: `svn://<host>/prueba`

### Instalación en Apache

En un *Ubuntu server* con Apache2 instalado podemos instalar un servidor
de subversion añadiendo los paquetes **subversion** y
**libapache2-svn**.

-   `sudo apt-get install subversion libapache2-svn`

Tras crear un repositorio (pongamos en /svn mediante el comando
`sudo svnadmin create /svn`, recuerda que *todo el directorio* ha de
poder ser accesible por el usuario correspondiente a apache) editaremos
el fichero de configuración de webdav que, en distribuciones basadas en
Debian, se encuentra en */etc/apache2/mods-enabled/dav_svn.conf*. Una
vez tengamos el fichero abierto haremos los siguientes cambios:

1.  Descomentar y modificar el elemento *\<Location /svn\>*, este indica
    cual será la dirección para este repositorio. Por ejemplo:
    *http://127.0.0.1/svn*. No olvides descomentar también, hacia el
    final del fichero, el elemento que cierra Location (\</Location\>).
2.  Descomentar la línea `DAV svn` la cual activa el repositorio.
3.  SVNPath indica donde está físicamente el repositorio, por ejemplo:
    `SVNPath /svn`
4.  La autentificación la descomentaremos y dejaremos por defecto (Las
    líneas: *AuthType Basic* , *AuthName \"Subversion Repository\"* y
    *AuthUserFile /etc/apache2/dav_svn.passwd*). Aquí estamos indicando
    que el fichero de passwords para subversion es dav_svn.passwd.
5.  Si quieres que hasta para poder ver el contenido un usuario tenga
    que autentificarse descomenta la línea `Require valid-user`
6.  Crea un usuario para el repositorio con el comando htpasswd (o si
    existe htpasswd2). Por ejemplo:
    `sudo htpasswd -cm /etc/apache2/dav_svn.passwd alfred`

A partir de aquí debería de ser accesible desde: *http://127.0.0.1/svn*

#### Resumen

Una vez tengas correctamente instalados los módulos necesarios,
configurarás Apache, para ello se añadirá algo parecido al siguiente
código a la configuración de este:

    <Location /svn/repos>
       DAV svn
       SVNPath /home/subversion/repos
    </Location>

A partir de ahora el acceso al server se podrá realizar via web, donde
en vez de utilizar `svn://` para acceder al repositorio se utilizará
`http://`. Un ejemplo de otra Location configurada:

    <Location /agl>
      DAV svn
      SVNPath /home/alfred/svn_repositories/agl
      AuthType Basic
      AuthName "Subversion Repository"
      AuthUserFile /etc/apache2/dav_svn.passwd
    </Location>

## Administración y configuración de un repositorio

La distribución de un archivo de configuración en subversión sigue el
siguiente patrón:

    [apartado]
    clave = valor

El archivo `conf/svnserve.conf` de dentro del repositorio se usa para
restringir el acceso a un repositorio, en el apartado **general** puedes
colocar las siguientes claves con los siguientes valores:

-   Claves: **anon-access** o **auth-access**, para acceso anónimo o de
    usuario logueado respectivamente, aceptan **none** como \'sin
    acceso\', **write** como \'permiso de escritura\'.
-   **password-db** es una clave que indica cual es el archivo donde se
    almacenan los usuarios, si por ejemplo le damos el valor: **passwd**
    el archivo de usuarios del repositorio estará en: `conf/passwd`.

Un archivo de configuración de usuarios tiene como apartado **users**.
La clave corresponde al nombre de usuario, el valor al password. Si
quieres utilizarlo recuerda definir *password-db* en svnserve.conf.

## Conceptos

-   **Import**: Subir al repositorio (sin necesidad de que el directorio
    esté enlazado al repositorio).
-   **Export**: Bajar del repositorio (sin necesidad de que el
    directorio esté enlazado al repositorio).
-   **Update**: Actualizar el directorio local con los datos del
    repositorio.
-   **Checkout**: Enlazar un directorio con un repositorio.
-   **Commit**: Actualizar cambios hechos localmente en el repositorio.
-   **Branch**: Copiar el directorio actual en otro para hacer una rama
    nueva.

Inicialmente se trabaja sobre un directorio *trunk*, sobre este se harán
los commits y los updates. Cuando se quiera hacer una nueva versión se
hará sobre el directorio *branches/x* siendo x la versión.

## Comandos de cliente

  --------------------------------------------- ------------------------------------------------------------------------------------------------------------------------------- --------------------------------------------------
  **Actualizar la copia de trabajo**                                                                                                                                            
  *svn import \<path\> \<repo\>*                Sube recursivamente al repositorio la carpeta path (que puedes omitir, en ese caso escogerá la carpeta actual).                 `svn import svn://127.0.0.1/prueba -m "inicial"`
  *svn update*                                  Actualiza la versión que tiene el cliente con los cambios que hay en el repositorio.                                            
  *svn checkout \<repo\>*                       Descarga una copia de trabajo.                                                                                                  
  \*\*Realizar los cambios \*\*                                                                                                                                                 
  *svn add \<fichero\\s\>*                      Para añadir uno o varios elementos al repositorio, no serán subidos hasta que no se haga un commit.                             `svn add file2 file3`
  *svn \[delete\|copy\|move\] path*             Elimina, copia o mueve elementos en el repositorio. El *move* también puede ser usado para renombrar.                           
  **Examinar mis cambios**                                                                                                                                                      
  *svn status*                                  Indica los cambios que tú has hecho sobre los archivos del repositorio en local desde el último commit.                         
  *svn diff path*                               Muestra los cambios realizados a un objetivo.                                                                                   
  svn revert                                    Elimina los cambios realizados, volviendo a la versión usada.                                                                   
  **Fusionar los cambios**                                                                                                                                                      
  *svn merge \<path1\> \<path2\>*               Une los cambios realizados en path1 sobre path2                                                                                 
  svn resolved                                  :?:                                                                                                                             
  **Actualizar mis cambios en el repostorio**                                                                                                                                   
  *svn commit*                                  Modifica en el repositorio los cambios de los ficheros ya registrados.                                                          
  **Otros**                                                                                                                                                                     
  *svn log*                                     Muestra un historial de los cambios en el repositorio.                                                                          
  *svn export \<repo\>*                         Trae una versión limpia (sin ficheros de control) del repositorio.                                                              
  *svn help \<comando\>*                        Muestra la ayuda de ese comando de subversion.                                                                                  
  //svn info //                                 Devuelve información del repositorio. Opcionalmente puedes indicar el nombre de un fichero y mostrará información sobre este.   `svn info main.c`
  *svn list \<repo\>*                           Muestra el contenido de un repositorio o path de este.                                                                          
  *svn blame \<fichero\>*                       Muestra los cambios que ha sufrido un fichero a lo largo de las versiones y quienes lo han realizado                            
  *svn cleanup*                                 Limpia el directorio de trabajo (elimina operaciones inconcluisas, locks\...)                                                   
  --------------------------------------------- ------------------------------------------------------------------------------------------------------------------------------- --------------------------------------------------

-   Recuerda que un elemento es un fichero o directorio
    indiferentemente, así es como los trata Subversion.
-   Cada vez que se modifica un repositorio se abre el editor por
    defecto y puedes añadir información de los cambios realizados.
-   Si se hace un *svn import* sobre un repositorio ya creado añadirá
    los archivos a la anterior versión.
-   Se recomienda realizar una estructura en la que existan directorios
    paralelos al proyecto con el que trabajas. Y cuando se realicen
    versiones copiar de una carpeta a otra.

## Parámetros generales

Ahí va una lista de parámetros que se pueden utilizar en los comandos de
actualización:

-   `-m <texto>`, para añadir una etiqueta a la acción.
-   `--username <nombre>`, para indicar el nombre de usuario.
-   `--password <pass>`, para indicar el password para el usuario.
-   `-r <x>`, para recoger la revisión x, donde x es un número, aunque
    esta puede ser substituida por\...
    -   Un rango de versiones que sería `x:y`, donde *x* es la versión
        inicial e *y* la final.
    -   `HEAD` (la versión más vieja), `PREV` (la versión anterior al
        commit) o `BASE` (la versión actual).
    -   `{2003-03-25}` o `{2003-03-25 10:00}` para indicar momentos
        concretos.
-   `-v`, muestra aún más info en la acción pedida.

## Estructura de directorios en un repositorio

Un repositorio debería de tener tres directorios principales:

1.  `trunk/`, para la versión en desarrollo.
2.  `tags/`, para separar las distintas releases del proyecto. Deberían
    de estar en solo lectura y no modificarse porque realmente son un
    historial del proyecto.
3.  `branches/`, para separar las distintas líneas de desarrollo de
    `trunk/`.

Son directorios que, para cada proyecto, se deberían crear al crearse
este. Subversion no los crea ya que de esta forma te permite crear otro
tipo de repositorio además que el de código. Veamos como sería la
creación de un repositorio con estos directorios:

    $ svnadmin create repos
    $ svn mkdir file:///absolute/path/to/repos/trunk \
                file:///absolute/path/to/repos/branches \
                file:///absolute/path/to/repos/tags \
                -m "creating initial repository layout"

### Trabajando con esta estructura

Los branches y los tags no son más que copias del proyecto en
desarrollo. Los tags son una versión concreta del proyecto, se crea una
tag cuando se crea una nueva versión. Los branches, en cambio, son
versiones alternativas del proyecto en debug, es un concepto algo
abierto que va desde una versión donde se aplica código experimental
(que luego podrá ser fusionada con la versión en desarrollo) a distintas
líneas de desarrollo que una vez finalicen se pueden llegar también a
unir a la versión en desarrollo.

#### Crear una tag

    svn copy file:///path/to/repos/trunk file:///path/to/repos/tags/0.9-release \
        -m “tagging 0.9 release”

#### Crear una branch

    svn copy file:///path/to/repos/tags/0.9-release \
             file://path/to/repos/branches/my-development-branch \
             -m "create development branch from version 0.9 tag"

## Cómo\...

### Es el ciclo en un cliente?

1.  Hacer un *checkout* para traer la última versión del repositorio,
    este se colocará como directorio en esa ruta.
2.  Trabajar en los documentos.
3.  Hacer un *update* de la copia local.
4.  O seguir trabajando (*paso 2*) o si se ha finalizado al *paso 5*.
5.  Hacer un *commit*.

### Realizar copias de seguridad?

Una forma sencilla es mediante comandos del shell:

-   Crear copia de seguridad:
    `svnadmin dump <dirección> | gzip -9 > <archivo>.gz`
-   Restaurar copia de seguridad:
    `gunzip -c <archivo>.gz | svnadmin load <carpeta>`

### Cambiar la URL de un repositorio

Si quieres cambiar la dirección del repositorio al que se actualizarán
los ficheros con los que estás trabajando utilizarás el comando:
`svn switch --relocate path`.

    svn switch --relocate file:/// svn://servername/

### Volver a una versión anterior

Para, por ejemplo, ir de la versión 150 (actual) a la 140:

    svn update
    svn merge -r 150:140 .
    svn commit -m "Rolled back to r140"

### Eliminar los cambios realizados a un fichero

    svn revert work2.R 

## Notas

-   [Página web de Subversion](http://subversion.tigris.org/)
-   [Libro de Subversion online](http://svnbook.red-bean.com/)
-   [Subversion Techniques](http://developer.r-project.org/SVNtips.html)
-   [The Top Ten Subversion Tips for CVS
    Users](http://www.onlamp.com/pub/a/onlamp/2004/08/19/subversiontips.html)
-   Una interface web para los repositorios de subversion es *websvn*.
