# BDD (Behavior Driven Development)

Behave brings the Behaviour-driven development (BDD) to Python. BDD is
an agile software development technique that guarantees code quality and
makes easier the collaboration of non-tecnical participant. To succeed
in this the Gherkin language is used. The Gherkin language is a text
format to specify software behaviours through natural language without
needing a non-technical vocabulary.

In BDD the software functionality is defined using scenarios. An
scenario defines an specific aspect of behavior of the application. To
do so it is composed by three descriptions (or steps):

1.  A given description where the initial condition is setted.
2.  States that trigger the scenario.
3.  The expected outcome.

```{=html}
<!-- -->
```
    Scenario: New lists are empty
    Given: a new list
    When: 
    Then: the list should be empty.

``` python
def test_empty_list_is_false(self):
   list = []
   assertEqual(bool(list), False)
```

    Scenario: Lists with things in them are not empty.
    Given: a new list
    When: we add an object
    Then: the list should not be empty.

``` python
def test_populated_list_is_true(self):
   list = []
   list.append('item')
   assertEqual(bool(list), True)
```

In BDD all the scenarios are placed into a user story. A user story
describes a particular feature and the value delivered throught that
feature. Scenarios will be executables independently, it allows to know
the way in which the value is delivered at each level of the user story.
So the sum of those values is the user required value. On the other hand
the software responsability is divided in units of code, it minimises
possible failures and reduce non-valuable code.
