# AI Game Develpment

## Introducción

### Definiciones

-   **NPC**, o NonPlayer Character, son los elementos que el ordenador
    controla en un videojuego.
-   **Agente**, una entidad inteligente. Cuando un sistema maneja más de
    un agente se le llama **sistema multi-agente**.
-   **Animat**, criaturas autonomas con un cuerpo artificial en un mundo
    virtual.
-   **Agente personificado**, criatura viva sujeta a las restricciones
    de su entorno.
-   **Interface formalizada**, guía de codificación que define una
    comunicación entre el código correspondiente al ente en su entorno
    con su inteligencia, optimizando así el motor de la AI. - Ver más
    abajo -
-   **Aprendizaje**, adquisición de nuevas habilidades y conocimiento.
    -   **Optimización**
-   **Adaptación directa** cuando el motor de AI cambia en tiempo de
    ejecución. **Indirecta** si no.

#### Técnicas para interfaces formalizadas

-   *Evaluación perezosa*, ninguna información del mundo será dada a la
    AI hasta que esta no la pida.
-   *Mecanismos de eventos*, permiten que la AI no tenga que mirar
    continuamente el mundo, cuando algo relevante ocurre la AI es
    informada.
-   *Funciones en línea*, permite a las interfaces estar separadas.
-   *Configuración de optimización*, se usa para agilizar las peticiones
    usando sólo la información que puede ser comprobada visualmente.
-   *Batching*, es la técnica de recoger futuras acciones o peticiones
    para procesarlas luego.

#### Tipos de algoritmos

-   *Aprendizaje supervisado*, se realiza de forma generalizada,
    necesitan modelos para reconocer patrones.
-   *Refuerzo en el aprendizaje*, evaluan las acciones dándoles valor
    numérico.
-   *Evolución* evalua la secuencia de acciones a partir de distintos
    bloques de mejora.
-   *Aprendizaje no supervisado*, el programador provee una guía.

#### Técnicas de aprendizaje

-   *Enseñanza*, se refiere a ejemplos dados al animat por los humanos
    para que este llegue a entender qué hacer.
-   *Imitación*, permite al animat copiar la forma de actuar de otro
    ente, permitiendo ampliar su experiencia de forma externa.
-   *Prueba y error*, el animat aprende de su entorno a medida que
    realiza distintas acciones sobre este.
-   *Moldeado*, a partir de acciones sucesivas el animat va aprendiendo.
    Una vez aprenda tareas concretas podrá aprender las complejas.

### Comportamiento y Reacción

Las reacciones en elementos con AI se clasifican en deterministicas y no
deterministicas. Todos los elementos con AI reciben inputs (datos de
entrada) y producen un output (dato de salida). Cuando este es
predecible, es decir, cuando entran los mismos datos en distintas
situaciones y producen un mismo output, se le llama *sistema
deterministico*. Pero si el elemento guarda un estado y este influye en
futuras decisiones teniendolo en cuenta además que a los inputs, se le
llama *sistema no deterministico*. Por lo tanto, si este estado se trata
como un input podemos decir que un sistema no deterministico se comporta
como uno deterministico.\
\
La diferencia entre planear y reaccionar reside en que al planear se
piensa\\calcula antes. La acción de planear, también conocida como
*deliverative algorithms*, es un proceso no deterministico en el que
existen factores que se deben de tener en cuenta para tomar una serie de
decisiones; al implementar la elavoración del \'plan\' se utilizan
algoritmos de búsqueda, un ejemplo es el *algoritmo del pathfinding*, y
se requiere mayor uso de memoria y de cálculos. En cambio mediante
\'reacciones\' es posible llegar a realizar una serie de acciones de
forma tan correcta como si hubiesen estado planeadas con anterioridad.
Aún así existen casos en los que es necesario hacer uso de la
planificación, por ejemplo si un elemento recorre un terreno y se topa
con un obstáculo ha de reaccionar, si está programado con el uso de
reacciones utilizará una serie de información sobre obstáculos para
esquivarlo, pero si en este caso se utiliza un algoritmo de
planificación el problema se trataría como una pequeña parte del
conjunto global del terreno dando así un resultado más robusto.\
\
Las *reactive techniques* (técnicas de reacción) son totalmente
deterministicas, su tiempo de cálculo constante y no existe deliveración
(momento para pensar), sino que la respuesta es un reflejo que casi
aparece (o debe aparecer) inmediatamente, lo que las hace perfectas para
su utilización en juegos. Existen distintas técnicas para
implementerlas:

-   *Scripts*, pequeños programas que se ejecutan según unos parámetros
    de entrada.
-   *Sistemas basados en reglas*, una serie de if\...then seguidos que
    manipulan las variables.
-   *Máquinas de estado finitas*, son reglas que definin un
    comportamiento para cada situación.

### Arquitectura

La implementación de AI en juegos es la unión de varios componentes
juntos que se comunican entre ellos, este grupo de componentes se le
llama arquitectura. Y viene dada por:

-   Los **componentes,** serían como una caja cerrada que hace su
    función mediante un input y su comportamiento interno es desconocido
    externamente.
-   La **organización**, la forma en la que se relacionan los
    componentes, existen tres tipos:
    -   *Monolitica*, con un solo componente. Para problemas sencillos.
    -   Lineal (*flat*), muchos componentes en paralelo.
    -   *Jerarquica*, componentes anidados dentro de otros, por ejemplo,
        distintas acciones (cazar, utilizar escudo, utilizar hacha\...)
        dentro de otras (comportamiento defensivo, ofensivo\...).
-   La **descomposición**, la parte central de la AI, se basa en como
    dividir un problema en distintas partes y resolverlas.
    -   La *descomposición estructural* divide la solución en función de
        cada componente. Por ejemplo un componente para coger armas,
        otro para el movimiento\...
    -   La *descomposición de comportamiento* se basa en las distintas
        actividades del sistema (cazar, huir, explorar\...).
    -   *Descomposición por metas* utiliza la meta del sistema para
        determinar como dividir su comportamiento.
-   La **arbitrariedad** define como se mostrará\\interpretará el
    output.
    -   *Independiente* conecta cada componente con distintos outputs.
    -   *Combinación* permite mezclar outputs de distintos componentes
        para obtener un resultado final.
    -   *Supresión* de outputs significa que algunos componentes tienen
        prioridad sobre otros, los cuales pueden llegar a ser ignorados.
    -   *Secuencial* trata la salida de diferentes componentes
        alternandolas en el tiempo.

Ejemplos de distintos tipos son la *subsumption architecture*, usa
descomposición de comportamiento y una organización lineal con supresión
de outputs, este sistema se utiliza para implementar inteligencia
táctica. Un *sistema de votos* usa descomposición funcional,
organización lineal y una combinación de outputs. Este método puede ser
interpretado como distintos componentes responsables de acumular votos,
la salida con más votos sería la elegida.

## Recorriendo el entorno

### El entorno

El entorno de un juego se divide, básicamente, en:

-   **Estructura**: Parte del entorno que puede física afectar al
    movimiento (suelo, murallas, puertas, muebles\...) y que por tanto
    no son triviales para el usuario.
-   **Detalle**, consiste en la parte estética del entorno, cosas
    insignifcantes que no tienen relevancia.

Otros jugadores o elementos se tratarían de forma separada, tanto como
un elemento interactua con ellos o como ellos interactúan con el mundo,
lo que es distinto para los personajes dirigidos por humanos y para los
dirigidos por computador, los primeros reciben información mediante
estimulos visuales, mientras que los segundos primero reciben
(generalmente antes de empezar el juego) una simplificación del entorno
(ya sea por guías, puntos clave por donde pasar\...) y luego, a medida
que el juego avanza, lo van interpretando.\
\
En la forma de interpretar el entorno de un juego intervienen ciertas
propiedades de este así como las dimensiones (2d o 3d) o su precisión.
Para definir la precisión existen dos formas, la *discreta* (definida en
un grid dividido por celdas (derecha)) y la *continua* (definida por
coordenadas (izquierda)).
![](/ai/continuous-discrete.png){.align-center} Otra propiedad que
delimita un juego es el tiempo, el momento en que una acción puede
ocurrir, que en la misma forma que el espacio este puede ser clasificado
como continuo o discretos (donde se analizan las acciones acciones por
rangos de tiempo).

### Movimiento autónomo

El movimiento autonomo es la capacidad de un elemento de moverse sin
nada que intervenga en sus propias decisiones. Para que mediante AI
podamos crear un movimiento autónomo en un elemento primero tendremos
que recoger información sobre el entorno. Generalmente, en videojuegos,
lo que se hace es colocar una serie de *waypoints* (puntos clave o
guías) con valores que indiquen cuales son los siguientes posibles
waypoints en el camino, acciones posibles a hacer en ese punto\... Hasta
podemos llegar a implementar un algoritmo de rutas sobre estos waypoints
(un algoritmo de rutas como A\*, también llamados *pathfinding
algorithms* o *planning algorithms*).\
\
El reto del movimiento es generar una secuencia de pequeños pasos que
agrupados formen rutas con significado, para conseguirlo se intenta
emular las cualidades de los seres humanos haciendolo\...

-   *Realista*.
-   *Eficiente*, debido a que generalmente es una acción constante el
    código debe de ser fluido
-   *Alcanzable*, la AI debe garantizar que no irá nada mal y que
    alcanzará su destino.
-   *Con un proposito*, si se realiza movimiento ha de ser por
    satisfacción de un deseo.

Una de las características que el movimiento autónomo tiene es la
capacidad de esquivar obstáculos, lo cual es una tarea fácil de
programar; pongamos los cuatro ejemplos básicos:

1.  Cuando no hay obstáculos cerca del animat -\> Este puede moverse
    adia delante de forma normal, vagando o en línea recta.
2.  Cuando hay un muro a un lado -\> Debería apartarse de este, en plan
    preventivo.
3.  Si hay un obstáculo delante -\> Debería girar hacia un lado hasta
    esquivarlo.
4.  Si el animat se queda atascado en una esquina -\> Debería dar media
    vuelta.

### Analisis del entorno

Cuando el animat debe analizar el entorno se deben de tener en cuenta
una serie de conceptos, poniendo como ejemplo la acción de evitar un
obstáculo, estos son:

1.  *Plataforma*, el conjunto de software\\hardware, donde la AI debe
    actuar. Por ejemplo el juego en sí.
2.  *Tarea*, las metas que la AI debe alcanzar dentro de la plataforma.
    Por ejemplo entender el entorno para prevenir colisiones.
3.  *Información*, datos disponibles dentro de la plataforma para poder
    llevar a cabo la tarea. Por ejemplo, la estructura y detalle del
    entorno.
4.  *Resultado* (outcome), las distintas soluciones a la tarea. Por
    ejemplo, la detección de colisiones.
5.  *Input*, el conjunto de información posible dado en un formato
    entendible para la AI. Por ejemplo, los obstáculos cercanos.
6.  *Output*, las posibles acciones que pueden llevrse a cabo y que
    combinadas generan el resultado. Por ejemplo, el motor de
    movimiento.
7.  *Contexto*, los elementos en los que puede influir el resultado y
    los que restringen los inputs. Por ejemplo, la velocidad,
    posición\... del animat.
8.  *Problema*, la descripción que se le da a la AI de la tarea. Por
    ejemplo, evitar los obstáculos.
9.  *Solución*, la acción concreta que resuelve el problema, obtiene el
    resultado y segue los requisitos. Por ejemplo, la realización del
    movimiento.

#### Fase de analisis

La fase de análisis envuelve dos conceptos:

1.  *Tarea general*, la abilidad que damos al animat cuando usamos AI.
2.  *Plataforma*, aspectos del diseño (entorno) y software (simulación
    física) que afectan a la tarea.

El resultado del análisis se divide en tres partes:

1.  **Supuestos**. De la misma forma que los jugadores humanos, el
    módulo de la AI debe recibir información sobre los elementos que le
    facilitan su tarea.
2.  **Restricciones**. La parte de la plataforma que afecta a la tarea y
    que dificulta que esta sea realizada. Por ejemplo la estructura del
    terreno que impide algunos movimientos.
3.  **Guías**. Son aspectos de diseño (o procedimientos a seguir) que
    deben ser tenidos en cuenta mientras se realiza esta fase.

#### Fase de entendimiento

Esta fase enfoca una tarea particular, entender como deberá funcionar la
solución y definir lo mejor posible el problema. Esto depende de tres
conceptos:

1.  **Metas**, lo que queremos que la AI haga.
2.  **Requisitos**, lista de elementos que se han de tener en cuenta a
    la hora de solucionar el problema.
3.  **Restricciones**, aspectos que afectan a la solución del problema.

La definición del problema se basa en ciertos criterios que se deben
aplicar para llegar al resultado deseado, que una vez conseguido se
creará una secuencia de acciones que el animat llevará a cabo realizando
así la solución.

### Especificar el movimiento

Para indicar el movimiento a realizar necesitamos antes entender los
inputs, outputs y el contexto.\
FIXME **Ch8, pg90**
