# Estadística

## Conceptos

### Conceptos básicos

-   **Modelo**: Es una expresión simbólica en forma de igualdad o
    ecuación. Se utiliza para indicar qué variables intervienen en la
    respuesta.
-   **Distribución de frecuencias de una variable**: Conjunto de valores
    que puede adoptar una variable y la frecuencia.
-   **Outlier**: Un dato que está alejado del patrón.
-   **Variable aleatoria**: Es una variable que toma valores numéricos a
    partir de un experimento aleatorio. Su valor no está determinado por
    una causa concreta.
-   **Distribución**: Es una función que nos da la probabilidad de que
    un valor concreto para una variable aleatoria pueda ocurrir.
-   **Función de densidad**: La función que sigue una distirbución.

### Conjuntos

-   Cuando un elemento (*a*) existe dentro de un conjunto (*A*) decimos:
    \<m\>a in A\</m\>
-   Cuando todos los elementos de un conjunto (*A*) también están dentro
    de otro conjunto más grande (*B*) decimos: \<m\>A subset B\</m\>
-   El espacio (*S*) es donde están todos los elementos posibles.
-   El elemento nulo (*Ø*) no contiene ningún elemento.
-   El complementario (\<m\>overline{A}\</m\>) de un conjunto (*A*) es
    otro conjunto donde están todos los elementos del espacio que no
    están en dicho conjunto: \<m\>varnothing = overline{S}\</m\>
-   La unión de un conjunto (*A*) con otro conjunto (*B*) es un nuevo
    conjunto donde están todos los elementos de A y todos los elementos
    de B y es expresado como \<m\>A union B\</m\>
-   La intersección de un conjunto (*A*) con otro conjunto (*B*) es un
    nuevo conjunto donde están los elementos de A que también están en B
    y es expresado como \<m\>A inter B\</m\>

![](/numbers/statistics/union-intersec.png){.align-center width="400"}

## Análisis de datos

### Tipos de variables

-   **Cualitativas o categóricas**: No se pueden expresar numéricamente,
    sino como categorías o características (color de ojos, sexo\...).
-   **Cuantitativas**: Se pueden expresar de forma numérica\...
    -   **Cuantitativas discretas**: Toman valores enteros (generalmente
        corresponden al conteo de unidades en un grupo), por ejemplo
        número de hijos, puntos en un partido\...
    -   **Cuantitativas continuas**: Toman valores en un intérvalo.
        Peso, cotización, tiempo de acceso a una base de dato\...

Al estudiar variables numéricas nos encontramos con conceptos tales como
el **máximo** y el **mínimo** (valor más grande y más pequeño que puede
tomar dicha variable) y con el **rango**, es decir, la diferencia entre
el máximo y el mínimo.\
\
La frecuencia del valor de una variable la podemos encontrar como:

-   **Frecuencia absoluta**: El número de veces que encontramos un valor
    en el tamaño de la muestra.
-   **Frecuencia relativa**: La proporción del valor de una variable
    (frecuencia absoluta / tamaño de la muestra).

### Medidas de dispersión

Muestran propiedades de la distribución.

#### Moda

Valor que se ha repetido más veces en la muestra (el valor que tiene una
mayor frecuencia absoluta).

#### Mediana

El valor central del conjunto de valores. Para poder calcularla primero
hay que ordenar todas las observaciones.\
La mediana en la siguiente lista (impar) de valores es 15:
`1 12 13 15 15 15 17 18 19`\
Cuando la lista de valores es par sería la media entre los valores
centrales.

#### Media

La media de una variable x se otiene dividiendo la suma de todos los
valores por el número total de valores existentes (es el valor medio de
una variable).\
La media se representa como una X con palito horizontal arriba.\
La mediana es un indicativo más fiable que la media debido a que la
media puede ser distorsionada por los outlaiers.\
Existen las **desviaciones**, que son las diferencias entre las
distintas observaciones y la media: \<m\>x_i - media\</m\>. La suma de
todas es 0.

#### Cuartiles

-   **Primer cuartil (Q1)**: Es aquel número que al menos el 25% de las
    observaciones son menores o iguales que él.
-   **Segundo cuartil**: es la mediana.
-   **Tercer cuartil (Q3)**: Es aquel número que al menos el 75% de las
    observaciones son menores o iguales que él.

```{=html}
<!-- -->
```
    Números: 12 13 14 15 16 17 200
    Mediana: 15
    Q1: 13
    Q3: 17

-   **Rango intercuartílico**: medida que se calcula haciendo `Q3 - Q1`.

#### Varianza

Se representa como S², es una forma de saber cómo se distribuyen los
datos en torno a la media; sería el promedio de la diferencia de todos
los elementos con el punto central. Se suman las desviaciones al
cuadrado (para evitar el problema que los negativos anulen a los
positivos) y se dividen entre el número de elementos.
![](/numbers/statistics/varianza.png)

#### Desviación estándard o típica

Es lo que utilizamos para determinar la fluctuación de los datos. Es la
raíz cuadrada positiva de la varianza:\
\<m\>S = sqrt{S²}\</m\> La desviación estándar es simplemente el
\"promedio\" esperado con respecto a la media aritmética. Por ejemplo,
las muestras (0, 0, 14, 14), (0, 6, 8, 14) y (6, 6, 8, 8) tienen una
media de 7. Sus desviaciones típicas son 8,08, 5,77 y 1,15,
respectivamente. La tercera muestra tiene una desviación mucho menor que
las otras dos porque sus valores están más cerca de 7.\
\
Podríamos decir que si, por ejemplo, en una clase el conjunto normal de
notas está entre el 4 y el 7 la desviación (y por tanto la varianza)
sería más pequeña que si las notas están repartidas entre el 2 y 8. Aún
así es preferible el uso de la varianza ya que su valor está en las
mismas unidades que los datos. Además, si los datos están estandarizados
es más intuitivo su uso.

### Estandarizar valores

Los valores estandarizados tienen una media de 0 y una desviación típica
de 1.

## Probabilidad

Es el calculo de la tendencia que existe de que ocurra un suceso. A
dicha tendencia se le dará un valor entre 0 (no sucederá) y 1
(sucederá).

### Frecuencia relativa

Si tiramos un dado 100 veces y conseguimos los siguientes resultados:

  Resultado     1    2    3    4    5   6
  ------------- ---- ---- ---- ---- --- ----
  Apariciones   12   28   20   20   5   15

Podemos comprobar que es un dado **trucado** ya que la frecuencia de
aparición no está igualada entre los distintos resultados.

-   La **frecuencia relativa de un resultado** es su número de
    apariciones dividido entre el número total de tiradas. Por ejemplo,
    la frecuencia relativa de 2 es \<m\>28 / 100\</m\> y la de 5 es
    \<m\>5 / 100\</m\>. La suma de todas las frecuencias relativas
    dará 1.
-   La **frecuencia relativa de un suceso** relacionado con el estudio
    realizado (en este caso el tiro de los dados) es igual a la suma de
    las frecuencias relativas de los resultados favorables. Por ejemplo,
    la frecuencia relativa de un número par es la suma de la frecuencia
    relativa de los resultados pares: \<m\>28 / 100 + 20 / 100 + 15 /
    100 = 63 / 100\</m\>. Esto significa que ha salido un número par el
    63% de las veces.
-   Cuando los sucesos son incompatibles (o disyuntos) significa que sus
    resultados no coinciden en ninguno de los casos. Por ejemplo los
    sucesos *P = \"Sacar un número par\"* y *Q = \"Sacar 3 o 5\"*. La
    frecuencia relativa de P o Q será \<m\>P union Q\</m\>, es decir
    \<m\>63% + 25% = 88%\</m\>.
-   Si los sucesos no son incompatibles, como por ejemplo *P = \"Sacar
    un número par\"* y *Q = \"Sacar un número mayor que 3\"*, la
    frecuencia relativa será la suma de todos los valores favorables, es
    decir la suma de las frecuencias relativas de los resultados 2, 4, 5
    y 6.
-   **La frecuencia relativa de la unión de dos sucesos es la suma de
    las dos frecuencias relativas menos la intersición de las dos**. En
    el ejemplo *P = \"Sacar un número par\"* y *Q = \"Sacar un número
    mayor que 3\"*, \<m\>P inter Q = 20 / 100 + 15 / 100 = 35%\</m\> y
    \<m\>P = 28 / 100 + 20 / 100 + 15 / 100 = 63%\</m\> y \<m\>Q = 20 /
    100 + 5 /100 + 15 / 100 = 40%\</m\>. \<m\>P union Q = 63% + 40% -
    35% = 68%\</m\>.
-   La frecuencia relativa de \<m\>overline{A}\</m\> es 1 menos la
    frecuencia relativa de A.

### Propiedades de la probabilidad

### Probabilidad condicionada e independencia de sucesos

La **probabilidad condicional** se expresa como `P(A|B)` y equivale a
decir \"la probabilidad de que ocurra A sabiendo que ocurre (o ha
ocurrido o va a ocurrir o está ocurriendo) B\", es decir, \"dando B qué
probabilidad hay de que ocurra A\", se escribe `P(A|B)` y se lee *la
probabilidad de A dado B*. No tiene por qué haber una relación entre A y
B, ni en tiempo (no tiene por qué suceder ninguno antes) o por causa, A
puede causar B, viceversa o simplemente pueden no tener relación
alguna.\
Se expresa como:\
\<m\>P(A\|B) = {P(A inter B)} / {P(B)} \</m\>\
\
\
\
Por ejemplo, calcular la probabilidad de que al tirar un dado salga un 6
habiendo salido previamente un par:\
\
\<m\>P(6\|par) = {1/6}/{3/6} = 1/3\</m\>\
Otro ejemplo:

    La probabilidad de tener una enfermedad rara es de 0,001: P(enfermo) = 0,001
    La probabilidad de que cuando el paciente está enfermo se acierte en el diagnóstico es de 0,99: P(positivo | enfermo) = 0,99
    La probabilidad de falso positivo es de 0,05: P(positivo | sano) = 0,05
    Pregunta: Me dicen que he dado positivo, ¿Qué probabilidad hay de que tenga la enfermedad?

![](/numbers/statistics/prob_cond_0.png)

### Árboles de probabilidad

Teniendo la siguiente proposición:\
\'\'En una universidad los estudiantes se matriculan en tres carreras
del siguiente modo: el 20% estudian arquitectura, el 35% medicina y el
45% economía. El porcentaje de alumnos que finalizan sus estudios en
cada caso es del 5%, 12% y del 18%. \'\'\

Podemos montar un árbol de probabilidades\...

1.  \...este se hace a partir de un inicio (100% de elementos) que se va
    distribuyendo en las distintas cantidades de las opciones (sucesos
    incompatibles), en este caso 1 se distribuye en 0.2, 0.35 y 0.45.
2.  Estos a su vez se distribuyen en las distintas opciones, los que sí
    que finalizan los estudios y los que no finalizan los estudios. En
    este caso tenemos los que si finalizan los estudios: 0.05 de 0.2
    (0.05 \* 0.2 = 0.01), 0.12 de 0.35 (0.12 \* 0.35 = 0.042) y 0.18 de
    0.45 (0.18 \* 0.45 = 0.081).
3.  Para acabar tenemos que saber cuales son las probabilidades de que
    algo no ocurra, para ello para cada una de estas probabilidades
    cogemos el tanto por ciento concreto y lo restamos de 100 (o, en
    este caso de 1). Por ejemplo, si en los que estudian arquitectura el
    tanto por ciento de los que aprueban es el 5% el tanto por ciento de
    los que no es 95%, es decir 0.95 de 0.2 (0.95 \* 0.2 = 0.19).\

![](/numbers/statistics/arbol.png){.align-center width="295"}

\

-   Para comprobar si está correcto la suma de las columnas ha de sumar
    1:
    -   \<m\>0.2 + 0.35 + 0.45 = 1\</m\>
    -   \<m\>0.01 + 0.19 + 0.042 + 0.308 + 0.081 + 0.369 = 1\</m\>
-   Podemos saber la probabilidad de que un alumno acabe la carrera,
    esta es: \<m\>0.01 + 0.042 + 0.081 = 0.133\</m\>. Y la que no:
    \<m\>1 - 0.133 = 0.867 = 0.19 + 0.308 + 0.369\</m\>
-   Podemos saber fácilmente que probabilidad tendrá un alumno de acabar
    la carrera si estudia arquitectura o medicina (\<m\>0.01 + 0.042 =
    0.052\</m\>)

Se diría que la probabilidad de entrar en una carrera u otra sería:
\<m\>P(A_1), P(A_2), P(A_3)\</m\>, para arquitectura, medicina y
economía respectivamente y el acabar los estudios sería \<m\>P(B_1),
P(B_2)\</m\> según si es acabarlos o no.\
Aprobar los estudios de arquitectura sería pues: \<m\>P(A_1 inter
B_1)\</m\>. Y aprobar los estudios habiendo hecho arquitectura
\<m\>P(B_1 \| A_1)\</m\>. Por lo tanto: \<m\>P(A_i inter B_j) = P(A_i) ·
P(B_j \| A_i)\</m\>

### Teorema de Bayes

Es una fórmula de calcular las probabilidades de sucesos incompatibles:\

\<m\>P(A_i\|B) = {P(B\|A_i)P(A_i)} / {sum{j}{n}{P(B\|A_j)P(A_j)}}
\</m\>\
\
\
\
\
\
\

Por ejemplo,
`teniendo que la probabilidad de que haya un accidente en una fábrica es de 0.1. La probabilidad de que la alarma suene si se ha producido un accidente es de 0.97 y de que suene siendo una falsa alarma es de 0.02. Entonces, dando por supuesto que suena la alarma, qué probabilidad hay de que haya sido por una falsa alarma?`\
Tenemos pues:

-   `B = Producirse incidente`
-   `A = Sonar la alarma`

![](/numbers/statistics/0_54.gif)

-   \<m\>P(overline{B}\|A) = {(0.9 · 0.02)} / {0.1 · 0.97 + 0.9 · 0.02}
    = 0.157\</m\>

Lo que hace es dar la probabilidad de A dado B a partir de la
probabilidad de B dado A. Es decir, sabiendo la probabilidad de tener un
dolor de cabeza cuando se tiene gripe, se podría saber la probabilidad
de tener gripe si se tiene un dolor de cabeza.

## Distribuciones

Una distribución es una función que nos da la probabilidad de que un
valor concreto para una variable pueda ocurrir. Las distribuciones tiene
una forma concreta, según esta son discretas o continuas.\
La función que siguen una distribución es denominada **función de
densidad**.

### Tipos

#### Discretas

-   **Binomial**: Los ensayos son independientes y la probabilidad de
    éxisto es fija, además únicamente tiene dos posibles resultados:
    éxito (p) o fracaso (1-p).
-   **De Poisson**: A partir de la frecuencia de un evento estudia la
    probabilidad de que ocurran otros durante cierto periodo de tiempo.

#### Continuas

Aquellas que pueden tomar cualquier valor existente dentro de un
intervalo.

-   **Normal**: o gausiana, en una serie de echos podemos ver los más
    frecuentes en el centro y los menos a los distintos lados del
    gráfico. Se define a partir de μ (la media) y σ (la desviación
    típica (σ² es la varianza)).
-   **De Pearson o χ²**
-   **t de Student**: Cuando la muestra es pequeña.
-   **De Laplace**

### Normal

![](/numbers/statistics/campana_gauss1.gif)

#### El teorema del límite central

Dice que cuando el número de variables aleatorias es suficientemente
grande la distribución que siguen los experimentos es normal.

## Intervalos de confianza

Podemos escribir la probabilidad de la forma\...\
`P(L ≤ Θ ≤ U) = 1 - ∝`\
, donde *L* y *U* son funciones para los datos y Θ el parámetro. Quiere
decir que el valor de Θ estará entre *L* y *U* en un `100·(1-∝)`% de las
veces que se haga el experimento.
