# Cálculo

## Conceptos

-   **Ecuación diferencial**: Aquella en la que intervienen derivadas de
    una o más funciones. Su orden vendrá dado por el orden más alto de
    sus derivadas.

**Derivada e integral:**

  Campo        Derivada                                                                                                         Integral
  ------------ ---------------------------------------------------------------------------------------------------------------- ------------------------------------------------------
  Geométrico   Recta tangente a una curva en un punto dado                                                                      Área bajo una curva y el eje de las abcisas
  Físico       Razón de cambio instantánea                                                                                      Suma de elementos infinitos e infinitamente pequeños
  Matemático   Operación que se realiza con una función para conocer el comportamiento de su razón de cambio en cada instante   Operador inverso de la derivada

Es decir, por ejemplo la derivada, en física es útil para hallar la
velocidad, la aceleración, la energía\... En biología y economía para
observación del crecimiento de una población, de ingresos\... En general
puede servir para observar la velocidad y la razón de un cambio. La
integral puede ser usada en física para hallar el trabajo, el campo
eléctrico, el magnético\...

## Límites

## Cálculo integral

## Cálculo diferencial

### Concepto

El valor de la derivada de una función en un punto es la pendiente de la
tangente de la función en ese punto.\
Imaginemos la siguiente función *f(x)* que muesta la velocidad:\
![](/numbers/maths/deriv01.png){.align-center width="300"}\
\<m\>A = (Xa, Ya); B = (Xb, Yb); Pendiente AB = {Yb - Ya}/{Xb -
Xa}\</m\>\
Cuando acercamos B a A nos quedamos quedamos con la tangente en el punto
A. Y lo expresamos como el cociente del incremento de y entre el de x:
`△y/△x` o lo que es lo mismo, la derivada: `dy/dx`\
![](/numbers/maths/deriv02.png){.align-center width="300"}\
Si tenemos *h* que equivale a la distancia de X entre A y B\...
![](/numbers/maths/deriv03.png){.align-center}\
\
Es decir: ![](/numbers/maths/deriv04.png){.align-center}\
\
Diríamos que encontramos la tangente de la curva cuando la h tiende a 0:
\<m\>lim{h right 0}{}{f(x+h)-f(x)}/h=df/dx\</m\>\
\

### Gráfico de la derivada

Las siguientes son gráficas de funciones, *s* podría ser la posición en
el tiempo y *v* la velocidad (es decir, su derivada).
![](/numbers/maths/deriv05.png){.align-center}\
Como podemos ver, si la función es una línea recta la pendiente será
constante y, por lo tanto, la derivada es constante.\
Para ir entendiendo la gráfica de la derivada debemos ir viendo donde
hay cambios, si ese cambio es una línea horizontal el valor de la
derivada está en 0.\
\
![](/numbers/maths/deriv06.png){.align-center width="250"}\
![](/numbers/maths/deriv07.png){.align-center}

### Reglas de derivación

-   <http://es.wikipedia.org/wiki/Reglas_de_derivaci%C3%B3n>

#### Derivada de una constante

#### Derivada de una potencia entera

#### Derivada de una constante por una función

#### Derivada de una suma

#### Derivada de un producto

#### Derivada de un cociente

#### Derivada de funciones trigonométricas

#### Regla de la cadena

### Optimización

En una función existen los puntos extremos, son aquellos en los que la
función tiene un valor mayor o menor (máximos y mínimos).\
![](/numbers/calculo/optimizacion.png){width="300"}\
Encontrar los puntos extremos de una función puede sernos de gran
utilidad (buscar el precio más bajo, la duración más larga, la mayor
eficiencia\...). Simplemente teniendo una expresión que calcule un valor
(precio, duración, eficiencia\...) haríamos su derivada con respecto a
sus parámetros, la igualaríamos a cero y la resolveríamos para aquellos
parámetros que buscamos.

### Notas
