# MATLAB

## Pequeñas pinceladas

-   El lenguaje que utiliza se denomina M.
-   Podemos introducir varios comandos en una línea, estos podrían estar
    separados (y finalizados) por \';\' , en ese caso no mostrará los
    cálculos realizados por pantalla. Podemos separarlos por \',\',
    entonces sí que los mostrará.
-   **clear** borrará todas la memoria y cálculos realizados hasta ese
    momento. **clear a** borrará el valor de la variable `a`.
-   **home** pondrá el cursor al inicio de la línea de comandos y
    **clc** la limpiará.
-   Cuando se realiza una operación el resultado se guarda
    (sobreescribe) una variable llamada `ans`.
-   **pause(x)** hace que matlab se detenga por x segundos.
-   Pedir entrada al usuario por teclado, con la función **input(\'
    \')**.

### Funciones básicas

-   **help funcion**: Muestra la ayuda para dicha fucnción:
    `help solve`.
-   **solve**: Soluciona una ecuación: `solve ('x + 3 = 55', 'x')`,
    retornará 52.
-   **random**: Recoge un valor aleatorio según una distribución
    indicada, por ejemplo un valor repartido uniformemenete entre 0 y
    1000: `random ('unif',0,1000)`.

### Entorno

### Control de flujo

#### Bucle for

``` matlab
for t = 0:10

end
```

#### Condicionales

``` matlab
if t > 1.0
   Vapp = 1;
end   

```

## Operaciones con\...

### Arrays\\Vectores

-   Generar un vector automáticamente:

``` matlab
x = 0:10 % de 0 a 10 de 1 en 1
x = 0.0:0.01:1.0 % de 0 a 1.0 de 0.01 en 0.01
```

### Matrices

#### Definir\...

-   Una matriz de 3x3:

``` matlab
a = [ 1 4 7 ; 2 5 8 ; 3 6 9 ]
a =
     1     4     7
     2     5     8
     3     6     9
```

#### Operaciones

-   Si en `A` tenemos una matriz podemos hacer su traspuesta haciendo:
    `A`\'.

#### Acceso a\...

``` matlab
matriz(4, 2)  % Fila 4, columna 2
matriz(2,:)   % Fila 2
matriz(:,3)   % Columna 3
matrix(2,1:2) % Fila 2, columnas 1 a 2
matrix(:,1:3) % Las tres primeras columnas
```

### Cálculos con símbolos

Matlab permite realizar cálculos con símbolos\\incógnitas, esto es,
lanzar comandos y que el resultado sea una expresión en función de estas
variables.\
Con el comando `sym` podemos declarar una variable simbólica (con `syms`
podemos declarar varias):

``` matlab
alpha = sym('alpha')
```

Con `subs` indicamos, en una variable que tenga una expresión en función
de símbolos, los valores que han de tomar. Su sintaxis es:
`subs(variable, {simbolos a sustituir}, {valores})`.\

``` matlab
>> syms a b
>> Mat_A = [2 3 a; 5 43 1; 2 b 3]
Mat_A =
[ 2,  3, a]
[ 5, 43, 1]
[ 2,  b, 3]
>> Mat_B = [sin(a); 4; 5]
Mat_B =
 sin(a)
      4
      5
>> Mat_C = Mat_A * Mat_B
Mat_C =
 5*a + 2*sin(a) + 12
      5*sin(a) + 177
 4*b + 2*sin(a) + 15
>> subs(Mat_C, {a, b}, {3, 4})
ans =
   27.2822
  177.7056
   31.2822
```

## Dibujar

### Funciones básicas de dibujo

-   `clf`: borra el dibujo actual.
-   `hold on`: hace que todo lo que se dibuje a partir de ahora sea
    sobre el mismo dibujo.

### Como\...

-   **Dibujar un círculo**

``` matlab
[x,y,z] = cylinder(Radius,200);
plot(x(1,:),y(1,:))
axis equal
```

## GUIS & GUIDE

### Funciones

-   `uiputfile`: Muestra un diálogo para guardar ficheros.
-   `uigetdir`: Muestra un diálogo para recoger un path.

### Como\...

-   Dibujar sobre varios `axe`. Pongamos que tenemos uno con tag `axe1`
    y otro con tag `axe2` pues antes de dibujar, por ejemplo sobre
    `axe1`, haremos `axes(handles.axe1);`.
-   Si vamos a utilizar variables globales las tendremos que declarar al
    principio de la función como `global`.
-   Encontrar la distancia euclídea entre dos puntos:

``` matlab
a = [2 3]
b = [4 8] 
d = pdist([a;b], 'euclidean')
```

## Librerías

### Image Processing

#### Funciones

**Funciones sobre archivos:**

-   `imread(path)`: lee una imágen.
-   `imfinfo(path)`: muestra información de un archivo de imágen.
-   `imwrite (I, path)`: guarda I en la ruta path.

\
**Muestra información:**

-   `imshow(I)`: muestra la imágen I. Podemos mostrar varias imágenes a
    la vez: `imshow([image1,K, L]);` Un `;` la mostraría en la siguiente
    línea.
-   `imhist(I)`: muestra el histograma de I.
-   `size(I)`: recoge el tamaño de I.

``` matlab
[w h] = size(K);
```

\
**Edición:**

-   `rgb2gray(I)`: pasa una imágen I a 8 bits.
-   `im2bw(I, num)`: aplica un threshold (num de 0 a 1) a la imágen I.
-   `histeq(I)`: Ecualiza el histograma de la imágen.
-   `imcrop(I, [x y width height])`: Hace un crop de la imágen.
-   `strel` crea un elemento morfológico, acepta una cadena que define
    el elemento y los parámetros para este. El elemento puede `square`
    (acepta un valor), `line` (acepta 2 valores: la longitud y el
    ángulo), `disk` (acepta un valor, el radio) y `ball` (acepta el
    radio y la altura).
-   `imdilate` dilata un borde según un elemento morfológico.

``` matlab
se = strel('disk',5);
image1 = imdilate(image1, se);
```

-   `imfill`: rellena una imágen hueca.

``` matlab
image1 = imfill(image1,'hole');
```

\
**Algoritmos**

-   `edge (I, algoritmo)`: Detección de bordes por un algoritmo
    concreto, acepta: canny, sobel, prewitt, log, roberts, zerocross. A
    canny puedes indicarle el threshold para el corte en forma de vector
    de dos posiciones (donde la primera es el valor mínimo, y la segunda
    el máximo) o un escalar (el valor máximo).

``` matlab
I1 = edge(I0, 'sobel');
image1 = edge(image0, 'canny', .2);
```

\
**Notas:**

-   `figure, imshow(I)`: abrirá una nueva ventana para mostrar imágenes
    y en ella mostrará la imágen I.
-   `imtool` es una herramienta que te permite realizar acciones básicas
    sobre imágenes como por ejemplo crop o ver los bytes RGB (al hacer
    mucho zoom).

## Notas

-   ![Comparación de MATLAB y R](/math_langs/matlabr.pdf), sacada de
    <http://www.math.umaine.edu/~hiebeler/comp/matlabR.html>.
