# Linq to XML

Es la capacidad que tiene .NET de acceder fácil y rápidamente a datos en
formato xml.\

## Básico

Pongamos el siguiente ejemplo de xml:

``` xml
<?xml version="1.0" encoding="utf-8" ?>
<persons>
  <person status="disabled">
    <name>Alfred</name>
    <surname>GarGon</surname>
    <projects>
      <project>VS</project>
      <project>Geisa</project>
    </projects>
  </person>
  <person>
    <name>Albert</name>
    <surname>Dilbert</surname>
    <projects>
      <project>Temari</project>
    </projects>
  </person>
  <person>
    <name>Joan</name>
    <surname>Nap</surname>
    <projects>
      <project>Temari</project>
      <project>Geisa</project>
      <project>VS</project>
    </projects>
  </person>
  <person status="disabled">
    <name>Pepe</name>
    <surname>Teca</surname>
    <projects>
      <project>VS</project>
    </projects>
  </person>
</persons>
```

## Consultar atributos y elementos

Para abrir, cargar y consultar el archivo se utiliza la clase
`System.Xml.Linq.XDocument`. Luego querremos realizar consultas sobre
los objetos person, por ejemplo los que esten con el atributo status
enabled:

``` csharp
XDocument xmlDoc = XDocument.Load("XMLFile1.xml");
var persons = from person in xmlDoc.Descendants("person")
              where ((person.Attribute("status") == null) || (person.Attribute("status").Value != "disabled"))
              select new
              {
                  name = person.Element("name").Value,
                  surname = person.Element("surname").Value
              };

foreach (var p in persons)
    Console.WriteLine(p.name + " " + p.surname);
```

## Consultar elementos anidados

``` csharp
XDocument xmlDoc = XDocument.Load("XMLFile1.xml");
var persons = from person in xmlDoc.Descendants("person")
              where ((person.Attribute("status") == null) || (person.Attribute("status").Value != "disabled"))
              select new
              {
                  name = person.Element("name").Value,
                  surname = person.Element("surname").Value,
                  projects = (from project in person.Elements("projects")
                              select project.Value).ToList()
              };

foreach (var per in persons)
{
    Console.Write(per.name + ": ");
    foreach(var proj in per.projects)
        Console.Write(proj.ToString());
    Console.WriteLine();
}
```

## Crear elementos

### Crear fichero .xml

Ejemplo:

``` csharp
List<XElement> lAppsConf = getListXElements(user.AppsConf);
XDocument doc = new XDocument(
    new XDeclaration("1.0", "utf-8", "true"),
    new XElement("user",
        new XElement("name", user.name),
        new XElement("password", user.pass),
        new XElement("default_app", user.defAppId),
        new XElement("admin", user.admin.ToString()),
        new XElement("apps_conf", lAppsConf)));
doc.Save(path);
```

Para agregar atributos podemos hacer lo siguiente:

``` csharp
XElement element = new XElement("parada", 
                new XAttribute("parada", numParada.ToString()),
                new XAttribute("descripcio", ""),
                getBuses());
```

\...O\...

``` csharp
element.SetAttributeValue("parada", "33");
```

## Notas

-   El método estático `XDocument.Load` recibe un string que corresponde
    a una URI; quiero decir, también podría aceptar una dirección
    externa a partir del protocolo http, por ejemplo.
-   Para recoger el fichero xml podremos llamar al método `Save`, pero
    si lo queremos en un string haremos:

``` csharp
System.Text.StringBuilder output = new System.Text.StringBuilder();
output.Append(doc.Declaration + Environment.NewLine);
output.Append(doc.ToString());
string str = output.ToString();
```
