# EasyGIS

Es una librería bastante sencilla para la creación de aplicaciones GIS
con .NET.\

-   Su página es: <http://www.easygisdotnet.com/>.
-   Podemos encontrar ejemplos en: <http://www.easygisdotnet.com/api/>

## Creación de shapes

Para la creación de shapefiles hemos de agregar como referencia la
librería `EGIS.ShapeFileLib.dll`. Mediante esta tendremos acceso a la
estructura `EGIS.ShapeFileLib.DbfFieldDesc` la cual nos servirá para
indicar\\configurar los campos de información que existirán por cada
registro de la shape. Para ello crearemos un array de `DbfFieldDesc` en
el que especificamos cada campo:

``` csharp
DbfFieldDesc[] d = new DbfFieldDesc[4];

d[0].FieldLength = 5;
d[0].FieldName = "ID_TRAJECTE";
d[0].FieldType = DbfFieldType.Number;

d[1].FieldLength = 3;
d[1].FieldName = "CODPUB_T";
d[1].FieldType = DbfFieldType.Character;

d[2].FieldLength = 25;
d[2].FieldName = "D_TRAJECTE";
d[2].FieldType = DbfFieldType.Character;

d[3].FieldLength = 5;
d[3].FieldName = "ID_LINIA";
d[3].FieldType = DbfFieldType.Number;
```

Luego crearemos un objeto `ShapeFileWriter` mediante el método
`ShapeFileWriter.CreateWritter`, al que le pasamos los siguientes
argumentos:

1.  La ruta donde crearemos la shape.
2.  El nombre del fichero shape.
3.  El tipo (dentro de la enumeración `EGIS.ShapeFileLib.ShapeType`, que
    puede ser `Point`, `MultiPoint`, `Poligon`, `PolyLine`\...)
4.  El array de `DbfFieldDesc` que define los campos.

``` csharp
ShapeFileWriter sfw = ShapeFileWriter.CreateWriter("c:\\LiniesExportadesSAE\\", "Line", ShapeType.PolyLine, d);
```

Luego, por cada elemento\\registro que queramos agregar a la shapefile
llamaremos al método `AddRecord` del `ShapeFileWriter`. Como en nuestro
caso creamos una linia tendremos que ir agregando los puntos que la
forman mediante un array de `PointF`, luego crearemos un array de
strings que contendrá los valores de cada campo definidos en el array de
`DbfFieldDesc`.

``` csharp
PointF[] ps = new PointF[numSubVials];
foreach (int i=0; i<numSubVials; i++)
    ps[i] = new PointF(float.Parse(SubVials[i].x), float.Parse(SubVials[i].y));

string[] values = new string[4];
values[0] = t.id;
values[1] = fixString(t.cod_pub);
values[2] = fixString(t.denominacio);
values[3] = l.id;

sfw.AddRecord(ps, ps.Length, values);
```

Y luego, finalizaremos el writer:

``` csharp
sfw.Close();
```

## Lectura de Shapes

### Lectura de la forma

``` csharp
string file = "c:\\Export_Output.shp";
ShapeFile sf = new ShapeFile(file);
ShapeFileEnumerator sfEnum = sf.GetShapeFileEnumerator();
while (sfEnum.MoveNext())
{
    PointF[] points = sfEnum.Current[0];
    int a = points.Length;
}
sf.Close();
```

### Lectura de los datos

## Notas

### Elementos

-   ![Ensamblados](/fw/othersnet/egis_dt_2_2.zip)
-   ![API](/fw/othersnet/egis_api.zip)
