# Librerías de jQuery y JavaScript

## Librerías de jQuery

### Table Sorter

-   **Función**: Crear una tabla con la posibilidad de ordenar.
-   **Link**: <http://tablesorter.com/docs/>
-   ![Ficheros](/fw/others/jquerylibs/jquery.tablesorter.min.js.zip)

Es necesario que la tabla tenga las tags `THEAD` y `TBODY`.\
Para agregar la ordenación a la tabla:

``` javascript
$(document).ready(function() 
    { 
        $("#myTable").tablesorter(); 
    } 
); 
```

### quickSearch

-   **Función**: Permite agregar una búsqueda ágil a una tabla.
-   **Link**: <http://rikrikrik.com/jquery/quicksearch/>
-   ![](/fw/others/jquerylibs/jquery.quicksearch.js.zip)

Para agregar a la tabla:

``` javascript
$(document).ready(function() 
    $("#<%= GridView1.ClientID %> tbody tr").quicksearch({
        position: 'before',
        attached: '#<%= GridView1.ClientID %>',
        stripeRowClass: ['oddCell', 'evenCell'],
        labelText: 'Cercar a la llista:',
        isFieldset: true
    });
); 
```

Con ASP.NET, necesitaremos hacer que aparezcan el THEAD y TBODY en el
gridView, para ello en el control, después de hacer el binding haremos:

``` csharp
this.GridView1.HeaderRow.TableSection = TableRowSection.TableHeader;
```

### Timer

-   **Función**: Permite gestionar tiempos en jQuery.
-   **Link**: <http://plugins.jquery.com/project/Timer>

Por ejemplo, tras agregarlo, para que cada 30 segundos se llame a una
función:

``` javascript
$.timer(30000, function (timer) {
  getData();
});
```

### Query

-   **Función**: Permite acceso fácil a la query string.
-   **Link**: <http://plugins.jquery.com/project/query-object>
-   **Archivo**: ![](/fw/others/jquerylibs/jquery.query.rar)

``` javascript
var section = $.query.get('section');
> "info"
var id = $.query.get('id');
> 123
var debug = $.query.get('debug');
> true
var arr = $.query.get('testy');
> ["true", "false", true]
var arrayElement = $.query.get('testy[1]');
> "false"
var newUrl = $.query.set("section", 5).set("action", "do").toString();
> "?action=do&section=5&id=123"
var newQuery = "" + $.query.set('type', 'string');
> "?action=view&section=info&id=123&type=string"
var oldQuery = $.query.toString();
> "?action=view&section=info&id=123"
var oldQuery2 = $.query;
> ?action=view&section=info&id=123
var newerQuery = $.query.SET('type', 'string');
> ?action=view&section=info&id=123&type=string
var notOldQuery = $.query.toString();
> "?action=view&section=info&id=123&type=string"
var oldQueryAgain = $.query.REMOVE("type");
> ?action=view&section=info&id=123
var emptyQuery = $.query.empty();
> ""
var stillTheSame = $.query.copy();
> ?action=view&section=info&id=123
```

### Splitter

-   **Función**: Permite hacer los divs redimensionables.
-   **Link**: <http://methvin.com/splitter/>
-   **Archivo**: ![jQuery Splitter
    Plugin](/fw/others/jquerylibs/splitter-1.5.1.zip)

```{=html}
<!-- -->
```
    #MySplitter {
        border: 3px solid #669;
        min-width: 500px;   /* Splitter can't be too thin ... */
        min-height: 300px;  /* ... or too flat */
        height: 100%;
    }
    #LeftPane {
        background: #ddf;
        width: 150px;
        min-width: 100px;
        max-width: 300px;
        overflow: auto;     /* Scroll bars appear as needed */
    }
    #TopPane {              /* Top nested in right pane */
        background: #ccf;
        height: 150px;      /* Initial height */
        min-height: 75px;   /* Minimum height */
        overflow: auto; 
    }
    #BottomPane {           /* Bottom nested in right pane */
        background: #eef;
        min-height: 100px;
        overflow: auto;
    }

    /* Splitbar styles; these are the default class names */

    .vsplitbar {
        width: 6px;
        background: #669 url(img/vgrabber.gif) no-repeat center;
    }
    .vsplitbar:hover, .vsplitbar.active {
        background: #c66 url(img/vgrabber.gif) no-repeat center;
        opacity: 0.7;
        filter: alpha(opacity=70); /* IE */
        background: #c99;
    }
    .hsplitbar {
        height: 6px;
        background: #669 url(img/hgrabber.gif) no-repeat center;
    }
    .hsplitbar.active, .hsplitbar:hover {
        background: #c66 url(img/hgrabber.gif) no-repeat center;
    }
    ...
    $().ready(function() {
        $("#MySplitter").splitter({
            splitVertical: true,
            outline: true,
            sizeLeft: true,
            anchorToWindow: true,
            accessKey: "I"
        });

        $("#RightPane").splitter({
            splitHorizontal: true,
            sizeTop: true,
            accessKey: "H"
        });
    });
    </script>
    ...
    <div id="MySplitter">
      <div id="LeftPane">
      Texto en la parte izquierda.
      </div>
      <div id="RightPane">
        <div id="TopPane">
        Texto en la parte derecha-arriba.
        </div>
        <div id="BottomPane">
        Texto en la parte derecha-abajo.
        </div>
      </div> <!-- #RightPane -->
    </div> <!-- #MySplitter -->

### Tabs

-   **Función**: Te muestra tabs (pestaña) a partir de una lista.
-   **Link**: <http://stilbuero.de/jquery/tabs/>
-   **Archivo**: ![jQuery Tabs](/fw/others/jquerylibs/jquery.tabs.zip)

``` html
...
<script src="jquery.tabs.pack.js" type="text/javascript"></script>
...
<script type="text/javascript">
            $(function() {
                $('#container-1').tabs();
            });
</script>
...
<link rel="stylesheet" href="jquery.tabs.css">
...
<div id="container-1">
            <ul>
                <li><a href="#fragment-1"><span>One</span></a></li>

                <li><a href="#fragment-2"><span>Two</span></a></li>
                <li><a href="#fragment-3"><span>Tabs are flexible again</span></a></li>
            </ul>
            <div id="fragment-1">
                <p>First tab is active by default:</p>
                Prueba

            </div>
            <div id="fragment-2">
                Lorem ipsum dolor sit amet, consectetuer adipiscing elit, sed diam nonummy nibh euismod tincidunt ut laoreet dolore magna aliquam erat volutpat.
                Lorem ipsum dolor sit amet, consectetuer adipiscing elit, sed diam nonummy nibh euismod tincidunt ut laoreet dolore magna aliquam erat volutpat.
            </div>
            <div id="fragment-3">
                Lorem ipsum dolor sit amet, consectetuer adipiscing elit, sed diam nonummy nibh euismod tincidunt ut laoreet dolore magna aliquam erat volutpat.
                Lorem ipsum dolor sit amet, consectetuer adipiscing elit, sed diam nonummy nibh euismod tincidunt ut laoreet dolore magna aliquam erat volutpat.
                Lorem ipsum dolor sit amet, consectetuer adipiscing elit, sed diam nonummy nibh euismod tincidunt ut laoreet dolore magna aliquam erat volutpat.
            </div>
        </div>
```

### jGrowl

-   **Función**: Muestra mensajes en formato \"mac\".
-   **Link**: <http://stanlemon.net/projects/jgrowl.html>
-   **Archivo**: ![jGrowl](/fw/others/jquerylibs/jgrowl-1.2.4.zip)

``` javascript
$.jGrowl("Hello world!");
$.jGrowl("Stick this!", { sticky: true });
$.jGrowl("A message with a header", { header: 'Important' });
$.jGrowl("A message that will live a little longer.", { life: 10000 });
$.jGrowl("A message with a beforeOpen callback and a different opening animation.", {
    beforeClose: function(e,m) {
        alert('About to close this notification!');
    },
    animateOpen: {
        height: 'show'
    }
});
...
.jgError { color: red;  } 
div.jGrowl div.jgError {
    background-color:       #FFF1C2;
    color:                  navy;
}
....
$.jGrowl("hola", { sticky: true, theme: "jgError" });
```

## Librerías de JavaScript

### TinyMCE

-   [Sitio oficial](http://tinymce.moxiecode.com/)
-   ![](/fw/others/tinymce_3_2_7.zip)

#### Agregarlo cuando se utiliza jQuery

-   ![](/fw/others/jquerylibs/tinymce_3_2_7_jquery.zip)

``` javascript
$(document).ready(function() {
    $('textarea').tinymce({
        script_url: './jscript/tiny_mce/tiny_mce.js',
        theme: "advanced"
    });
});
```
