# Gráficos con OpenGL y GLSL

## Conceptos

### Graphics pipeline

Se refiere a los pasos que sigue la tarjeta gráfica para dibujar por
pantalla.\

En sí es la manipulación de los vértices y los modelos que acaban siendo
una porción del `framebuffer`, este concretamente corresponde a lo que
se acaba mostrando por pantalla.

1.  **Operaciones Per-Vertex:** los vértices son almacenados por OpenGL
    mediante la proyección de las matrices modelo-vista y convertidos a
    coordenadas de ventana. También es justo en esta en la que los
    shaders son calculados (controlados por GLSL), se colocan pues las
    luces, los reflejos y propiedades de superficies.
2.   **Clipping y cullin**g: Se calcula el clipping (porción de las
    primitivas que va a dibujarse) y qué caras son marcadas por culling
    (selección de caras que se han de ver) se han de preparar para la
    rasterización.
3.  **Transformaciones de proyección de de vista**: se aplica la
    transformación por perspectiva, los objetos que están lejos de la
    cámara se hacen más pequeños.
4.  **Rasterización**: Los vértices que forman las primitivas se unen y
    se rasterizan (se rellenan). Esta fase es compleja y contiene el
    conjunto de sub-pasos denominado pixel pipeline.
5.  **Operaciones per-fragment**: Esta fase también puede ser manipulada
    por GLSL, esta vez utilizando los fragment-shaders. Aquí se calculan
    los colores finales de los pixels en la pantalla.
6.  **Framebuffer**: En esta última fase los píxels ya forman parte de
    la porción de memoria llamada framebuffer. Por defecto este es
    pasado a pantalla cuando hay un intercambio (swap) de buffers.
    OpenGL permite varios objetos framebuffer (FBO) para crear una
    animación más fluida. A la vez, esto FBO también pueden ser
    aplicados como texturas o primitivas.

### Matrices de OpenGL

### Shaders

Los shaders son programas que se ejecutan sobre el procesador gráfico y
son utilizados para modificar los efectos de luz, sombras y producir
efectos de postprocesado especiales. Proporcionan gran flexibilidad a la
hora de programar la GPU.

#### Tipos de shaders

-   **Vertex shaders**: Se ejecutan por cada vértice. Su propósito es
    transformar cada vértice 3d en una coordenada 2d. Dan muchas
    facilidades para manipular sus propiedades (posición, color y
    textura) aunque no crear nuevos vértices.
-   **Geomtry shaders**: Pueden generar nuevas primitivas gráficas
    (puntos, líneas, triangulos\...). Se ejecutan después de los vertex
    sahders. Toman como input una primitiva. Entre sus usos está el de
    la generación de puntos de sprite, tessellation, volumen y extrusión
    de sombras\... Un ejemplo sería el de la modificación de una malla
    compleja, se pueden generar puntos de control para una curva y
    generar líneas extra para aproximarla.
-   **Pixel shaders** (también conocidos como **fragment shaders**):
    Tratan atributos como el color de cada fragmento. Para simplificar
    el valor de luz, hacer bump mapping, sombras, objetos
    translucidos\... Pueden alterar la profundidad de los fragmentos o
    sacar más de un color si han sido activados múltiples targets de
    render. Aunque no pueden aplicar grandes alteraciones, a su nivel se
    conoce las coordenadas de la pantalla donde donde serán dibujados y
    los pixels vecinos, cosa que permite ejecutar gran variedad de
    efectos de postprocesado 2d (como blur, detección y acentuación de
    bordes\...).

#### Algoritmos de shading

-   <http://en.wikipedia.org/wiki/Illumination_model>

Técnicas de interpolación:

-   Flat shading
-   Gouraud shading
-   Phong shading

Modelos de iluminación (pueden ser combinados con técnicas de
interpolación):

-   Blinn--Phong
-   Cook--Torrance (microfacets)
-   Lambert
-   Minnaert
-   Oren--Nayar (Rough opaque diffuse surfaces)
-   Phong
-   Ward anisotropic
-   Cel shading

#### Lenguajes para programar shaders

-   **GLSL**: Oficial de OpenGL (OpenGL Shading Language).
-   **HLSL**: Oficial de Direct3d (High Level Shading Language).
-   **Cg**: Propio de nVidia.

## Notas

-   <http://es.wikipedia.org/wiki/Coordenadas_homog%C3%A9neas>
