# Armadillo

-   [Página oficial](http://arma.sourceforge.net/)

Librería para realizar operaciones matemáticas como en MATLAB o R desde
C++.\
Para utilizarla, estando bien instalada, únicamente has de incluir la
librería `armadillo`.

``` cpp
#include <iostream>
#include <armadillo>

using namespace std;
using namespace arma;

int main(int argc, char** argv) {
  mat A = randu<mat>(4,5);
  mat B = randu<mat>(4,5);
  
  cout << A*B.t() << endl;
  
  return 0;
}
```

## Uso

Todas estas funciones están en el namespace `arma`, accesible a partir
de hacer un include de la librería:

``` cpp
#include <armadillo>
```

### Uso básico

-   `mat A = randu<mat>(4,5);`, matriz de 5 columnas y 4 filas con
    valores aleatorios.
-   `A(0,1);`, acceso a la primera fila, segunda columna de A.
-   `A*B`, multiplicación de matrices.
-   `A.t()`, traspuesta de A.
-   `A.n_rows` o `A.n_cols`, devuelven el número de filas y columnas
    respectivamente.
-   `A.col(k)` o `A.row(j)`, devuelven la columna k y la fila j
    respectivamente.
-   `A.cols(p, q)` o `A.rows(p, q)`, devuelven un rango de filas o de
    columnas.
-   Para la creación de matrices:
    -   `A.zeros()` o `A = zeros<mat>(k,k)`, matriz llena de ceros.
    -   `A.ones()` o `A = ones<mat>(k,k)`, matriz llena de unos.
    -   `A.eye()` o `A = eye<mat>(k,k)`, matriz con diagonal a uno.
-   Para concatenar matrices:
    -   `X = join_rows(A,B)`, concatena filas.
    -   `X = join_cols(A,B)`, concatena columnas.
-   Para crear una matriz manualmente:
    `A << 1 << 2 << endr << 3 << 4 << endr;`
-   Puedes guardar y cargar una matriz en ASCII con
    `A.save("A.dat", raw_ascii);` y `A.load("A.dat", raw_ascii);`.

### Tipos

#### Vectores

Se utiliza la clase `vec`.\
Podemos indicar el tipo concreto (si vector columna o fila) con `colvec`
o `rowvec`.

-   El siguiente ejemplo crea un vector columna a partir de un array de
    doubles (vertices) de tres elementos:

``` cpp
vec cv = vec(vertices, 3);
cout << cv << endl;
```

-   `P.fill(3)`, substituye todos los valores de P con 3.
