# ImageMagick

## Magick Library (C++)

-   Para utilizarlo deberemos instalar el paquete `libmagick++` y, al
    compilar con g++, agregaremos los siguientes parámetros:
    `-I/usr/include/ImageMagick/ -lMagick++`
-   Documentación
    <http://www.imagemagick.org/Magick++/Documentation.html>.

### Ejemplos básicos

#### Crop de imágen y visualización

``` cpp
#include <Magick++.h> 
#include <iostream> 
using namespace std; 
using namespace Magick; 
int main(int argc,char **argv) { 
  Image image;
  image.read( "girl.gif" );
  image.crop( Geometry(100,100, 100, 100) );
  image.write( "x.gif" ); 
  image.display();
  return 0; 
}
```

#### Edición de imágen creada dinámicamente

``` cpp
Image image(Geometry(f->s.width, f->s.height), "black");
...
for (x, y) if (f->blobs[y][x] == nBlob) image.pixelColor(x, y, "white");
...
image.write("test.png");
```

#### Dibujar sobre la imagen

Se utilizan los objetos `Drawable`.

``` cpp
Image image( Geometry(300,200), Color("white") );

image.strokeColor("red"); // Outline color
image.fillColor("green"); // Fill color
image.strokeWidth(5);

image.draw( DrawableCircle(100,100, 50,100) );
image.draw( DrawableRectangle(200,200, 270,170) );
image.display( );
```

#### Dibujo de polígonos

``` cpp
img->strokeColor("blue");
img->strokeWidth(3);
img->fillColor(rgb);

list<Coordinate> coords;
for (int j=0; j<p.nvertices; j++)
    coords.push_back(Coordinate(p.vertices[j].x, p.vertices[j].y));
img->draw(DrawablePolygon(coords));
```

#### Escoger color RGB

``` cpp
char rgb[20];
sprintf(rgb,"rgb(%d,%d,%d)",colors[orient][0], colors[orient][1], colors[orient][2]);
img->fillColor(rgb);
```

#### Recoger valores RGB

``` cpp
mat matrix(img.rows()*img.columns(), 3);
Pixels view(img);
PixelPacket *pixels = view.get(0,0,img.columns(), img.rows());
PixelPacket *pixel;
int idx = 0;
ColorRGB rgb;
for (unsigned int row = 0; row < img.rows(); ++row) {
  for (unsigned int column = 0; column < img.columns(); ++column ) {
    pixel = pixels+row*img.columns()+column;
    rgb = ColorRGB(*pixel);
    matrix(idx, 0) = (pixel->red*255)/MaxRGB;
    matrix(idx, 1) = (pixel->green*255)/MaxRGB;
    matrix(idx, 2) = (pixel->blue*255)/MaxRGB;
    idx++;
  }
}
```

### Notas

#### Crear una textura para OpenGL

``` cpp
Image img;
img.read("mario.jpg");
img.write(&blob, "RGBA", 8);
glGenTextures (1, &texture);
glBindTexture (GL_TEXTURE_2D, texture);
glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_MAG_FILTER, GL_LINEAR);
glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_MIN_FILTER, GL_LINEAR);
gluBuild2DMipmaps(GL_TEXTURE_2D, 4, img.columns(), img.rows(), GL_RGBA, GL_UNSIGNED_BYTE, blob.data());
```
