# Behave

In Behave the user story is called Feature, it contains scenarios which
are executed by steps. Steps are tests placed into a \"steps\" folder
inside the working directory. Those tests are writen in a python script
file (.py), whereas features are writen in a .feature file. We associate
steps with features using \"given\", \"when\", and \"then\" clauses and
decorators. There also are \"and\" and \"but\" clauses and decorators,
however they shadow their previous step. It means, for instance, an
"and" following a "given" will become a "given" internally and use a
"give" decorated step.

From the tutorial example we can observe it:

    Feature: showing off behave
    Scenario: run a simple test
    Given we have behave installed
    when we implement a test
    then behave will test it for us!

This is the tutorial.feature file which contains the user story (aka
feature). The steps/tutorial.py file contains:

``` python
from behave import *

@given('we have behave installed')
def step_impl(context):
    pass

@when('we implement a test')
def step_impl(context):
    assert True is not False

@then('behave will test it for us!')
def step_impl(context):
    assert context.failed is False
```

As you can see, step clauses match with function decorators. Function
steps receive a context argument, this corresponds to the data that
Behave shares. Now, to run tests it\'s only required to execute Behave
in the working directory:

    $ behave

Although Behave works fine using default configuration, in
<http://pythonhosted.org/behave/behave.html> you can find how to apply
an advance configuration or execute it with other arguments.

There also is a Django app test examble in:
<http://pythonhosted.org/behave/django.html>

## Install

    $ pip install behave

## Using Behave

### What can you do in feature files?

#### You can execute steps for each case in a defined table

Next example will run the tests for \"red fox - animal\", \"firefox -
navigator\", and \"chrome - navigator\":

    Scenario Outline: Blenders
       Given I installed <thing> in my computer,
        when I execute <thing>
        then I realize it is a <result>

     Examples: Living things
       | name          | result        |
       | firefox       | animal        |
       | firefox       | navigator     |

     Examples: Other things
       | name          | result        |
       | chrome        | navigator     |

#### You can pass text to the step

It can be accessed into the context.text property:

    Scenario: some scenario
    Given a sample text loaded into the frobulator
     """
     Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do
     eiusmod tempor incididunt ut labore et dolore magna aliqua.
     """
    When we activate the frobulator
    Then we will find it similar to English

#### You can pass a table to the step

It can be accessed into the context.table property, it\'s a dictionary
of its rows which colum names are the keys:

    Scenario: some scenario
      Given a set of specific users
         | name      | department  |
         | Barry     | Beer Cans   |
         | Pudey     | Silly Walks |
         | Two-Lumps | Silly Walks |

     When we count the number of people in each department
     Then we will find two people in "Silly Walks"
      But we will find one person in "Beer Cans"

### What can you do inside steps code?

#### You can receive parameters

Defining a text pattern into the step decorator you can access to a
variable value:

    Scenario: look up a book
    Given I search for a valid book
    Then the result page will include "success"

    Scenario: look up an invalid book
    Given I search for a invalid book
    Then the result page will include "failure"

``` python
@then('the result page will include "{text}"')
def step_impl(context, text):
   if text not in context.response:
       fail('%r not in %r' % (message, context.response))
```

There are other options to define the pattern in an advanced way:
<http://pythonhosted.org/behave/tutorial.html#step-parameters>

#### You can run code at some point of the execution

There are several predefined functions that you can code to execute
rutines, for example, before an step, after all the steps, etc. You can
see them in
<http://pythonhosted.org/behave/tutorial.html#environmental-controls>

Links

<http://pythonhosted.org/behave/>
<http://jenisys.github.io/behave.example/>
<http://pythonhosted.org/behave/api.html>
