# Android (new)

## Beginning

### Instalation

### Applications

There are several classes inside the SDK which are useful to develop
Android applications\...

-   **Activity**: Is the main class to develop user interaction. Usually
    they implement are focused on a single action.
-   **Services**: They run in the background while other applications
    are also running. They can perform long running actions or support
    interaction with other processes.
-   **Broadcast Receiver**: Are subscribers\\listeners to events (like
    the SMS reception\...).
-   **Content Provider**: Are sub-applications to exchange data between
    applications. They use a database style interface.

#### Activities

An application at least has an activity. Activity initialization is in
`onCreate()` method, there you\'ll:

1.  Restore an application saved state.
2.  Set the content view.
3.  Initialize UI elements.
4.  Link UI elements to code actions.

First line of `onCreate()` method has to be `super.onCreate`.\
To access another activity we\'ll use `findViewById` method.\
To start an activity programatically\...

1.  You\'ll need to create an Intent object that specifies which
    Activity is gonna start.
2.  You\'ll pass this Intent to the methods `startActivity` or
    `startActivityForResult`.

#### Create Activity

``` java
Button launchActivityTwoButton = (Button) findViewById(R.id.bLaunchActivityTwo); 
launchActivityTwoButton.setOnClickListener(new OnClickListener() {
    @Override
    public void onClick(View v) {
        Intent activity2 = new Intent(ActivityOne.this, ActivityTwo.class); 
        startActivity(activity2);
    }
});
```

#### Finish Activity

``` java
Button closeButton = (Button) findViewById(R.id.bClose); 
closeButton.setOnClickListener(new OnClickListener() {
    @Override
    public void onClick(View v) {
        ActivityTwo.this.finish();
    }
});
```

#### Recover the activity status

When an Activity is finished it can be restored using a Bundle object,
it stores key-value pairs. To save additional data about the activity
state, you must override the onSaveInstanceState() callback method. Then
the system will pass the same Bundle object to both the
onRestoreInstanceState() and onCreate() methods.

``` java
static final String STATE_SCORE = "playerScore";
static final String STATE_LEVEL = "playerLevel";
...
@Override
public void onSaveInstanceState(Bundle savedInstanceState) {
    savedInstanceState.putInt(STATE_SCORE, mCurrentScore);
    savedInstanceState.putInt(STATE_LEVEL, mCurrentLevel);
    super.onSaveInstanceState(savedInstanceState);
}
```

``` java
protected void onCreate(Bundle savedInstanceState) {
    super.onCreate(savedInstanceState); // Always call the superclass first
    if (savedInstanceState != null) {
        mCurrentScore = savedInstanceState.getInt(STATE_SCORE);
        mCurrentLevel = savedInstanceState.getInt(STATE_LEVEL);
    } else {
        // Probably initialize members with default values for a new instance
    }
```

You may choose to implement onRestoreInstanceState(), which the system
calls after the onStart() method. The system calls
onRestoreInstanceState() only if there is a saved state to restore, so
you do not need to check whether the Bundle is null:

``` java
public void onRestoreInstanceState(Bundle savedInstanceState) {
    // Always call the superclass so it can restore the view hierarchy
    super.onRestoreInstanceState(savedInstanceState);
   
    // Restore state members from saved instance
    mCurrentScore = savedInstanceState.getInt(STATE_SCORE);
    mCurrentLevel = savedInstanceState.getInt(STATE_LEVEL);
}
```

### Activity lifecicle

![](/fw/android/az0jw.png){.align-center width="300"} The activity will
be activated between the `onStart` and the `onStop` steps.\
The activity will be visible in the foreground between the `onResume`
and the `onPause` steps.\
`onRestart` is called when the activity has been stoped and is about to
be called again.\
`onResume` happens when the activity is about to start interacting with
the user.

#### Tasks

A task is a set of related Activities, they don\'t have to be part of
the same application. A task could be the contacts screen, which can be
called from single activities.

#### Configuration changes

Detection of configuration changes like change the mobile orientation
from portrait to landscape.

### Resources

#### R class

`R` class is an authomaticly generated class to access resources from
code. Accessing resources from code:

-   To access layouts: `R.layout.layout_name`

#### Strings

Strings are stored in `res/values/*.xml` file, can store visual styles
as well as text, and there are three types:

1.  Current strings
2.  String array
3.  Plurals: Plural values for single strings.

A string definition is:

``` xml
<string name="hello">Hello world!</string>
```

To access them from other resources we will do:

    @string/string_name

#### Layout files

The UI for applications in xml format. They are stored in
`res/layout/*.xml` files. To access them from other resources we will
do:

    @layout/layout_name

### Controls

You can have a TextView in your layout and want to access it by code\...

``` java
protected void onCreate(Bundle savedInstanceState) {
  super.onCreate(savedInstanceState);
  setContentView(R.layout.activity_one);
  mTvCreate = (TextView)findViewById(R.id.create);
  ...
```

### AndroidManifest.xml

It\'s a file that defines the developed application. It includes\...

-   Application name
-   Which components are included in this application.
-   Permissons.
-   Minimum API required.

## Tools

### LogCat

It\'s the Android main logs viewer. To use it you only need to import
the `android.util.Log` class and call it:

-   `Log.i(ID, MSG)`, produces an INFO message.
-   `Log.d(ID, MSG)`, produces a DEBUG message.
-   `Log.e(ID, MSG)`, produces an ERROR message.
-   `Log.v(ID, MSG)`, produces a VERBOSE message.

### Communication with the emulator

Url for the device is localhost accessed with the port specified on the
window title of the emulator.

To access from other emulator, this number will act as the phone number
(p.ex. to send SMS).

If the number on the window title was 5554, then the command to connect
by telnet to the emulator would be:

    $ telnet 127.0.0.1 5554

I could emulate an SMS from 5556 number using the command:

    sms send 5556 "hi!"

Other commands to configure the emulator could be:

-   `network speed edge`
-   `network speed full`
-   `power status not-charging`
-   `geo fix 0.00 0.40`

### DDMS

It\'s accessed from Eclipse as another perspective. It has several
sub-applications which could be useful\...

-   **Dumb view hierarchy to UI auotomator**. It obtains the UI
    structure from the currently loaded program.
-   **Heap view**. Where you can monitor the used resources from an
    application.
    -   Update heap button will let you view the current heap
        consumption.
    -   In heap tab, cause gc button will let you view more details
        about created objects.
    -   Start and stop method profiling buttons will show more detailed
        views about inner methods inside the code.

## Notes

### Other capabilities

#### Multilanguage applications

You only need to add another resource folder which name ends with the
country code target. P.ex, for spanish it would be: `values-es`.
