# Electrónica básica

## Conceptos

### Básicos

-   **Tipos de variable**
    -   Analógica: Pueden tomar un número infinito entre sus dos
        límites.
    -   Digital: También llamadas discreatas, generalmente son binarias
        (tomando únicamente los valores V o F).
-   **Tensión**: Es lo que pone en movimiento los electrones en un
    conductor, la unidad por la que se mide es el voltio (V). Existen
    dos tipos de tensión:
    -   Continua (VDC): Tiene la polaridad definida (pilas, baterías,
        fuentes de alimentación\...).
    -   Alterna (VAC): Aquella cuya polaridad va cambiando o alternando
        con el transcurso del tiempo (generadores, redes de energía
        doméstica\...).
-   **Corriente**: También denominada intensidad, es el flujo de
    electrones en un sentido. Su unidad de medida es el amperio (A).
    Puede ser continua o alterna depnediendo del tipo de tensión para
    generar los flujos.
-   **Resistencia**: Propiedad de un material a oponerse a un flujo de
    corriente, la unidad por la que se mide es el Ohmio (Ω).
-   **Impedáncida**
-   **TTL**: *Transistor-Transistor logic*, es decir, \"lógica
    transistor a transistor\". Una tecnología de construcción de
    circuitos electrónicos en la que los elementos de entrada y salida
    del dispositivo son transistores bipolares.

### Complejos

#### Pines

Son la forma física con la que el controlador puede comunicarse con los
componentes. Los pines digitales tienen dos valores, el alto y bajo
(*high and low*), el alto significa 5v y el bajo 0v. También existen los
pins analógicos, pueden contener un rango de información mayor (de 0 a
255).

#### PWM

De *Pulse-Width Modulation* o modulación por ancho de pulsos (MAP) es la
técnica para una señal o fuente de energía en la que se modifica una
señal, ya sea para transmitir información o para controlar la cantidad
de energía, que se envía.

#### Resistencia pull-up

Son resistencias que se conectan, generalmente, entre la señal lógica y
el dispositivo, su función es evitar que una señal no quede en estado
flotante, por ejemplo, que su valor lógico no quede en un valor entre el
1 y el 0 que confunda su estado. Realmente son resistencias normales
pero que reciben este nombre debido a la función que cumplen.

### Componentes

#### Básicos

-   **Altavoz**: Reproducción de sonido.
-   **Cable**: Conducción de la electricidad.
-   **Conmutador**: Reencaminar una entrada a una salida elegida entre
    dos o más.
-   **Interruptor**: Apertura o cierre de circuitos, manualmente.
-   **Pila**: Generador de energía eléctrica.
-   **Transductor**: Transformación de una magnitud física en una
    eléctrica.
-   **Visualizador**: Muestra de datos o imágenes.

#### Dispositivos análogos

  ------------------------- -- -----------------------------------------------------------------
  Aplificador operacional      Amplificación, regulación, conversión de señal, conmutación.
  Capacitor                    Almacenamiento de energía, filtrado, adaptación impedancias.
  Diodo                        Rectificación de señales, regulación, multiplicador de tensión.
  Diodo Zener                  Regulación de tensiones.
  Inductor                     Adaptación de impedancias.
  Potenciómetro                variación de la corriente eléctrica o la tensión.
  Relé                         Apertura o cierre de circuitos mediante señales de control.
  ------------------------- -- -----------------------------------------------------------------

-   **Resistencia** (*resistor*): División de intensidad o tensión,
    limitación de intensidad.
-   **Transistor**: Dispositivo de 3 patillas con los siguientes
    nombres: base (B), colector (C) y emisor (E), coincidiendo siempre,
    el emisor, con la patilla que tiene la flecha en el gráfico de
    transistor.
-   **Transistor Bipolar**: Amplificador de corriente, esto quiere decir
    que si le introducimos una cantidad de corriente por una de sus
    patillas (base), el entregará por otra (emisor), una cantidad mayor
    a ésta, en un factor que se llama amplificación.

#### Dispositivos digitales

  ------------------ -- --------------------------------------
  Biestable             Control de sistemas secuenciales.
  Memoria               Almacenamiento digital de datos.
  Microcontrolador      Control de sistemas digitales.
  Puerta lógica         Control de sistemas combinacionales.
  ------------------ -- --------------------------------------

#### Dispositivos de potencia

  --------------- -- --------------------------------------------------------------------
  DIAC               Control de potencia.
  Fusible            Protección contra sobre-intensidades.
  Tiristor           Control de potencia.
  Transformador      Elevar o disminuir tensiones, intensidades, e impedancia aparente.
  Triac              Control de potencia.
  Varistor           Protección contra sobre-tensiones.
  --------------- -- --------------------------------------------------------------------

### Simbología

![](/electr/simbolos.png)

## Microcontroladores

### Conceptos

-   **ICSP** (*In Circuit Serial Programming*): Es el método por el cual
    podemos programar directamente los microcontroladores AVR y PIC.

### Microcontroladores AVR

## Otros

### Protoboard

O *breadboard*, o *placa de pruebas*\...\
El esquema de conexión es el siguiente:\
![](/electr/breadboard-144dpi.gif){.align-center}

### Leer una resistencia

![](/electr/resistorcolorcodes.jpg)
