# Web Services REST

La arquitectura REST (*Representational State Transfer*) es un estilo de
distribución de datos mediante la web aprovechando el protocolo HTTP
(métodos, URIs, Media Types, codigos de respuesta y petición\...).
Básicamente consiste en clientes que realizan peticiones a servidores,
estos las procesan y retornan la respuesta adecuada.\
Tanto las peticiones como las respuestas intentan \"representar
recursos\" (de ahí su nombre), entendiendo un recurso como \"contenido\"
que puede ser accedido a partir de una dirección.\
En cualquier momento la aplicación cliente entrará en una transición de
\"estados de aplicación\" (transición entre las distintas acciones que
realiza una aplicación), se dice que si la aplicación entra en un estado
\"de descanso\" (*at rest*) el usuario podrá interactuar con ella pero
esta no cargará ni consumirá datos. La aplicación cliente enviará
peticiones cuando esté preparada para una nueva transición.\
Un servicio REST asegura rendimiento, escalabilidad, simplicidad,
modificabilidad, visibilidad portabilidad y confiabilidad.

## Básico

### Servicios RESTful

Las reglas a seguir en una arquitectura de estilo REST son las
siguientes, si se siguen todas (excepto \'código *on demand*\') el
servicio podrá ser denominado RESTful:

1.  **Cliente - Servidor**: La interface de cliente está separada del
    servidor, esto significa que no pueden acceder directamente a los
    datos si no es a partir del mismo servidor. Por otra parte tanto el
    cliente como el servidor son independientes y han de ser
    desarrollados por separado.
2.  **Sin estados**: Las peticiones del cliente se harán de una en una y
    no por partes, cada una de estas contendrán toda la información
    necesaria para realizarla. Las peticiones se harán a partir de una
    URL.
3.  **Cacheable**: Los clientes han de ser capaz de guardar en caché las
    respuestas del servidor.
4.  **Sistema por capas**: Pueden existir servidores intermedios que
    mejoren la escalabilidad del sistema permitiendo el balanceo de
    carga y compartir cachés.
5.  **Código *on demand*** (opcional): El servidor puede ser capaz de
    transferir código al cliente para ser ejecutado en él (como por
    ejemplo JavaScript).
6.  **Interface uniforme**: Esto simplifica y desacopla la arquitectura,
    lo que permite a cada parte evolucionar independientemente. En una
    interface uniforme\...
    -   Los recursos han de estar identificados en las peticiones. Esto
        significa que el servidor enviará los datos correctamente
        identificados en el formato que sea (HTML, XML, JSON\...) y
        estos pueden ser una porción de la DB.
    -   Los recursos pueden ser manipulados. Esto significa que si el
        cliente tiene suficiente información del recurso y a la vez
        tiene suficientes permisos podrá realizar sobre este acciones de
        modificación, de borrado\...
    -   Mensajes autodescriptivos. Cada mensaje ha de incluir suficiente
        información para que este pueda ser procesado.
    -   Los recursos han de ser reconocidos por métodos de hypermedia
        (como por ejemplo URIs).

### Formato

De forma distinta a los web services basados en SOAP no existe un
standard oficial (a parte de las reglas ya nombradas) para que un
servicio sea RESTful, esto es porque REST es una arquitectura y SOAP un
protocolo. Se definen tres aspectos para un servicio REST común:

-   La URI base del web service, como por ejemplo:
    `http://example.com/resources/`
-   El tipo de dato devuelto (MIME type). JSON, XML, YAML\...
-   Las operaciones soportadas usando los método HTTP (por ejemplo PUT,
    GET, POST o DELETE).

Ejemplo:

  URI                                              Método GET                       Método PUT                                 Método POST                    Método DELETE
  ------------------------------------------------ -------------------------------- ------------------------------------------ ------------------------------ ---------------------------------
  [http://example.com/resources/]{.underline}      Lista todos los miembros.        Reemplaza la lista de miembros por otra.   Añade un miembro a la lista.   Elimina la colección.
  [http://example.com/resources/142]{.underline}   Recoge el elemento con id 142.   Actualiza el elemento con id 142.                                         Elimina el elemento con id 142.

Mientras que en otro tipo de web services se pone énfasis en los verbos
(`getUser(data)`, `updateUser(data)`\...) en REST se pone énfasis en los
nombres (`User {data}`). Un recurso tendría su propio identificador,
como por ejemplo
[http://www.example.org/locations/us/ny/new_york_city]{.underline}
donde, si se accede a partir del método GET, podrían haber los datos de
la ciudad de New York, además puede ser sencillamente cacheado, copiado
y guardado como marcador.

## Interface uniforme

El protocolo HTTP es un protocolo cliente-servidor que se implementa a
nivel de aplicación y define operaciones sobre los recursos del servidor
(como GET, POST, PUT y DELETE), esto evita al desarrollador que lo
utilice incorrectamente (es decir que siga la regla de
`Interface Uniforme`) tener que inventar nuevos métodos (como
`getClients` o `updateStops`).

### Visibilidad

### Uso de métodos HTTP

## Seguridad en REST

## Desarrollo erróneo

### Errores comunes

-   **Fuente**: <http://www.prescod.net/rest/mistakes/>

Los errores que se llevan a cabo en el desarrollo de servicios REST son:

1.  No seguir los estándards HTTP.
2.  Utilizar POST para otros fines que no sea la creación de un nuevo
    elemento.
3.  Depender de la estructura del servidor. Las URIs deberían ser
    configurables.
4.  Utilizar acciones en las URIs. Por ejemplo \"someuri?action=delete\"
    es erróneo.
5.  Usar sesiones. Las aplicaciones son consumidores de recursos, no
    servicios.
6.  No utilizar las URIs correctamente. Para acceder a un recurso
    haríamos \"someuri/resource/322\" o utilizaríamos RDF.
7.  Preocuparse por el protocolo.

### AntiPatrones REST

-   **Fuente**: <http://www.infoq.com/articles/rest-anti-patterns>

#### Utilizar con exceso GET

GET debe de traer la representación de un recurso identificado por una
URI.\
Una URI como la siguiente sería incorrecta:
`http://example.com/some-api?method=deleteCustomer&id=1234`, es posible
que sea más fácil de desarrollar y testear, pero en este caso no se está
utilizando la URI como un identificador, además el link no puede ser
guardado, puede que un robot de búsqueda lo ejecute sin querer\...\
Un GET no debe modificar.

#### Utilizar con exceso POST

Similar al anterior solo que con el método POST.\
GET es para leer, POST para modificar.

#### Ignorar la caché

Utilizar una cabecera como `Cache-control: no-cache` evitaría que el
navegador insertase en su caché el contenido. A veces esto puede ser
útil pero a menudo se le puede sacar partido a la caché del cliente, por
ejemplo si un recurso se actualiza cada 30 minutos se puede evitar las
peticiones en peridos más cortos.

#### Ignorar códigos

HTTP tiene una serie de códigos internos para lidiar con distintos casos
(200: todo ha ido corretamtente, 404: no se encontró el recurso, 500:
hubo un error interno\...) y que si se utilizan son una herramienta más
que correcta para la comunicación cliente-servidor.\
Por ejemplo el 201 para cuando se ha creado un recurso, el 409 cuando ha
habido un conflicto (por ejemplo de versiones de un recursos), el 412
para indicar que no se reconoce al cliente.

#### Usar incorrectamente las cookies

De la misma forma que las sesiones, el uso de cookies para mantener una
conversación con el server; sí que podrían ser usadas para, por ejemplo,
guardar un token de autentificación (aunque es preferible utilizar la
autentificación HTTP).

#### Olvidar la hypermedia

El concepto de hypermedia corresponde al hecho de linkar elementos entre
ellos. Olvidar la hypermedia es no agregar links en las representaciones
de los recursos, es importante que los subrecursos sean devueltos como
links.

#### Ignorar los MIME types

Puede que un recurso sea devuelto en distintos formatos (XML, JSON,
YAML, PDF\...), la forma adecuada de devolverlo al cliente es mediante
el uso correcto de MIME-TYPES.

#### Romper la auto descripción

Básicamente es seguir los estándards REST.

## Notas
