# GIT (old)

## Básico

### Vocabulario y keywords

-   **Index**: Índice de cambios que se han realizado entre un commit y
    otro en un proyecto o working tree.
-   **HEAD**: Keyword para la última versión.

### Trabajo con GIT en local

#### Crear repositorio

El repositorio (o working tree) se creará en el directorio donde se
llame al siguiente comando:

    $ git init

Una vez se tiene el repositorio se han de agregar elementos.

#### Agregar elementos al working tree

Para añadir un elemento haremos:

    $ git add file.txt
    $ git add directory

La acción de agregar se realiza recursivamente, por lo que si añadimos
un directorio al working tree se añadirán también sus subdirectorios y
ficheros.

#### Modificar elementos

Con el mismo parámetro `add` agregamos un cambio.\
Por ejemplo, si hemos modificado *file.txt* que ya estaba en el
repositorio:

    $ git add file.txt

#### Mover elementos a otros directorios

    $ git mv file.txt directory

### Multiples repositorios

#### Clonar repositorio

    $ git clone repo cloned_repo

#### Ver información sobre el repositorio del que viene

Ver nombre del repositorio que viene.

    $ git remote

Ver información de un repositorio remoto.

    $ git remote show repo_name

#### Subir cambios a un repositorio remoto

    $ git fetch

Esto sube los cambio pero no los actualiza, para ello debemos hacer:

    $ git fetch
    $ git merge origin/master

O, en un único comando:

    $ git pull

## Funcionamiento

### Gestión de commits

Cada vez que se realiza un commit la versión actual apunta a la anterior
y, en cascada, se van almacenando los cambios en el proyecto.

#### Revertir al último commit

Sin haber realizado ningún cambio (`add`):

    $ git checkout somefile.txt

Habiendo realizado algún cambio (sólo un fichero):

    $ git reset HEAD somefile.txt

Habiendo realizado algún cambio (todo el proyecto):

    $ git reset HEAD

#### Revertir a un commit concreto

Esto crearía un segundo commit idéntico al escogido pero posterior al
actual.

    $ git revert 068b9b9

### Visión de cambios

#### Ver historial de cambios

Historial largo:

    $ git log

Historial corto:

    $ git log --pretty=oneline --abbrev-commit

Historial completo:

    $ git log -p

Formatear el historial:

    $ git log --all --pretty=format:"%h %cd %s (%an)" --since='7 days ago'
    $ git log --pretty=format:"%h %ad | %s%d [%an]" --graph --date=short

#### Ver últimos cambios realizados

    $ git status

#### Ver diferencia entre commits

Comparar un commit con su predecesor:

    $ git show 3720b35

Comparar dos commits:

    git diff a2a1eb3..068b9b9

### Configuración

#### Datos de usuario (por proyecto)

    $ git config user.name "John Q. Public"
    $ git config user.email "johnq@example.com"

#### Datos de usuario (globales)

Para todos los proyectos:

    $ git config --global user.name "John Q. Public"
    $ git config --global user.email "johnq@example.com"

#### Salida por consola

Agregar colores (para acciones como `diff`, `status`\...):

    $ git config --global color.ui auto

## Avanzado

### Archivo .gitconfig

En el directorio personal de tu usuario existirá un archivo denominado
.gitconfig, este tendrá tu configuración.

#### Agregar alias

    [alias]
      co = checkout
      ci = commit
      st = status
      br = branch
      hist = log --pretty=format:\"%h %ad | %s%d [%an]\" --graph --date=short
      type = cat-file -t
      dump = cat-file -p

Si los agregramos, al hacer `git co` estaremos haciendo un
`git checkout` (por ejemplo).

### Directorio .git

-   [Explicación](http://gitimmersion.com/lab_22.html)

### Ignorar ficheros

Podemos indicar reglas para ignorar los ficheros de un directorio con el
fichero `.gitignore` del proyecto.\
Podemos hacerlo globalmente con:

    $ git config --global core.excludesfile ~/.gitignore_global

O haciendo que no se añadan al repositorio con desde
`.git/info/exclude`.

#### Repositorio

-   ![Gitignore recomendado para Python](/code/git/python.gitignore.zip)
-   [Repositorio](https://github.com/github/gitignore)

## Cómo\...

#### Ver el último commit?

    $ git hist --max-count=1

#### Impedir el commit

    $ git reset

:!:\... Y dejarlo como estaba.

    $ git reset --hard

### GitHub

-   <https://github.com/>

#### Crear repositorio

#### Descargar repositorio

    $ git clone https://github.com/epintor/Hindoor.git

#### Actualizar el repositorio

Realizar cualquiera de los comandos de modificación:

-   git add
-   git rm
-   git mv

Hacer un commit.

    $ git commit -a

Si (y sólo si) hay cambios en la branch \'master\':

    $ git pull origin master

Subir los cambios (a la branch \'master\'):

    $ git push origin master

## Herramientas

### GUIs

#### Meld

Para ver cambios realizados en un repositorio:

-   [web](http://meld.sourceforge.net/install.html)
-   [artículo](http://www.linux.com/archive/feature/61372)

#### QGit

-   [web](http://digilander.libero.it/mcostalba/)

#### Giggle

Visor para GNOME:

-   [web](http://live.gnome.org/giggle)

### Plugins para IDEs

#### Egit

Plugin para eclipse:

-   [web](http://www.eclipse.org/egit/)
-   [tutorial](http://wiki.eclipse.org/EGit/User_Guide)

### Servidor Gitosis

En Ubuntu existe el paquete `gitosis` que instala un servidor GIT.\

## Notas

### Links

-   Libro de la comunidad de GIT: <http://book.git-scm.com/>
-   Los 10 mejores tutoriales:
    <http://sixrevisions.com/resources/git-tutorials-beginners/>
