# Conceptos

## Conceptos Generales

### Términos

-   **Bytecode**: Código intermedio entre el código máquina y el de de
    programación. Generalmente se tratra como si fuese un fichero
    binario en el que hay un programa ejecutable. Suelen necesitar un
    intérprete (generalmente llamado máquina virtual) y su ventaja es la
    portabilidad a diferentes arquitecturas y plataformas.
-   **JIT** (*Just In Time*): Es como se le llama a la compilación en
    tiempo de ejecución (o también traducción dinámica). Cuando se
    compila en tiempo de ejecución la compilación a bytecode es el
    primer paso, reduciendo el código fuente a una forma portable y
    optimizada, esta acción puede realizarse a un nivel total del
    programa o al de las funciones, es en este último caso que es
    llamado JIT, cuando se compila una función justo a tiempo de ser
    llamada.

### URI

Identificador de dispositivo formado por:

-   Esquema: mecanismo de acceso o protocolo:
    (`urn:, tag:, cid:, http:, mailto:, ftp:...`).
-   Autoridad: nombre que lo identifica (`//es.wikipedia.org`).
-   Ruta: Información en forma jerárquica, que identifica la
    localización dentro de la autoridad
    (`/wiki/Uniform_Resource_Identifier`).
-   Consulta: Información adicional, usualmente en forma de pares
    \"clave=valor\". Su comienzo es marcado por el carácter \'?\'.
-   Fragmento: Permite identificar una parte o vista. Su comienzo está
    marcado por \'#\'.

### Sockets

Un socket es un objeto que engloba el conjunto de elementos: dirección,
puerto y protocolo. Gracias a los sockets puede existir comunicación
entre dos ordenadores diferentes.

#### Protocolos

-   **TCP**: Protocolo que garantiza que los datos han sido entregados
    correctamente (es decir, si no es así ocurre un error en el envio).
    Mediante el cual se utilizan aplicaciones HTTP, SMTP, SSH, FTP\...
-   **UDP**: Protocolo basado en datagramas (paquete independiente, cada
    uno con información del emisor), permite el envio sin necesidad de
    establecer una conexión. No tiene confirmación (ni de entrega ni de
    recepción) ni control de flujo.

### Protocolo HTTP

-   [Documento explicativo del protocolo
    HTTP/1.1](http://tools.ietf.org/html/rfc2616)

#### Métodos

-   **OPTIONS**: Utilizado generalmente para pedir cuales de los demás
    métodos están soportados por el servidor.
-   **GET**: Utilizado para realizar una petición de datos.
-   **HEAD**: Utilizado para realizar una petición de la cabecera de los
    datos.
-   **POST**: Método utilizado para enviar una modificación de datos al
    servidor.
-   **PUT**: Método utilizado para enviar nuevos datos al servidor.
-   **DELETE**: Método utilizado para borrar datos del servidor.
-   **TRACE**: No se utiliza debido a que representa una vulnerabilidad,
    pero permite comprobar la correcta respuesta del servidor.

#### Content-Type

En el header de una respuesta http enviaremos el tipo de datos que
devolvemos. Los más conocidos:

    text/plain                  Texto plano
    text/plain;charset=utf-8            Texto plano con codificación utf-8
    text/html                   Código html
    text/xml                    Código xml
    text/csv                    Código csv
    application/json                Código json
    image/type                  Una imágen, type puede ser: gif, jpeg, png

### Servicios Web

El concepto de servicio web se basa en el intercambio de información
entre aplicaciones mediante HTTP, como si fuese una página web.

#### Protocolos

-   [SOAP](http://en.wikipedia.org/wiki/SOAP_%28protocol%29), protocolo
    de intercambio de datos mediante XML.
-   [RPC](http://es.wikipedia.org/wiki/RPC) que según el formato de
    retorno puede ser [XML-RPC](http://es.wikipedia.org/wiki/XML-RPC)
    para XML, [JSON-RPC](http://en.wikipedia.org/wiki/JSON-RPC) para
    JSON\...
-   [SOAPjr](http://en.wikipedia.org/wiki/SOAPjr) mezcla de SOAP y
    JSON-RPC.

#### Formatos de retorno

Puede retornar cualquier formato, sobretodo si es un servicio web
[REST](/code/rest).

-   [JSON](/tags/json), formato directamente reconocible por JavaScript.
-   [JsonML](http://en.wikipedia.org/wiki/JsonML), mezcla de JSON y XML.

### WSGI

De *Web Server Gateway Interface*, es una definición de métodos que han
de tener los frameworks\\APIs Python para el desarrollo de aplicaciones
web. Esto permite prescindir de módulos de server tales como CGI,
FastCGI o mod_python.

Un server WSGI (WSGI compliant) simplemente recibe una petición del
cliente, la pasa a la aplicación y devuelve la respuesta. Es la
aplicación (o framework), que hace de middleware, la que ha de proveer
de los detalles. Para ello se usa una función de callback en el lado de
aplicación.

Un framework WSGI puede contener componentes que cambien las variables
de entorno según la URL, permitir múltiples aplicaciones, balancear la
carga\...

La interface de la función recibe como parámetros un environ (variables
de entorno) y una función a la que enviar la cabecera de la respuesta.
Luego, el string que devuelva esa función será lo que se devuelva como
respuesta:

``` python
from wsgiref.simple_server import make_server

def hello(environ, start_response):
    start_response('200 OK',[('Content-type','text/plain')])
    return ['Hello world!']
    
httpd = make_server('',8000, hello).serve_forever()
```

El diccionario `environ` contiene:

-   `REQUEST_METHOD`: método \"GET\", \"POST\", tec.
-   `SCRIPT_NAME`: la parte inicial de la \"ruta\", que corresponde a la
    aplicación
-   `PATH_INFO`: la segunda parte de la \"ruta\", determina la
    \"ubicación\" virtual dentro de la aplicación
-   `QUERY_STRING`: la porción de la URL que sigue al \"?\", si existe
-   `CONTENT_TYPE`, `CONTENT_LENGTH` de la petición HTTP
-   `SERVER_NAME`, `SERVER_PORT` que combinadas con SCRIPT_NAME y
    PATH_INFO dan la URL
-   `SERVER_PROTOCOL`: la versión del protocolo (\"HTTP/1.0\" or
    \"HTTP/1.1\")
-   Variables `HTTP_`

## Programación declarativa

El código imperativo describe **cómo** se hace algo, mientras el
declarativo describe **qué** se está haciendo.\
La programación declarativa expresa la lógica sin describir un flujo
(if, bucles\...).\
\

El código siguiente es imperativo:

``` csharp
using System;
class Example
{
    static void Main()
    {
        Int32 sum = 0;
        for (Int32 i = 0; i < 100; i++)
        {
            if (i % 2 == 0)
            {
                sum += i;
            }
        }
        Console.WriteLine(sum);
    }
}
```

Su equivalente declarativo sería:

``` csharp
using System;
using System.Linq;

class Example
{
    static void Main()
    {
        Int32 sum = Enumerable.Range(0, 99)
                      .Where(i => i % 2 == 0)
                      .Sum();
        Console.WriteLine(sum);
    }
}
```

O con un grado declarativo mayor:

``` csharp
using System;
using System.Linq;

class Example
{
    static void Main()
    {
        Int32 sum = Enumerable.Range(0, 99)
                      .Where(isEven)
                      .Sum();
        Console.WriteLine(sum);
    }
    static Boolean isEven(Int32 number)
    {
        return number % 2 == 0;
    }
}
```

## Big-O Notation

Esta notación es una forma de representar la complejidad de una
algoritmo. Esto significa que es una forma de calculo de tiempo (o
proceso) en la que teniendo una cantidad de datos cuánto tiempo\\proceso
costaría si esta cantidad cambia.\
Hay que entender que que los algoritmos se han de comparar con los del
mismo tipo, es decir, un algoritmo que realice operaciones aritméticas
no debería ser comparado con uno que ordene números, en cambio sí que
podrán ser comparados dos que realicen operaciones aritméticas (por
ejemplo uno sumas y otro multiplicaciones).\
Big-O reduce la comparación a una simple variable escogida a partir de
observaciones o casos asumidos.\
Básicamente viene a decirte cuanto tardaría el algoritmo en ordenar un
millón de elementos si tarda un segundo en ordenar 10000.\
\

### Uso

#### Complejidad lineal

Imaginemos algoritmos aritméticos (suma, resta, multiplicación y
división). Por ejemplo la suma, esta consiste básicamente en alinear a
la derecha los dos números a sumar e ir recorriendolos de derecha a
izquierda e ir sumandolos (teniendo en cuenta las unidades que
sobrepasen dos dígitos), si sumamos dos cifras de 6 dígitos cada una
tendremos que hacer seis sumas, si sumamos dos cifras de 100 dígitos
haremos 100 sumas. La complejidad de la operación es directamente
proporcional al número de dígitos, llamamos a esta complejidad lineal y
representada como `O(n)`.

#### Complejidad cuadrática

La multiplicación en cambio es diferente, se van colocando línea a línea
los dígitos del primer número multiplicados por los dígitos del segundo
(para después hacer una suma). Es decir si multiplicamos dos cifras de 6
dígitos haremos 36 multiplicaciones y sobre 10 sumas. Si multiplicamos
números de 100 dígitos tendremos que hacer 10000 multiplicaciones y 200
sumas. Esta complejidad es la llamada complejidad cuadrática y
representada como `O(n²)`.\

Es importante entender que sólo nos preocuparemos de la porción más
significante de la notación. Es decir, en este caso de la multiplicación
podríamos representarlo como `O(n² + 2n)` pero si nos fijamos nos
daremos cuenta que el segundo término (`2n`) es insignificante (el
0,00002% de las operaciones realizadas).

#### Complejidad logarítmica

Pongamos una búsqueda de elementos ordenados como ejemplo. Imaginemos
una lista telefónica ordenada por los nombres, si buscasemos uno, por
ejemplo \"John Smith\", lo que haríamos sería un [Binary
Search](/otros/algoritmos#binary_search) (o búsqueda por bisección),
dividir la lista entre dos y ver en cual de las porciones resultantes
está tal nombre, volverla a dividir y así hasta encontrarlo. De esta
forma se podría encontrar un nombre en una lista de millones con sólo
realizar esta acción 21 veces\...\
Para una lista de 3 nombres nos tomaría 2 comparaciones (como mucho).\
Para una de 7 como máximo 3.\
Para 15, 4.\
Para 1.000.000 nos tomaría 21.\
En Big-O esta sería la complejidad logarítmica, `O(log n)`.

#### Determinar casos

Gracias a la notación Big-O podemos deteminar los siguientes casos, con
este ejemplo:

-   **El mejor caso**, encontrarlo con una única comparación. Esto sería
    la **complejidad constante**, representada por `O(1)`.
-   **El caso esperado**, `O(log n)`.
-   **El peor caso**, también `O(log n)`.

Aunque generalmente será el peor caso en el que estemos interesados.\
Si en cambio buscamos un nombre a partir de un número de teléfono lo que
haremos ir de número en número comprobando hasta encontrar el idéntico.
Por lo que determinaríamos:

-   El mejor caso: `O(1)`.
-   El esperado: `O(n)` (unas 500.000 comparaciones).
-   El peor: `O(n)` (1.000.00\' comparaciones).

#### Complejidad factorial

Partiendo del problema del vendedor, en él tenemos N ciudades cada una
de ellas conectadas con una o más ciudades por carretareras de distinta
longitud y hay que encontrar la forma de visitarlas todas recorriendo el
menor trazo posible. Por ejemplo teniendo las ciudades A, B y C las
carreteras podrían ir:

    A -> B -> C
    A -> C -> B
    B -> C -> A
    B -> A -> C
    C -> A -> B
    C -> B -> A

Realmente hay sólo 3 posibilidades (aunque el proceso debería
diferenciarlas) ya que \"A -\> B -\> C\" y \"C -\> B -\> A\" son
equivalentes (usan las mismas carreteras). Pero con 4 ciudades realmente
hay 12 posibilidades, con 5 hay 60 y con 6 360. Esto es un factorial:

    5! = 5 * 4 * 3 * 2 * 1 = 120
    6! = 6 * 5 * 4 * 3 * 2 * 1 = 720
    7! = 7 * 6 * 5 * 4 * 3 * 2 * 1 = 5040
    ...
    25! = 25 * 24 * ... * 2 * 1 = 15,511,210,043,330,985,984,000,000
    ...
    50! = 50 * 49 * ... * 2 * 1 = 3.04140932... × 10^64 

Por lo que en términos de Big-O el problema del vendedor se representa
como `O(n!)` y se le llama de **complejidad factorial o combinacional**.

## Notas

-   ![Artículo sobre el diseño orientado a
    objetos](/code/how_i_explained_ood.pdf)
