# Unsupervised Machine Learning

## Clustering

Consiste en agrupar individuos en grupos parecidos.

### K-Means

En la nube de puntos que forman los individuos\...

1.  Cogemos K centros de gravedad aleatorios (K corresponde al número de
    grupos), aunque pueden escogerse de otra forma no aleatoria.
2.  Calculamos la distancia entre un punto cualquiera y el centro de
    gravedad y le asignaremos el más cercano.
3.  Definimos una partición a partir de esto y calculamos su centro de
    gravedad (no tienen por qué coincidir con puntos).
4.  Con los nuevos centros volvemos a hacer el paso 2, nos aparece otra
    partición.

#### Fast K-Means

Una variación del K-Means es el Fast K-means, en el paso 2 cada vez que
enlazasemos con un centro de gravedad crearíamos otro nuevo. En una sola
pasada se encuentran las clasificaciones pero son peores.

#### Notas

-   K-Means tiene mejor rendimiento que el clustering jerárquico, pero
    necesita saber la K (el número de grupos). Una metodología que puede
    seguirse es la de hacer la partición jerárquica y, de esta, los
    centros de gravedad que se utilizarían en el k-means inicialmente.

### Clustering jerárquico

Consiste en ir agrupando individuos por cercanía y mostrándolos en un
endograma (una especie de árbol\\histograma).\

1.  Se calcula la matriz de distancias entre los individuos.
2.  Se coge la pareja de nodos más cercano.
3.  Se crea un nuevo nodo entre la pareja encontrada, siendo este la
    agregación de esta pareja que desaparece.
4.  Pasamos al paso 1.

Iremos creando el árbol, siendo la altura de estos nuevos nodos la
distancia (al cuadrado) entre la pareja que los forma.\
En el árbol estará todo el historial de agregaciones.\
Al final tendremos un árbol donde se verá cláramente las clases (y se
podrán escoger) que lo forman. Por ejemplo, en el siguiente podríamos
escoger dos grupos (\[1 3 4\] y \[2 5\]) o tres (\[1 3\], \[4\] y \[2
5\]). ![](/ai/md/dendograma.png){.align-center} Existen varios criterios
para unir nodos:

-   Por distancia mínima.
-   Por media.
-   Por el criterio de ward (inercia).

### Calidad del clustering

-   Se buscará hacer grupos el máximo de homogéneos posibles entre sus
    individuos y lo más diferente posible entre ellos.
-   Una medida para calcular esto es la inercia. Distinguiremos varias
    inercias:
    -   Inercia within: la que hay en los grupos. Suma de inercia de los
        grupos.
    -   Inercia between: la que hay entre los grupos. A partir de los
        centros de gravedad.
    -   Inercia total: La suma de la within y la between.
    -   Ratio de inercia: `Inercia_Between / Inercia_Total`, se buscará
        hacer la inercia between grande y la within pequeña.

### Otros algoritmos de clustering

-   :!: Ver apuntes de TAVA

## Árboles de decisión
