# Machine learning

Algoritmos de clasificación, desarrollo e implementación de estos.

## Aprendizaje

### Tipos de aprendizaje

#### Aprendizaje supervisado

#### Aprendizaje no supervisado

### El proceso

#### Modelo

Un modelo es una expresión simbólica en forma de igualdad o ecuación, es
una estructura que, a partir de parámetros, se utiliza para indicar qué
variables intervienen en la respuesta.

#### Modelo sobreespecializado

Las estimaciones que realiza son siempre iguales a los datos de entrada
iniciales y no predice correctamente los nuevos.

El proceso de aprendizaje consiste en entrenar algoritmos, esto
significa encontrar los parámetros más adecuados para redes neuronales,
SVM\... Lo que se hace es separar los datos que tenemos en datos de
entrenamiento y de aprendizaje (estos deberían ser un tercio o un
cuarto) y lanzar el algoritmo con los de entrenamiento hasta encontrar
los parámetros. Una vez se tienen se probarían con los de test para
asegurarnos que funciona. Si el algoritmo la clava con los de
entrenamiento pero falla mucho con los de test diremos que está
sobreentrenado, que hay *overfitting*.

### Evaluación del resultado

:!: Agregar: <http://en.wikipedia.org/wiki/Accuracy_and_precision>

#### Recall

#### Precision

#### Accuracy

#### F-Measure

#### Confusion matrix

### Cross-Validation

### Tipos de error

## Modelos de Markov

Un modelo de Markov no es más que un modelo en el que una acción ocurre
con probabilidad condicional independiente a las demás; esto permite
calcularla fácilmente.\
En un modelo existen:

-   Estados que se pueden dar.
-   Probabilidades iniciales de los estados, que un estado sea el
    primero.
-   Probabilidades de cambio de un estado a otro.
-   Acciones que se pueden llevar a cabo.
-   Probabilidad de que las acciones se lleven a cabo según el estado.

``` python
estados = ('Lluvioso', 'Soleado')
observaciones = ('caminar', 'comprar', 'limpiar')
probabilidad_inicial = {'Lluvioso': 0.6, 'Soleado': 0.4}
probabilidad_transicion = {
   'Lluvioso' : {'Lluvioso': 0.7, 'Soleado': 0.3},
   'Soleado'  : {'Lluvioso': 0.4, 'Soleado': 0.6},
   }
probabilidad_emision = {
   'Lluvioso' : {'caminar': 0.1, 'comprar': 0.4, 'limpiar': 0.5},
   'Soleado'  : {'caminar': 0.6, 'comprar': 0.3, 'limpiar': 0.1},
   }
```

Los problemas que pueden ser resueltos gracias a las cadenas de Markov
son:

1.  Calcular la probabilidad de que ocurra algo (problema de
    evaluación), se monta el modelo y se calcula las probabilidades a
    partir de la anterior.
2.  Calcular, dando un modelo y un resultado, qué secuencia de estados
    es más probable que haya seguido (problema de decodificación, con
    algoritmo de Viterbi). Se monta el modelo y se van calculando
    probabilidades, se escogerá como resultado la secuencia de estados
    más probables.
3.  Crear un modelo desde 0. Problema de aprendizaje.

Un modelo oculto de Markov es cuando se conoce una salida pero no el
paso por los estados, estos podrían respresentar por ejemplo gestos del
usuario: el sistema recbe unos datos y según estos podría indicar qué
gestos han sido realizados (tipo de problema 2).

### Notas

-   ![Vídeos sobre el montaje del modelo y el cálculo de
    probabilidades](/numbers/statistics/introduction_to_markov_chains.zip).
-   ![Ejemplos de uso de los modelos de
    Markov](/numbers/statistics/ejmarkov.pdf).
-   ![Documento sobre como resolver los distintos
    problemas](/numbers/statistics/hidden-markov-models01.pdf).

## Notas

### Tips & tricks

#### Preparación de los datos

-   Si las clases de las que dispones estuviesen desbalanceadas para el
    entrenamiento, es decir, que hubiesen muchos más elementos de una
    clase que de otra. Un truco para no perder información y que no se
    realice un aprendizage mejor para unas que para otras es duplicar
    aleatoriamente los individuos de las clases con menos para
    igualarlas.
-   Pueden existir problemas, como por ejemplo la identificación de
    carácteres escritos a mano, en la que la información se nos presente
    de una forma difícil de tratar para el aprendizaje (rgb de
    píxels\...) y tengamos que hacer \"feature extraction\" (tratar los
    píxels como una imágen y encontrar nuevas variables como por ejemplo
    número de agujeros, euler number, verticalidad\...) y realizar el
    aprendizaje con estas nuevas características.
