# Image Processing

## Tratamiento de la imágen

### El histograma

-   El histograma es la gráfica que muestra como se distribuye el color
    en una imágen, los colores más oscuros los encontramos a la
    izquierda mientras que los más claros a la derecha.
-   Podemos detectar fácilmente lo contrastada que está una imágen por
    los picos de un histograma, a más picos más contraste. Un histograma
    plano correspondería a una imágen poco contrastada.

![](/ai/cv/histogramas.png){.align-center}\
Estos histogramas corresponden a fotografías, podemos ver que la primera
tiene partes muy oscuras que no se verán bien (muchos píxels a la
izquierda), el segundo corresponde a una imágen \"quemada\" (blancos
extremos) y el tercero a una buena fotografía.

#### Ecualización

Técnica que pretende modificar el histograma para obtener otro de
distribución uniforme, es decir, que cada nivel de gris (en imágen
monocroma) tiene el mismo número de bits.

### Thresholding (o binarización)

Un **threshold**, en castellano: barrera o umbral, es un punto a partir
del cual se realiza una operación concreta. El thresholding consiste en
elegir un punto del histograma a partir del cual realizar un corte y
suprimir un extremo u otro.\
Por ejemplo, el siguiente histograma es fácilmente binarizable:\
![](/ai/cv/hist0.png){.align-center}\
En el histograma se ve claramente donde realizar el thresholding.
Haciendolo quedaría una imágen de blancos y negros fácilmente tratable,
pero no siempre es correcto realizar este **thresholding fijo**. Según
la imágen podemos ir variándolo (**thresholding flotante**), o cambiarlo
a partir de las probabilidades que indica la campana de Gauss (**por
compensación estadística**, o a partir de la media o mediana) o a partir
de una función `f(x,y)` que lo que haría sería aplicar el threshold en
distintas porciones de una imágen en función de un punto concreto (que
podría ser el central).\
\
Las siguientes imágenes muestran una imágen original y los resultados
después de haber aplicado un thresholding fijo. Comprobamos que según el
thresholding aplicado nos puede quedar ruido en una zona u otra de la
imágen:\
![](/ai/cv/hist1.png){.align-center width="900"}

## Filtros

El filtrado de la imágen consiste en aplicar a una imágen inicial una
serie de operaciones a una imágen inicial para obtener una imágen
resultado más adecuada para nuestros propositos, por ejemplo podemos
suavizar la imágen (reducir la variación entre píxeles colindantes),
eliminar ruido, realzar y detectar bordes.

### Operadores matriciales

En los operadores matriciales (los que tratan la imágen como una matriz)
existe la **función de convolución** que es la que se define la
operación que se va a aplicar en un píxel según los píxeles vecinos. Por
ejemplo nos encontramos con el píxel *ij*:\
\
![](/ai/cv/convolucion.png){.align-center}\
Su función de convolución podría ser:\
\
\<m\>I`_ij = I_1 + I_2 + I_3 + I_4 + I_5 + I_6 + I_7 + I_8</m>  Es decir, después de aplicar sobre Iij la función de convolución nos aparecería I''ij. * La matriz no tiene por qué ser 3x3 como la de los ejemplos, puede ser de mayor tamaño. === Filtro pasa bajos === También llamado filtro difuminador, cuando hay un cambio de alta frecuencia lo atenua y, en general, reduce el ruido. Lo hace dando cierta importancia a los píxeles colindantes: <m>I`\_ij
= {1/10}I_1 + {1/10}I_2 + {1/10}I_3 + {1/10}I_4 + {1/10}I_5 +
{1/10}I_6 + {1/10}I_7 + {1/10}I_8 + {2/10}I_ij\</m\>

#### Filtro pasa altos

También llamado **filtro agudizador** ya que atenúa los componentes de
la imagen de baja frecuencia y acentúan los detalles.\
Lo hace, por ejemplo, restando a los píxels diagonales y sumando al
actual.

#### Filtro de mediana

Escoge la mediana (el número central) del valor de los píxels
colindantes.

### Operadores morfológicos

Son los que modifican la forma (el contenido) de la imágen.\
En el siguiente ejemplo tenemos una imágen inicial a la cual aplicamos 4
operadores morfológicos definidos por nosotros (el 4º es un **operador
de intersección** del 2º y del 3º). Estudiamos cual de ellos tenemos que
aplicar para conseguir la imágen objetivo (en este caso el 4º):\
\
![](/ai/cv/oper_morf0.png){.align-center width="400"}

-   **Erosión**: Se denomina erosión cuando eliminamos ciertos píxels
    colindantes si existe el que estamos mirando.
-   **Dilatación**: Al contrario que el anterior, si existe el que
    estamos mirando creamos píxels colindantes.
-   **Expansión**: Si existe el que estamos mirando creamos todos los
    píxels colindantes.
-   **Esqueletización**: Es aplicar erosión pero conservando vértices y
    conectividad. Existe un algoritmo para realizar esta tarea
    denominado Zhang & Suen.

### Filtros de contorno

#### Filtro de degradado

#### Filtro de Laplace

#### Roberts

#### Prewitt

#### Sobel

#### Canny

## Algoritmos

### Transformación de Hough

## Como\...
