# Análisis de datos

## Nociones básicas

### Conceptos

-   **Atributos**, ver variables.
-   **Resultado dicotómico**, dos posibilidades.
-   **Variables** también denominadas atributos.

### Medidas

#### Dispersión

El grado de distanciamiento de un conjunto de valores respecto a su
valor medio.

-   En una distribución la medida de dispersión es la **desviación
    típica o standard**, σ. También suele usarse la **varianza** (la
    desviación típica al cuadrado), σ² , no se tiene en cuenta el signo
    y, a la vez, se acentúan las diferencias.

#### Entropía

Es la medida de desorden o incertidumbre.

#### Inercia

Medida de homogeneidad (o parecido) entre puntos en una nube de puntos.
A menor inercia, menor varianza. A más inercia, más información
esparcida y puntos más separados.

#### Lift

Es la medida de rendimiento de un modelo a la hora de predecir o
clasificar casos.\
Por ejemplo imaginemos que en una población se ha calculado una
predicción de respuesta del 5% (esto es que para un valor X se tiene una
predicción del 5%), pero en un modelo concreto se ha identificado un
subconjunto con una predicción de respuesta del 20%. Ese subconjunto
tendría un lift de 4.0 \<m\>({20%}/{5%})\</m\>.

## Variables

### Tipos de variables

-   **Numéricas**: Corresponden a valores que pueden ser expresados por
    números, ya sean estos enteros, reales, naturales\... Son ordenables
    (número de hijos, edad\...). Podríamos denominarlas
    **cuantitativas** y a la vez **discretas** (cuando toman valores
    enteros) o **continuas** (cuando son intervalos).
-   **Categóricas**: No tienen un orden concreto y corresponden a
    categorías concretas y limitadas (color, actividad en gimnasio,
    signo del zodiaco\...). Una subcategoría de estas serían las
    **binarias** que sólo pueden tomar dos valores.
-   **Intervalos**: Son agrupaciones de valores numéricos (edad que
    podria ir de 0 a 12 años, de 13 a 18 años\...). También podríamos
    llamarlas **cuantitativas continuas**.

### Relación entre variables

Si dos variables están muy relacionadas podríamos decir, poniendo por
ejemplo el estado civil y los compañeros de vivienda, cuantos solteros
viven con los padres, cuantos casados\...

#### Covarianza

Indica qué relación hay entre dos variables:

-   Si `Sxy > 0` hay dependencia directa (positiva), es decir, a grandes
    valores de x corresponden grandes valores de y.
-   Si `Sxy = 0` se interpreta como la no existencia de una relación
    lineal entre las dos variables estudiadas.
-   Si `Sxy < 0` hay dependencia inversa o negativa, es decir, a grandes
    valores de x corresponden pequeños valores de y.

#### Relación lineal entre variables cuantitativas

Para medir la intensidad o grado de dependencia entre dos variables
aleatorias cuantitativas (X e Y) calcularemos el **coeficiente de
correlación** (calcula la relación lineal entre ellas).\
![](/numbers/statistics/coeficiente_correlacion.png)

#### Relación entre variables categóricas y numéricas

Utilizaremos la fórmula de la χ² (y si son numéricas las convertiremos a
estas).

#### Relación de variables continuas

A partir del test de la *F de Fisher*.

### Dependencia entre variables

#### Dependencia entre variables continuas

Buscaremos el *p-valor* a partir de la *t de Student*.

## Representación en distintos espacios

Un espacio es un método de representación de datos; existen los
siguientes espacios:

-   **Espacio euclídeo**: Trabaja a partir de planos y no de rectas.
    Mientras que los demás pueden ser tratados como si estuviesen dentro
    de una esfera el euclídeo equivale a trabajar en un plano de
    n-dimensiones.
-   **Espacio vectorial**: Los elementos de este espacio son vectores
    desde un punto a otro.
-   **Espacio factorial**: Los elementos son denominados factores y
    consiste en la representación de una simplificación de variables más
    complejas sobre un espacio de menos dimensiones para poder
    interpretar relaciones (similitudes\...) entre ellas.

### PCA

También denominado ACP (análisis de componentes principales).

### MCA

También denominado ACM (análisis de componentes multiples).

## Estadística Bayesiana

Es una forma alternativa de calcular probabilidades.

### Estadística clásica

La estadística clásica también es llamada **frecuentista** debido a que
necesita de un gran número de experimentos. En cambio la estadística
bayesiana permite interpretar la probabilidad de un hecho a partir de
unos grados de ignorancia; formando reglas sin tener que realizar un
gran número de pruebas y con un grado de confianza. Además la
estadística clásica no es útil en situaciones donde la prueba no puede
ser repetida (p.ej. el cálculo de la probabilidad del tiempo
mañana\...), se expresa en términos del estilo \"en 8 de 10 casos donde
hemos observado X condiciones esperamos Y\".\
\
`P(A|B)` nos dice la probabilidad de A asumiendo que B es cierta y se
calcula:\
\<m\>P(A\|B) = {P(A inter B)} / {P(B)}\</m\>\
`P(A∩B)` es la probabilidad conjunta (*joint probability*) de encontrar
A y B.\
Un ejemplo: sabemos que el 10% de los hombres son daltónicos y que menos
de el 1% de las mujeres son daltónicas, por lo que tenemos lo siguiente:

-   `P(daltónico|hombre) = 0.1`
-   `P(daltónico|mujer) = 0.01`

Si aleatóriamente escogemos una persona en la calle, cual es la
probabilidad de que dicha persona sea daltónica y hombre? (ya
necesitamos la probabilidad conjunta) Tenemos que la probabilidad de que
sea hombre es el 50%, de que sea daltónico y hombre el 10% si dicha
persona es realmente hombre por lo que la probabilidad sería del 5% (0.5
\* 0.1 = 0.05).

### Bayes

Partiendo del teorema de Bayes que es:\
\<m\>P(A\|B) = {P(B\|A)P(A)} / {P(B)}\</m\>\
Si queremos determinar un parámetro a través de un experimento con Bayes
miraríamos:

1.  B: Ocurrencia del experimento en las observaciones.
2.  A: El parámetro cogiendo el valor `x`.

Podríamos mirarlo sin denominador, este, al fin y al cabo, es una
constante y no depende del parámetro que deseamos determinar:\
\
\<m\>P(param\|data) = P(data\|param)P(param)\</m\>\

-   `P(data|param)` es denominada la función `likelyhood`. Esta enlaza
    el parámetro con la probabilidad de obtener un dato específico.
    Representaría el modelo ya que dice qué dato podemos esperar tras
    observar un valor específico para el parámetro.
-   `P(param|data)` es la probabilidad `posterior`, la de encontrar un
    valor concreto para el parámetro dando los datos. Es una medida de
    nuestra creencia\\certeza con respecto a la salida.
-   `P(param)` es la probabilidad `previa` o `prior`, es la creencia
    previa al experimento de encontrar ese valor concreto para el
    parámetro. Es subjetiva y mientras mayor sea la cantidad de datos su
    influencia será más pequeña.

#### Un ejemplo\...

Un experimento sería lanzar una moneda 10 veces. Imaginemos que
obtenemos 7 caras (H) y 3 cruces (T): THHHHTTHHH\
Queremos saber si la moneda es fiable o no. Para ello debemos calcular
la probabilidad (*p*) de H (por ejemplo) el cual sería el parámetro. Si
la moneda es fiable *p* sería 1/2. Neceistamos una likelyhood que podría
ser:

-   `P(H|p) = p` -\> Probabilidad de sacar una H.
-   `P(T|p) = 1-p` -\> Probabilidad de sacar una T.

Escogeremos nuestra probabilidad preivia como `P(p) = 1` para toda *p*.\
En este problema el número de T y de H es lo importante, no el orden de
estas por lo que no necesitamos calcular combinaciones ni
permutaciones.\
Tenemos pues que\...
`P(p|{7H3T}) = p⁷·(1-3)³ = P(H)·P(H)·P(H)·P(H)·P(H)·P(H)·P(H)·P(1-p(T))·P(1-p(T))·P(1-p(T))`.
Ahora podemos ver que el valor más probable está cerca del 0.7 y que, a
medida que el número de intentos aumenta este valor es más \"seguro\":\
![](/ai/data_analysis/example_bayesian.png)\
Si hay pocos valores el likelyhood hace que la distribución sea más
plana y probabilidad posterior es influida por la anterior. En cambio,
si hay muchos valores el likelyhood coge fuerza y cada vez se acorta más
el rango de *p*.

#### Estadística bayesiana como modelo

El resultado de realizar el test con Bayes es una distribución de por
sí, es decir, una hipótesis. Como tal podemos construir un [intervalo de
confianza](/numbers/statistics#intervalos_de_confianza) para *p*. La
estadística bayesiana trata fácilmente con datos inexistentes (missing
data), tatos en el tiempo, data sets hetereogeneos\... Porque es una
distribución, y como tal puede ser utilizada como input para un nuevo
modelo jerárquico.\
