# Alfred's Wiki Programming³

>  El código es tu amigo.


| 😎 [shortcuts](/wiki2/shortcuts) | 🧟 [legacy](/wiki2/legacy) | 🧙‍♂️ [Old wiki](/wiki2/wiki1) |
| ------------------------------- | ------------------------- | --------------------------- |




## Languages

### C++

-   [C++ Notes](/wiki2/cpp/notes)
-   [Idiomatic C++](/wiki2/cpp/idiomatic)


-   **Libraries**
    -   [curlpp](/wiki2/cpp/libraries/curlpp), for requests.
    -   [boost](/wiki2/cpp/libraries/boost)
    -   [OpenFrameworks](/wiki2/cpp/libraries/openframeworks)
    -   [Chipmunk](/wiki2/chipmunk), physics, C++.

### Elm

-   [elm](/wiki2/elm). Elm syntax and its ecosystem. Mostly deprecated
    as it is basic.
-   [elm-programming](/wiki2/elm-programming). How to use the language.
-   [elm-code](/wiki2/elm-code). Patterns and perks of Elm syntax.
-   [useful-elm](/wiki2/useful-elm). Elm tooling and useful tips for
    developing in Elm.


-   **Legacy**
    -   [basic](/wiki2/elm/basic). Elm notes written when learning.

### Go

-   [go_basics](/wiki2/go_basics) *(old)*
-   [go_useful](/wiki2/go_useful)
-   [go_libraries](/wiki2/go_libraries)

### JavaScript

-   [JavaScript](/wiki2/js)


-   **Extra**
    -   [js_dom](/wiki2/js_dom)
    -   [vuejs2](/wiki2/js_fw/vuejs2)


-   **Typescript**
    -   [typescript_review](/wiki2/typescript_review), *code that
        demonstrates TypeScript syntax*.
    -   [new_typescript](/wiki2/new_typescript), *notes about
        TypeScript*.


-   **React**
    -   [react_blind_sticks](/wiki2/react_blind_sticks), *random
        snippets and notes about React*.

### NodeJs

-   [nodejs](/wiki2/nodejs)
-   [patterns](/wiki2/nodejs/patterns)
-   [express](/wiki2/nodejs/express)
-   [resources](/wiki2/nodejs/resources)

### Python

-   [python3](/wiki2/python3), *the current main python section.*
-   [Python basic recipes](/wiki2/python/basic), *fast things about some
    basic python features.*
-   [Python notes](/wiki2/python/notes), *to inquire a bit about some
    features.*
-   [Python snippets](/wiki2/python/code_notes), *chunks of code in
    Python.*
-   [typing](/wiki2/python/typing)
-   [tooling](/wiki2/python/tooling)


-   **Django**
    -   [basic_django](/wiki2/python/basic_django)


-   **Flask**
    -   [Flask](/wiki2/python/flask)


-   **Jinja2**
    -   [Jinja2](/wiki2/python/jinja2)


-   **SqlAlchemy**
    -   [sqlalchemy](/wiki2/python/sqlalchemy)


-   **Python libraries and utils**
    -   [Python libraries](/wiki2/python/libraries)
    -   [PyMongo](/wiki2/python/pymongo)
    -   [MongoEngine](/wiki2/python/mongoengine)
    -   [Fabtools](/wiki2/python/fabtools)
    -   [flake8](/wiki2/python/flake8)
    -   [Gunicorn](/wiki2/gunicorn)
    -   [poetry](/wiki2/poetry)
    -   [oso](/wiki2/oso)

### Rust

-   [Rust](/wiki2/rust)
-   [Cargo package manager](/wiki2/rust/cargo)

## Concepts

### Data Analysis

-   [pandas_basic](/wiki2/pandas_basic)

### Graphics

-   [Graphics](/wiki2/graphics)

### OpenCV

-   [OpenCV](/wiki2/opencv)

### OpenGL

-   [OpenGL Pipeline](/wiki2/oglpipeline)
-   [OpenGL & GLSL](/wiki2/ogl)
-   [Matemáticas para OpenGL y gráficos](/wiki2/oglmaths)
-   [Terminos a aprender](/wiki2/ogltherms)
-   [Librerías y utilidades](/wiki2/ogllibs)
-   [OpenGL en iOS](/wiki2/oglios)

### Physics

-   [Physics definitions](/wiki2/physics/definitions), physics.

### Software Engineering

-   [Testing](/wiki2/engineering/testing)

### Web Development

-   [html_css](/wiki2/html_css). Things to keep in mind about HTML+CSS.
-   [html_css_howtos](/wiki2/html_css_howtos). Those *how to* you needed
    in the past and will probably need again in the future.
-   [sass](/wiki2/sass)
-   [Web development](/wiki2/webdev). Bower, Grunt, Geoman, Bourbon,
    Neat, Bitter and Refills.
-   [Web management](/wiki2/webmanagement). Tools, servers, and other
    pieces to manage a web deployment.
-   [webcomponents](/wiki2/webcomponents)

## Platforms & tools

### Ansible

-   [ansible](/wiki2/ansible)

### Arduino

-   [Resources for Arduino](/wiki2/arduino/resources)

### Caddy Server

-   [caddy](/wiki2/caddy)

### Docker

-   [Docker](/wiki2/docker), explicación básicogeneral.
-   [docker-advanced](/wiki2/docker-advanced), explicación más en
    profundidad de ciertos aspectos.
-   [docker-new](/wiki2/docker-new), comandos sueltos de docker.
-   [docker-examples](/wiki2/docker-examples), algunas notas en general.

### Dotnet

-   [dotnet](/wiki2/dotnet)

### Elasticsearch

-   [Elasticsearch](/wiki2/elasticsearch)

### Emacs

-   [emacs](/wiki2/emacs)

### GIT

-   [GIT concepts](/wiki2/gitconcepts), git.
-   [GIT commands](/wiki2/gitcommands), git.
-   [Git tools](/wiki2/gitlist)
-   [git_pipelines](/wiki2/git_pipelines)

### Jenkins

-   [jenkins](/wiki2/jenkins)

### Jupyter Notebooks

-   [jupyter](/wiki2/jupyter)

### Linux

-   [Linux commands](/wiki2/linux_commands)
-   [Linux tools](/wiki2/linux_tools)
-   [Linux how tos](/wiki2/linux_howto)
-   [Linux programming](/wiki2/linux_scripting) - Linux scripting.
-   [linux_drivers](/wiki2/linux_drivers) - Driver programming and
    management. All concepts required to interact with hardware.
-   [linux-networking-tools](/wiki2/linux-networking-tools) - Tooling
    and concepts inside Linux for managing networks.

### Mongo

-   [MongoDB](/wiki2/mongodb/queries)

### MySQL

-   [MySql](/wiki2/mysql)

### NGINX

-   [NGINX](/wiki2/nginx)

### PostgreSQL

-   [postgresql](/wiki2/postgresql)
-   [postgrest](/wiki2/postgrest)

### Robotframework

-   [robotframework](/wiki2/robotframework)

### SSH

-   [SSH command and similars](/wiki2/ssh), scp\...

### Sublime Text

-   [SublimeText 3](/wiki2/sublime3), sublime text, gui, text editor.

### Vi/Vim

-   [vim](/wiki2/vim)
-   [vim_config](/wiki2/vim_config)
-   [vim_plugins](/wiki2/vim_plugins)

## Resources & notes

-   [Programming links](/wiki2/programming_links)
-   [Guarriscripts](/wiki2/guarriscripts)
-   [software_notes](/wiki2/software_notes)
-   [global](/wiki2/global)


-   **Tools**
    -   [tools](/wiki2/tools)
    -   [i3](/wiki2/tools/i3)
    -   [cajon](/wiki2/cajon)


-   **WGF**
    -   [alembic](/wiki2/alembic)
