# Old Wiki

*El código es tu amigo.*\

## Programming

## Lenguajes compilados

### C\\C++

-   [C\\C++](/highlevel/c)
-   [C\\C++ Orientado a objetos](/highlevel/c/poo)
-   [Xtra](/highlevel/c/xtra)
-   [Avanzando en C++](/highlevel/c/advancing)
-   [C++ en Linux](/highlevel/c/clinux)

### C#

-   [C#](/highlevel/csharp)
-   [Creación de aplicaciones en C#](/highlevel/csharp/apps)
-   [C# Xtra](/highlevel/csharp/xtra)
-   [C# Xtra II](/highlevel/csharp/xtra2)
-   [C# code snippets](/highlevel/csharp/snippets)
-   [Nuevas versiones de C#](/highlevel/chsarp/versions)
-   [Documentos de C#](/highlevel/csharp/docs)
-   [Mono](/highlevel/csharp/mono)

### Java

-   [Java](/highlevel/java)
-   [GUIs](/highlevel/java/guis)
-   [Programación gráfica 2d](/highlevel/java/2d)
-   [Xtra](/highlevel/java/xtra)

### Otros

-   [Processing](/highlevel/processing)
-   [Processing 2](/highlevel/processing2)

## Lenguajes interpretados

### Python

#### New

-   [Python](/script/python/new/language)*, uso básico del lenguaje.*
-   [Python avanzado](/script/python/new/advanced)*, características no
    básicas de Python.*
-   [Python - elementos](/script/python/new/api)*, explicación de
    elementos propios de Python.*
-   [Python - snippets](/script/python/new/snippets)*, código para
    llevar a cabo ciertas tareas.*
-   [Python - xtra](/script/python/new/xtra)*, utilidades y consejos.*

#### Old

-   [Python](/script/python)
-   [Xtra](/script/python/xtra)
-   [Documentos](/script/python/docs)

### JavaScript

-   [JavaScript](/script/jssintaxis), *sintaxis (y tips & tricks) de
    JavaScript*.
-   [JavaScript Avanzado](/script/jsadv), *tips del lenguaje y
    directrices para el correcto desarrollo en este lenguaje*.

### NodeJS

-   [NodeJS](/script/nodejs), *plataforma que usa JavaScript como
    lenguaje de servidor*.
-   [NodeJS extenido](/script/nodejsext), *a partir de los distintos
    módulos*.
-   [NodeJS avanzado](/script/nodeadv), *tips de la plataforma*.

### Otros

-   [Perl](/script/perl)

## Programación en internet

### Con Java

-   [JavaEE](/sp/j2ee)
-   [Servlets](/sp/j2ee/servlets)
-   [JSP](/sp/j2ee/jsp)
-   [JSTL](/sp/j2ee/jstl)

### Con PHP

-   [PHP](/sp/php)
-   [Xtra PHP](/sp/xtraphp)

### Con .NET

-   [ASP.NET](/sp/aspnet)
-   [Aplicaciones web con ASP.NET](/sp/aspnet/wapps)
-   [Windows Communication Foundation (WCF)](/sp/wcf)

### En el navegador

-   [JavaScript (en el navegador)](/sp/js)
-   [jQuery](/fw/others/jquery)
-   [Aplicaciones web](/sp/webapp), *conjunto de herramientas para el
    desarrollo de aplicaciones web en cliente*.

#### Con Flash, Flex o ActionScript

-   [Flex y MXML con Flex Builder y otras plataformas](/sp/flex)
-   [Flex Xtra](/sp/flex_xtra)
-   [Action Script 3](/script/as3)

## Programación funcional

### F#

-   [F#](/functional/fsharp)

### Scala

-   [Scala](/functional/Scala)

## Lenguajes matemáticos

-   [MATLAB](/math_langs/matlab)
-   [Octave](/math_langs/octave)
-   [R](/math_langs/r)
-   [Análisis de datos en Python](/math_langs/math_python), *a partir de
    las librerías más adecuadas para ello*.

## Bases de datos

### Bases de datos relacionales

-   [RDBMS (Relational database management systems)](/db/rdbms)
-   [SQL](/db/sql)

### Bases de datos NoSQL

-   [db4o](/db/db4o)
-   [MongoDB](/db/mongodb)
-   [Redis](/db/redis)

## Formato de datos

-   [XML](/tags/xml)
-   [Otras especificaciones XML](/tags/global_specifications)
-   [JSON](/tags/json)
-   [XUL](/tags/xul)
-   [KML](/tags/kml)
-   [YAML](/tags/yaml)

## Maquetación web

### XHTML

-   [(X)HTML & CSS](/tags/html)
-   [(X)HTML & CSS Xtra](/tags/htmlxtra)

### HTML5 y CSS3

-   [HTML5](/tags/html5)
-   [CSS3](/tags/css3)
-   [HTML5 & CSS3, tips & tricks](/tags/tipstricks), *consejos y trucos
    para HTML5 y CSS3*.

## Librerías, APIs, SDKs y Frameworks

-   [Librerías generales](/fw/others)

### Trabajo en Windows

#### API del sistema

-   [Win32 y GDI](/fw/winapi)

#### DirectX

-   [DirectX](/fw/dx)
-   [DirectDraw](/fw/dx/ddraw)
-   [DirectInput](/fw/dx/dinput)

#### Otros

-   [DirectShow](/fw/dshow)

### Gráficos con OpenGL

#### OpenGL v4

-   [Gráficos con OpenGL y GLSL](/fw/ogl/graphics) :!: Juntar
-   [OpenGL 4](/fw/ogl/ogl4)
-   [GLSL](/fw/ogl/glsl)

#### Anteriores versiones

-   [OpenGL](/fw/ogl)
-   [Xtra de OpenGL](/fw/ogl/xtra)
-   [Xtra 2 de OpenGL](/fw/ogl/xtra2)

### Desarrollo en Android

-   [Android (new)](/fw/android1)
-   [Android](/fw/android)

### Sistemas distribuidos con ZeroMQ

-   [ZeroMQ](/fw/zeromq)

### Desarrollo de juegos con Unity3D

#### Desarrollo 2D

-   [Unity3D environtment (2D)](/fw/unity3d/environtment2d)
-   [Unity3D plugins](/fw/unity3d/plugins)

## Codificando

-   [Conceptos](/code/concepts)
-   [Expresiones Regulares](/otros/regex)
-   [RESTful Web Services](/code/rest)
-   [TDD (Test Driven Development)](/code/tdd)
-   [BDD (Behavior Driven Development)](/code/bdd)

### Algoritmos

-   [Algoritmos en general](/otros/algoritmos)

### Patrones

-   [Patrones de diseño](/code/dessignpatterns)
-   [Patrones de diseño (II)](/code/dessignpatterns2)

### Arquitecturas

-   [SOA (Service Oriented Architecture)](/code/soa)
-   [Event-Driven Architecture](/code/eda)

### Reconocimiento de lenguajes

-   [Compiladores (Básico)](/otros/compilers)
-   [ANTLR](/otros/antlr)

### Interactive programming

-   [Programación interactiva básica](/otros/interactive0), *con
    Processing*.

### Combinations

-   [Webapps with Flask](/comb/webapp0)
-   [RabbitMQ](/comb/rabbitmq)

## Ingeniería

-   [Conceptos matemáticos](/numbers/maths)
-   [Cálculo](/numbers/calculo)
-   [Algebra](/numbers/algebra)
-   [Estadística](/numbers/statistics)
-   [Física](/numbers/physics)
-   [Gráficos](/numbers/graphics)

## Análisis de datos

-   [Análisis de datos](/ai/data_analysis), *interpretación y
    manipulación de datos*.
-   [Data Mining](/ai/data_mining), *algoritmos y metodología para la
    explotación de datos*.
-   [Visualización de datos](/data/visualization), *técnicas, consejos y
    ejemplos de gráficos para la exploración de datos*.

## Inteligencia Artificial

-   [Inteligencia Artificial Práctica](/ai/practica), *ejemplos y
    consejos sobre cómo utilizar los conceptos de IA*.

### General

-   [Algoritmos genéticos](/ai/genetic_algorithms)
-   [Algoritmos de búsqueda](/ai/techniques/search_algorithms)
-   [Lógica difusa](/ai/techniques/fuzzy_logic)

### Visión Artificial

-   [Image Processing](/ai/image_processing)
-   [Computer Vision](/ai/computer_vision)
-   [Computer Vision con OpenCV](/fw/opencv2), *librería por excelencia
    para desarrollo del tratamiento de imágenes y visión artificial
    desde C++*.

### Machine learning

-   [Machine Learning](/ai/machine_learning), *conceptos sobre el
    aprendizaje automático*.
-   [Supervised Machine Learning](/ai/supervised_ml)
-   [Unsupervised Machine Learning](/ai/unsupervised_ml)

### Natural Language Processing

-   [Natural Language Processing](/ai/nlp), *parte teórica*.
-   [NLP con NLTK](/ai/nlp_with_nltk), *procesamiento de lenguaje
    natural con NLTK (framework de Python)*.

### Otros

-   [Otros](/ai/otros)

## Electrónica

-   [Básica](/electr/basica)
-   [Arduino](/electr/arduino)
-   [Programming Arduino](/electr/programming_arduino)

## Sistemas

### Servidores web

-   [Apache Web Server](/sistemas/apache)
-   [lighttpd](/sistemas/lighttpd) *o [Gunicorn](http://gunicorn.org)*
    // o [uWSGI](http://projects.unbit.it/uwsgi/)//

### GIS

-   [Sistemas de Información Geográfica (GIS)](/sistemas/gis)
-   [MapServer](/sistemas/gis/mapserver)

### Linux

-   [Sistemas Linux](/sistemas/linux/linux)
-   [Sistemas Linux Xtra](/sistemas/linux/xtra)
-   [Notas, tips & tricks sobre Linux](/sistemas/linux/notes)

#### Scripting

-   [Bash Scripting](/sistema/linux/bash)
-   [Shell Scripting](/sistema/linux/sh)

#### Old

-   [Sistemas Linux (old)](/sistema/linux/howto)
-   [Sistemas Linux Xtra (old)](/sistema/linux/nuthsell)

### Control de versiones

-   [Subversion](/code/subversion)
-   [GIT](/code/git)
-   [GIT (old)](/code/gitold)

### Sistemas de Information Retrieval

-   [Solr](/sistemas/ir/solr)

### Edición de textos

-   [LATEX](/sistemas/doc/latex)
-   [Vim](/sistemas/doc/vim)

## Servicios

-   [Amazon Web Services](/services/aws)

## Otros

-   [Recursos](/code/tools)
-   [Interview questions](/otros/interview_questions)
-   [Otros de otros (cómo utilizar programas, listas de librerías,
    trucos\...)](/otros/otros)
