# Sass

## Execute

    sass --watch main.scss:../stylesheet.css

## Install and fix errors

    sudo apt install sass

If there is an error with `watch` like:
`LoadError: cannot load such file -- sass-listen`, you will need to
execute the next:

    sudo apt-get install ruby-listen
    sudo gem install sass-listen

## Sintaxis

### Imports

    @import "definitions";
    @import "global";
    @import "frontpage";

### Import de fuentes

Al iniciar el documento:

    @import url("https://fonts.googleapis.com/css?family=Kreon|Bitter");

O de un ttf:

    @font-face {
        font-family: "OpenSans";
        src: url("../fonts/OpenSans/OpenSans-Regular.ttf");
    }

### Uso de fuentes

    $font-title: "Kreon", "Courier New", monospace;
    font-family: $font-default;

### Maps

    $scale-large: (
        h1: 2.961rem,
        h2: 2.2rem,
        h3: 1.2rem,
        p: 1rem,
        p-little: 0.8rem
    );
    ...
    font-size: map-get($scale-large, h2);

### Mixins

    @mixin size($elem) {
      font-size: map-get($scale-large, $elem);
      @media (max-width: $responsive-medium) {
        font-size: map-get($scale-medium, $elem);
      }
      @media (max-width: $responsive-small) {
        font-size: map-get($scale-small, $elem);
      }
    }
    ...
    @include size(h2); 

### Operators

    width: 600px / 960px * 100%;

### Inheritance

    %message-shared {
      border: 1px solid #ccc;
      padding: 10px;
      color: #333;
    }

    .message {
      @extend %message-shared;
    }

### Nesting

    .block {
      ul {
        margin: 0;
        padding: 0;
        list-style: none;
      }

      li { display: inline-block; }

      a {
        display: block;
        padding: 6px 12px;
        text-decoration: none;
      }
    }

### Funciones

    darken($btn-bkg, 10%);
    lighten($btn-bkg, 10%);
    transparentize($primary-background-color, 0.5);

## Snippets

### Si no está definida\...

Si no está previamente definida la variable `django-backcolor` asigna el
valor `red`:

    $django-backcolor: red !default;
