# Python libraries

## Big ones

## Little ones

-   [Colorama](https://pypi.python.org/pypi/colorama) mostrar el texto
    con diferentes fondos y colores de una forma muy sencilla.
-   [PySnooper](https://github.com/cool-RR/pysnooper) para hacer prints
    en medio de una función.

## IPython

-   `object??`
-   `object?`
-   `%quickref` o `%magic`
-   `%run -i hello.py`, run interactively hello.py
-   `%run hello.py`, run hello.py

Launch it as GUI command:

    mate-terminal -e ipython

To make ipython reload loaded modules:

    %load_ext autoreload                                                                                                                                                                                    
    %autoreload 2 

## Fabric 2

### Open connections

    result = Connection('127.0.0.1', port=2222, user="root", connect_kwargs={"password": "test"}).run('uname -s', hide=True)

### Execute on a remote folder

    connection = Connection('127.0.0.1', port=2222, user="root", connect_kwargs={"password": "test"})
    with connection.cd('/var/www'):
       result = connection.run(command)

## pycalver \| bumpver

-   <https://gitlab.com/mbarkhau/pycalver>

Instalar:

    poetry add bumpver

Iniciar proyecto:

    bumpver init

En `pyproject.toml` tendrás la inicialización. Al iniciar y no existir
dará un \"error\".

Mi version_pattern escogido es:

    version_pattern = "YYYY.WW[.PATCH]"

Lo mejor es asegurarse de que quede algo así:

    [tool.bumpver]
    current_version = "2021.0.0"
    version_pattern = "YYYY.WW[.PATCH]"
    commit_message = "bump version {old_version} -> {new_version}"
    commit = true
    tag = true
    push = false


    [tool.bumpver.file_patterns]
    "pyproject.toml" = [
        'current_version = "{version}"',
    ]

Para ejecutar una subida de versión de prueba (si quieres subir el patch
has de añadir: `-p`):

    bumpver update --dry

## Artículos

-   <http://blog.yhathq.com/posts/11-python-libraries-you-might-not-know.html>
