# Django Views

Devolver el resultado de una función como vista:

``` python
# En urls:
urlpatterns = [
    path('videos/', views.VideoListView.as_view(), name='videos'),
]

# En views:
from django.http import HttpResponse
def index(request):
    return HttpResponse('Hey yo!')
```

## How to\...

### Get data from url

#### En generic views

If you don\'t want to pass a pk or slug in your url, you\'ll need to
override the `get_object` method and get your object another way.

    path('profile/<username>', views.UserDetailView.as_view(), name='profile')

    class UserDetailView(generic.DetailView):
        model = apps.get_model('openawards', 'User')
        username = ''

        def dispatch(self, request, *args, **kwargs):
            super().dispatch(request, *args, **kwargs)
            self.username = kwargs.get('username', '')

        def get_object(self):
            return get_object_or_404(get_user_model(), username=self.username)

:?: Me pregunto si hay otra forma mejor de sacar el parámetro de la url
en vez de sobreescribiendo el dispatch. Si!! Siempre puedes acceder a
los kwargs de la request:

    return get_object_or_404(get_user_model(), username=self.kwargs.get('username', ''))

Si los datos viniesen por query string:

    username = self.request.GET.get('username', '')

Coger la url con la que fue llamada la view:

    request.build_absolute_uri()

#### Set login_required decorator

En el urls.py:

    login_required(ViewSpaceIndex.as_view(..))

Usando LoginRequiredMixin:

    from django.contrib.auth.mixins import LoginRequiredMixin
    class MyView(LoginRequiredMixin, View):
        login_url = '/login/'
        redirect_field_name = 'redirect_to'

Con el method_decorator:

    from django.utils.decorators import method_decorator
    @method_decorator(login_required, name='dispatch')
    class ViewSpaceIndex(TemplateView):
        template_name = 'secret.html'

#### Other decorators for user control

    from django.contrib.auth.decorators import user_passes_test

    @user_passes_test(lambda u: u.is_superuser)
    def my_view(request):
        ...

    from django.contrib.admin.views.decorators import staff_member_required

    @staff_member_required
    def my_view(request):
        ...
