# Django URL\'s

Añadir las urls de una app:

    urlpatterns += [
        path('catalog/', include('catalog.urls')),
    ]

Redirigir una url a otra:

    urlpatterns += [
        path('', RedirectView.as_view(url='/catalog/')),
    ]

Urls con parámetros:

    ...
    path('users/activate/<token>/', views.activate, name='users_activate'),
    ...
    def activate(request, token):
       user = get_user_model().objects.get(token=token)
    ...
    url = reverse('users_activate', args=(user.token,))

Enviar parámetros a la view:

    path('my_courses', CoursesListView.as_view(), {'mine': True}, name='my_courses'),
    # In this example, for a request to /blog/2005/, Django will call views.year_archive(request, year=2005, foo='bar').

## URL dispatchers

``` python
from django.urls import path, register_converter
from . import converters, views

class FourDigitYearConverter:
    regex = '[0-9]{4}'

    def to_python(self, value):
        return int(value)

    def to_url(self, value):
        return '%04d' % value

register_converter(converters.FourDigitYearConverter, 'yyyy')

urlpatterns = [
    path('articles/2003/', views.special_case_2003),
    path('articles/<yyyy:year>/', views.year_archive),
    ...
]
```
