# Django

## Commands to manage the project

To know the version:

    python -m django --version

Create a Django project:

    django-admin startproject mysite .

Launch project:

    manage.py runserver

Create app:

    python manage.py startapp polls

Create app in a different folder than root which should exist:

     python manage.py startapp coopolis apps/coopolis

Create migration files and prepare DB:

    python manage.py makemigrations
    python manage.py migrate

:?: squashmigrations

Open the Django shell:

    python manage.py shell

If you prefer to use another interpret (in the next case ipython should
be installed into the environment):

    python manage.py shell -i ipython

## Minimum Django

-   From: [Minimal Django
    repo](https://github.com/syntarsus/minimal-django)

``` python
import sys

from django.conf import settings
from django.conf.urls import url
from django.core.management import execute_from_command_line
from django.http import HttpResponse

settings.configure(
    DEBUG=True,
    ROOT_URLCONF=sys.modules[__name__],
)


def index(request):
    return HttpResponse('<h1>A minimal Django response!</h1>')

urlpatterns = [
    url(r'^$', index),
]

if __name__ == '__main__':
    execute_from_command_line(sys.argv)
```

## Sections

[apps](/wiki2/python/django/apps)

[urls](/wiki2/python/django/urls)

[views](/wiki2/python/django/views)

[models](/wiki2/python/django/models)

[forms](/wiki2/python/django/forms)

[auth](/wiki2/python/django/auth)

[templates](/wiki2/python/django/templates)

[admin](/wiki2/python/django/admin)

[tests](/wiki2/python/django/tests)

[sites](/wiki2/python/django/sites)

## Other

[others](/wiki2/python/django/others)

[medium_django](/wiki2/python/medium_django)

[asyncio and Django](/wiki2/python/notes#asyncio_on_django)

[project](/wiki2/python/django/project)

## Libraries

-   [Constance: Dynamic settings (on
    DB)](https://django-constance.readthedocs.io/en/latest/)
-   [Utils that are not on the basic
    framework](https://github.com/idlesign/django-etc)
-   [Django-Solo: To create singletones on the
    DB](https://github.com/lazybird/django-solo)
-   [Create tables](https://django-tables2.readthedocs.io/en/latest/)
-   [Allow to add properties to the html rendered
    components](https://github.com/jazzband/django-widget-tweaks) also
    [Crispy
    forms](https://simpleisbetterthancomplex.com/tutorial/2018/11/28/advanced-form-rendering-with-django-crispy-forms.html).
-   [WhiteNoise: Para que sea Django en producción quien sirva los
    estáticos sin necesidad de
    nginx](http://whitenoise.evans.io/en/stable/index.html).

## Links

-   [Django Snippets](https://djangosnippets.org/)
