# PostgreSQL for PostgREST

-   <http://postgrest.org/en/v5.0/>

## Crear el schema

    create schema api;

## Crear usuarios

### Anónimos

    create role web_anon nologin;
    grant web_anon to postgres;
    grant usage on schema api to web_anon;
    grant select on api.todos to web_anon;

### Usuario de confianza

    create role todo_user nologin;
    grant todo_user to postgres;
    grant usage on schema api to todo_user;
    grant all on api.todos to todo_user;
    grant usage, select on sequence api.todos_id_seq to todo_user;

## Acciones básicas mediante llamadas REST

    # Basic query
    curl http://localhost:3000/todos

    # Insert
    curl http://localhost:3000/todos -X POST \
         -H "Content-Type: application/json" \
         -d '{"task": "do bad thing"}'

    # Advanced queries
    GET /people?age=lt.13 HTTP/1.1
    GET /people?age=gte.18&student=is.true HTTP/1.1
    GET /people?or=(age.gte.14,age.lte.18) HTTP/1.1
    GET /people?and=(grade.gte.90,student.is.true,or(age.gte.14,age.is.null)) HTTP/1.1

    # Selecting some rows
    /people?select=first_name,age
    GET /people?order=age.desc,height.asc HTTP/1.1
    GET /people?order=age HTTP/1.1
    GET /people?order=age.nullsfirst HTTP/1.1
    GET /people?order=age.desc.nullslast HTTP/1.1

    # Limits and pagination
    GET /people?limit=15&offset=30 HTTP/1.1

    # Stored procedures ─ Every stored procedure in the API-exposed database schema is accessible under the /rpc
    POST /rpc/function_name HTTP/1.1

    POST /rpc/add_them HTTP/1.1 { "a": 1, "b": 2 }
    GET /rpc/add_them?a=1&b=2 HTTP/1.1

    # Delete
    DELETE /user?active=is.false HTTP/1.1
