# Linux commands

## Global commands

### Uso de servidores

    # Mirar el espacio en disco
    $ df -h
    # Mirar el espacio en memoria
    $ free -h
    # Mirar la ip
    $ ip address

### Comprimir y descomprimir

    tar -zcvf archive-name.tar.gz directory-name
    # Extract
    tar -zxvf prog-1-jan-2005.tar.gz
    # Extract in a particular directory
    tar -zxvf prog-1-jan-2005.tar.gz -C /tmp

# Commands

## alias

    alias emacs="emacs -nw"

## apt

#### Install

`apt install <package>`

#### Reinstall

`sudo apt-get install opera-stable --reinstall`

#### Remove

`sudo apt-get purge opera-stable`

#### Get the source code

`sudo apt-get source opera-stable`

#### Listar paquetes

`apt-cache search keyword`

`apt-cache search .`

#### Listar paquetes instalables, upgradables\...

`apt list --<param> <?package>`,
param=(installed\|upgradeable\|all-versions)

#### Listar versiones de un paquete

`apt-cache policiy <package>`

#### Ver información concreta de un paquete

`sudo apt-cache show "opera-stable"`

#### Instalar una versión concreta

`apt install <package>=<version>`

#### Update or upgrade

You just need to do `apt-get install --only-upgrade <packagename>`. This
will upgrade only that single package, and only if it is installed. If
you wish to install the package if it doesn\'t exist, or upgrade it if
it does, you may leave out `--only-upgrade`.

### Set a proxy

Edit apt-conf file (or create a new one if you have no one yet) using
the editor of your choice.

    sudo nano /etc/apt/apt.conf

Add this line to your /etc/apt/apt.conf file (substitute your details
for yourproxyaddress and proxyport).

    Acquire::http::Proxy "http://yourproxyaddress:proxyport";

## ls

-   Order ls: `ls -t`
-   For reverse order (most recent at bottom): `ls -tr`

## df

Disk usage.

-   In MB: `df -m`
-   In a human readable format: `df -h`

## chown

Change the owner:

-   For changing the user and the group recursively:
    `chown www-data: -R .`

## findmnt

To display mounted data:

    findmnt

Other options:

    # List format
    findmnt -l
    # Showing disk usage
    findmnt –D
    # fstab
    findmnt -s
    # filter by type:
    findmnt -t ext4
    findmnt -t xfs
    # filter by device:
    findmnt -S /dev/vda3
    # filter by mounted point:
    findmnt -T /

## tail

To see the last lines of a file.

-   For maintaining it reading it use `-f` parameter.

## tree

To see a tree of only directories until 3rd level:

    tree -d -L 3

The next will also give you the disk space used:

    tree --du -h

## xargs

To send output as parameters:

    $ echo 'one two three' | xargs mkdir
    $ ls
    one two three

**Script example** for creating .cbz files from folders inside the
current path:

    ls -1 | xargs -I {} zip {}.cbz -r {}

## Zip and unzip

    zip -r app.old.zip app/

## Others

-   htop -\> easy to use top command
-   glances -\> easy to use monitoring command
-   tree -\> to show the folder tree
-   watch -\> wait showing a command output
-   shutdown now -\> turn the computer off
-   i3lock -c 000000 -\> turn the screen off
-   xdotool -\> for sending via command line keys, texts\... to the GUI

### Tips for commands

**!\<command\>** will execute the \<command\> with the parameters you
executed last time: remember the command name e.g. !ls will execute your
last "ls -lrt" , !vim will open your last file without typing full
command.

**!!** will execute the last command.

# Move on the paths

`cd -` goes to the prev visited path.

`pushd` and `popd` create a stack of path. If you arrive to a path and
want to add it on the stack, you will do `pushd .`

With `dirs` command you can see the stack.

You can add this to .bashsrc to add `cd +` as ot do `popd`. So when you
visit a path you auto add pushd\'s:

    cd()
    {
      if [ $# -eq 0 ]; then
        pushd "$HOME" > /dev/null
      elif [ $1 = "+" ]; then
        popd > /dev/null
      else
        pushd "$@" > /dev/null
      fi
    }

# Others

## Close others sessions

:!: It\'s not recommended to do this for root; it could close all the
current running processes.

    pkill -KILL -u user

## Create cbz from folders

    ls -1 $* | xargs -I {} zip "{}.cbz" -r "{}"

## Clear and reset

You can do `Ctrl+l` to clear the screen which is the same than `clear`
command.

To actually reset the scroll and everything you will use the `reset`
command.

## Useful aliases

    My favorite new one that I have been using a lot:
      function cheat() {
          curl cht.sh/$1
      }
    It queries the cht.sh cheatsheet of various Unix commands. 'cheat tar' prints:
      # To extract an uncompressed archive:
      tar -xvf /path/to/foo.tar
      
      # To create an uncompressed archive:
      tar -cvf /path/to/foo.tar /path/to/foo/
      
      # To extract a .gz archive:
      tar -xzvf /path/to/foo.tgz
      
      # To create a .gz archive:
      tar -czvf /path/to/foo.tgz /path/to/foo/
      ...
