# Install wordpress

## Apache

### Install Apache, PHP & MySQL

    sudo apt-get install apache2
    sudo apt-get install php5
    sudo apt-get install libapache2-mod-php5
    sudo apt-get install mysql-server php5-mysql
    sudo /etc/init.d/apache2 restart

### Allow permalinks

    I had to search various sites to solve this problem so I figured I would pass on the knowledge in one succinct solution.

    How to get WordPress permalinks / pretty links to work in Ubuntu 10.10 with Apache2:

    By the way, this should be the same in Ubuntu 10.04 as well, but I haven't actually tested it there as well.

    1. Manually create a ".htaccess" file and save it in your main WordPress directory. (This is the one with the wp-admin, wp-includes, and wp-content folders.)

    2. Go to the Ubuntu terminal and type:
    sudo chown -v :www-data "/enterYourFilePathHere/.htaccess"
    You should see a line printed saying that the (group) file ownership has been changed to www-data (Apache2).

    3. Give Apache2 write access to the file:
    sudo chmod -v 664 "/enterYourFilePathHere/.htaccess"
    You should see a line printed saying that the mode of the file has been retained.

    4. Next, we have to allow WordPress to write to the .htaccess file by enabling mod_write in the Apache2 server. Type the following in the terminal:
    sudo a2enmod rewrite
    You should see a line printed saying that it is enabling mod rewrite and reminding you to restart the web server

    5. So let's do that. Restart the web server, Apache2, for the changes to take effect by typing:
    sudo /etc/init.d/apache2 restart
    We are all done with the command line prompt; you can close the command line window now.

    5. Go into your WordPress admin panel (i.e. http://yourDomain/wp-admin). Go to the Settings --> Permalinks and select the permalink format of your choice. Hit the "Save Changes" button.

    6. DONE! Go to your site and check any page (other than your homepage) to ascertain that everything is working as expected.

    Hope this helps someone. Leave me a comment below.

It allows php to change the .htaccess and then the wordpress admin
resets it.

If it\'s not working probably would do when you change the permalink to
`index.php/%postname%/`. But it won\'t be pretty. So\...

You will need to go to `/etc/apache2/` and change all the directories
to\...

    <Directory var/www/>
    Options FollowSymLinks
    AllowOverride All
    </Directory>

If it is not working, my change are these:

    <Directory />
            Options FollowSymLinks
            AllowOverride All
    </Directory>

    <Directory /usr/share>
            AllowOverride None
            Require all granted
    </Directory>
    <Directory /var/www/>
            Options FollowSymLinks
            AllowOverride All
    </Directory>

    #<Directory /srv/>
    #       Options Indexes FollowSymLinks
    #       AllowOverride None
    #       Require all granted
    #</Directory>

It\'s ultra-important to **enable mod rewrite**: `a2enmod rewrite`

### Backup and restore

1.  Before of this install the plugin (you can do it on the admin panel)
    **backupwordpress**.
    -   <http://downloads.wordpress.org/plugin/backupwordpress.3.6.0.zip>
2.  Make and download a backup file. This file must contain files and
    database.
3.  Format server
4.  Install apache, php and Mysql. Ensure
5.  Go to `/var/www/html`
6.  Download with `wget` the last Wordpress.
7.  Unzip the wordpress file.
8.  Upload the previous backup file.
9.  Unzip the backup file.
10. Change in the database file (.sql) the beginning adding: the next
    lines (if database is called blog):
    1.  `CREATE DATABASE blog;`
    2.  `USE blog;`
11. If database has a different password than the previous one you
    should change `wp-config.php`.
12. Execute the command: `mysql -u <user> -p < db_backup.dump`
13. Go to `/var/www` and execute:
    1.  `chown -R www-data html`
    2.  `chgrp -R www-data html`

### Attacks

It\'s possible to find in your `/var/log/apache2/access.log` a lot of
lines like this:
`111.222.333.444:80 555.666.777.888 - - [01/Jan/2016:16:33:50 -0500] "POST /xmlrpc.php HTTP/1.0" 200 674 "-" "Mozilla/4.0 (compatible: MSIE 7.0; Windows NT 6.0)"`

    <files xmlrpc.php>
          order allow,deny
          deny from all
        </files>

### Problems

Si mueves un site a otra url puedes hacer varias cosas, en el
`wp-config.php`. La mejor opción sea poner el RELOCATE, acceder y el
mismo wordpress habrá arreglado las rutas.

    define('RELOCATE',true); 

    define('WP_HOME','https://2017.foropoliamor.org');
    define('WP_SITEURL','https://2017.foropoliamor.org');

Para actualizar las urls utiliza: `Velvet Blues Update URLs plugin`, que
se ubicará en herramientas.

### Cambiar password desde mysql

    UPDATE `blog_users` SET `user_pass`= MD5('yourpassword') WHERE `user_login`='david';
