# HTML and CSS gotchas

## Change others

On a CSS hover event, change another div\'s styling. Without elements
between:

    #a:hover + #b {
        background: #ccc
    }
    ...
    <div id="a">Div A</div>
    <div id="b">Div B</div>

On a CSS hover event, change another div\'s styling. With elements
between:

    #a:hover ~ #b {
        background: #ccc
    }
    ...
    <div id="a">Div A</div>
    <div>random other elements</div>
    <div>random other elements</div>
    <div>random other elements</div>
    <div id="b">Div B</div>

Remove inherited attributes:

    .gtd-button {
        all: unset;
        position: absolute;
        z-index: 10000;
        ...

## CSS Selectors

  Selector                Example                                                                             Example description
  ----------------------- ----------------------------------------------------------------------------------- ----------------------------------------------------------------------------------------------------------
  .class                  .intro                                                                              \"Selects all elements with class=\"\"intro\"\"\"
  .class1.class2          \"\<div class=\"\"name1 name2\"\"\>\...\</div\>\"                                   Selects all elements with both name1 and name2 set within its class attribute
  .class1 .class2         \"\<div class=\"\"name1\"\"\> \<div class=\"\"name2\"\"\> \... \</div\>\</div\>\"   Selects all elements with name2 that is a descendant of an element with name1
  #id                     #firstname                                                                          \"Selects the element with id=\"\"firstname\"\"\"
  \*                      \*                                                                                  Selects all elements
  element                 p                                                                                   Selects all \<p\> elements
  element,element         div, p                                                                              Selects all \<div\> elements and all \<p\> elements
  element element         div p                                                                               Selects all \<p\> elements inside \<div\> elements
  element\>element        div \> p                                                                            Selects all \<p\> elements where the parent is a \<div\> element
  element+element         div + p                                                                             Selects all \<p\> elements that are placed immediately after \<div\> elements
  element1\~element2      p \~ ul                                                                             Selects every \<ul\> element that are preceded by a \<p\> element
  \[attribute\]           \[target\]                                                                          Selects all elements with a target attribute
  \[attribute=value\]     \[target=\_blank\]                                                                  \"Selects all elements with target=\"\"\_blank\"\"\"
  \[attribute\~=value\]   \[title\~=flower\]                                                                  \"Selects all elements with a title attribute containing the word \"\"flower\"\"\"
  \[attribute\|=value\]   \[lang\|=en\]                                                                       \"Selects all elements with a lang attribute value starting with \"\"en\"\"\"
  \[attribute\^=value\]   \"a\[href\^=\"\"https\"\"\]\"                                                       \"Selects every \<a\> element whose href attribute value begins with \"\"https\"\"\"
  \[attribute\$=value\]   \"a\[href\$=\"\".pdf\"\"\]\"                                                        \"Selects every \<a\> element whose href attribute value ends with \"\".pdf\"\"\"
  \[attribute\*=value\]   \"a\[href\*=\"\"w3schools\"\"\]\"                                                   \"Selects every \<a\> element whose href attribute value contains the substring \"\"w3schools\"\"\"
  :active                 a:active                                                                            Selects the active link
  ::after                 p::after                                                                            Insert something after the content of each \<p\> element
  ::before                p::before                                                                           Insert something before the content of each \<p\> element
  :checked                input:checked                                                                       Selects every checked \<input\> element
  :default                input:default                                                                       Selects the default \<input\> element
  :disabled               input:disabled                                                                      Selects every disabled \<input\> element
  :empty                  p:empty                                                                             Selects every \<p\> element that has no children (including text nodes)
  :enabled                input:enabled                                                                       Selects every enabled \<input\> element
  :first-child            p:first-child                                                                       Selects every \<p\> element that is the first child of its parent
  ::first-letter          p::first-letter                                                                     Selects the first letter of every \<p\> element
  ::first-line            p::first-line                                                                       Selects the first line of every \<p\> element
  :first-of-type          p:first-of-type                                                                     Selects every \<p\> element that is the first \<p\> element of its parent
  :focus                  input:focus                                                                         Selects the input element which has focus
  :hover                  a:hover                                                                             Selects links on mouse over
  :in-range               input:in-range                                                                      Selects input elements with a value within a specified range
  :indeterminate          input:indeterminate                                                                 Selects input elements that are in an indeterminate state
  :invalid                input:invalid                                                                       Selects all input elements with an invalid value
  :lang(language)         p:lang(it)                                                                          \"Selects every \<p\> element with a lang attribute equal to \"\"it\"\" (Italian)\"
  :last-child             p:last-child                                                                        Selects every \<p\> element that is the last child of its parent
  :last-of-type           p:last-of-type                                                                      Selects every \<p\> element that is the last \<p\> element of its parent
  :link                   a:link                                                                              Selects all unvisited links
  :not(selector)          :not(p)                                                                             Selects every element that is not a \<p\> element
  :nth-child(n)           p:nth-child(2)                                                                      Selects every \<p\> element that is the second child of its parent
  :nth-last-child(n)      p:nth-last-child(2)                                                                 Selects every \<p\> element that is the second child of its parent, counting from the last child
  :nth-last-of-type(n)    p:nth-last-of-type(2)                                                               Selects every \<p\> element that is the second \<p\> element of its parent, counting from the last child
  :nth-of-type(n)         p:nth-of-type(2)                                                                    Selects every \<p\> element that is the second \<p\> element of its parent
  :only-of-type           p:only-of-type                                                                      Selects every \<p\> element that is the only \<p\> element of its parent
  :only-child             p:only-child                                                                        Selects every \<p\> element that is the only child of its parent
  :optional               input:optional                                                                      \"Selects input elements with no \"\"required\"\" attribute\"
  :out-of-range           input:out-of-range                                                                  Selects input elements with a value outside a specified range
  ::placeholder           input::placeholder                                                                  Selects input elements with placeholder text
  :read-only              input:read-only                                                                     \"Selects input elements with the \"\"readonly\"\" attribute specified\"
  :read-write             input:read-write                                                                    \"Selects input elements with the \"\"readonly\"\" attribute NOT specified\"
  :required               input:required                                                                      \"Selects input elements with the \"\"required\"\" attribute specified\"
  :root                   :root                                                                               Selects the document\'s root element
  ::selection             ::selection                                                                         Selects the portion of an element that is selected by a user
  :target                 \#<news:target>                                                                     Selects the current active #news element (clicked on a URL containing that anchor name)
  :valid                  input:valid                                                                         Selects all input elements with a valid value
  :visited                a:visited                                                                           Selects all visited links

**Order of style applying**: Styles are applied according to which
styles are most specific to the element, and then in textual order for
rules that have equal specificity.

## Internalization

-   From:
    <https://www.smashingmagazine.com/2014/06/css-driven-internationalization-in-javascript/>
-   ![PDF
    Version](/wiki2/css-driven_internationalization_in_javascript_smashing_magazine.pdf){.align-center}

``` html
<!DOCTYPE html>
<html>
  <head>
    <meta charset="UTF-8">
    <style type="text/css">
    [data-l11n=ru] {
        display: none;
    }

    :lang(ru) > [data-l11n] {
        display: none;
    }

    :lang(ru) > [data-l11n=ru] {
        display: inline;
    }
    </style>
  </head>
  <body>
    <p>
      <label>
        <span data-l11n>Change language:</span>
        <span data-l11n="ru">Изменить язык:</span>
        <select onchange="document.documentElement.lang=this.value">
          <option value="en">English</option>
          <option value="ru">Русский</option>
        </select>
      </label>
    </p>
    <h1>
      <span data-l11n>Feedback</span>
      <span data-l11n="ru">Обратная связь</span>
    </h1>
</body>
</html>
```

## SVG

### Using img tag

    <img src = "happy.svg" alt="My Happy SVG"/>

### Using object tag

    <object data="happy.svg" width="300" height="300"> </object>

### Add an svg with code directly

    <svg width="100" height="100">
      <circle cx="50" cy="50" r="40" stroke="green" stroke-width="4" fill="yellow" />
    </svg>

### Using a file

It comes from: https://github.com/feathericons/feather#svg-sprite=

    <svg
      width="24"
      height="24"
      fill="none"
      stroke="currentColor"
      stroke-width="2"
      stroke-linecap="round"
      stroke-linejoin="round"
    >
      <use href="path/to/feather-sprite.svg#circle"/>
    </svg>

### From a reference in code

    <div>
      <svg>
        <use xlink:href="#bike" />
      </svg>
    </div>

    <svg display="none">
      <symbol width="24" height="24" viewBox="0 0 24 24" id="bike">
        <path d="M5,20.5A3.5,3.5 0 0,1 1.5,17A3.5,3.5 0 0,1 5,13.5A3.5,3.5 0 0,1 8.5,17A3.5,3.5 0 0,1 5,20.5M5,12A5,5 0 0,0 0,17A5,5 0 0,0 5,22A5,5 0 0,0 10,17A5,5 0 0,0 5,12M14.8,10H19V8.2H15.8L13.86,4.93C13.57,4.43 13,4.1 12.4,4.1C11.93,4.1 11.5,4.29 11.2,4.6L7.5,8.29C7.19,8.6 7,9 7,9.5C7,10.13 7.33,10.66 7.85,10.97L11.2,13V18H13V11.5L10.75,9.85L13.07,7.5M19,20.5A3.5,3.5 0 0,1 15.5,17A3.5,3.5 0 0,1 19,13.5A3.5,3.5 0 0,1 22.5,17A3.5,3.5 0 0,1 19,20.5M19,12A5,5 0 0,0 14,17A5,5 0 0,0 19,22A5,5 0 0,0 24,17A5,5 0 0,0 19,12M16,4.8C17,4.8 17.8,4 17.8,3C17.8,2 17,1.2 16,1.2C15,1.2 14.2,2 14.2,3C14.2,4 15,4.8 16,4.8Z"></path>
      </symbol>
    </svg>
