# GIT concepts

## Obtaining info

### Present of branch

`git status` gives you information about which files have changed for
the next commit.

`git status -s` does it schematic.

### Story of the branch

`git log` gives you information about the commits in your repository.
Parameters for log are\...

-   `- -stat` and shows statistics of which files have changed with
    graphics.
-   `-p` show specific changes in files.
-   `- -author=Andy`, to look for the changes done by Andy.

```{=html}
<!-- -->
```
    Search in messages:
    $ git log --grep="Something in the message"
    Look the first time it appeared:
    $ git log -S "TODO: Check for admin status"
    A improved search:
    $ git log --since=2.months.ago --until=1.day.ago --author=andy -S "something" --all-match

`git log --pretty=oneline -- <filename>` to see the story of the file.

### Who did what?

`$ git blame FILE` to see who made the changes in the file.

### Statistics

-   `git shortlog` commits by user
-   `git shortlog -sne` number of commits by user.

### Changes in files

To see a list of differences between the current version of a file and a
historical one, you refer to the historical version's hash:

      git diff <hash> -- <filename>

Also to see the last changes:

    git diff filename

You also can use: `gitk filename`

You can also compare two historical versions:

      git diff <hash1>  <hash2> -- <filename>

## Commit

### Commit properties

#### Atomic commits

Commits must be atomic, it means only should do an action. So commit
each fix or task as a separate change. Only commit when a block of work
is complete. Commit each layout change separately. Joint commit for
layout file, code behind file, and additional resources.

It will allow easy roll backs without affecting other changes, easiness
to make other changes on the fly, easiness to merge features to other
branches.

### Commit names

    Summarize changes in around 50 characters or less

    More detailed explanatory text, if necessary. Wrap it to about 72
    characters or so. In some contexts, the first line is treated as the
    subject of the commit and the rest of the text as the body. The
    blank line separating the summary from the body is critical (unless
    you omit the body entirely); various tools like `log`, `shortlog`
    and `rebase` can get confused if you run the two together.

    Explain the problem that this commit is solving. Focus on why you
    are making this change as opposed to how (the code explains that).
    Are there side effects or other unintuitive consequenses of this
    change? Here's the place to explain them.

    Further paragraphs come after blank lines.

     - Bullet points are okay, too

     - Typically a hyphen or asterisk is used for the bullet, preceded
       by a single space, with blank lines in between, but conventions
       vary here

    If you use an issue tracker, put references to them at the bottom,
    like this:

    Resolves: #123
    See also: #456, #789

-   Limit the subject line to 50 characters
-   Capitalize the subject line
-   Do not end the subject line with a period
-   Use the imperative mood in the subject line. A properly formed git
    commit subject line should always be able to complete the following
    sentence: `If applied, this commit will your subject line here`. For
    example: If applied, this commit will refactor subsystem X for
    readability. If applied, this commit will update getting started
    documentation. If applied, this commit will remove deprecated
    methods\...
-   Use the body to explain what and why vs. how

## Fetch VS Pull

In the simplest terms, git pull does a git fetch followed by a git
merge.

You can do a git fetch at any time to update your remote-tracking
branches under refs/remotes/\<remote\>/.

This operation never changes any of your own local branches under
refs/heads, and is safe to do without changing your working copy. I have
even heard of people running git fetch periodically in a cron job in the
background (although I wouldn\'t recommend doing this).

A git pull is what you would do to bring a local branch up-to-date with
its remote version, while also updating your other remote-tracking
branches.

## Resetting changes

You can easily unstage a change if you haven't committed it using:

    $ git reset HEAD lib/foo.rb

If you commited and it's the last commit you can just amend it:

    $ git commit --amend

### Going back to a previous commit

    $ git reset --hard 5b53
    $ git push -f

## Merge

### Notes about merging

-   When do merge a new commit appears. It represents the merge process.
-   You can see the changes that it would affect performing:
    `$ git diff --merge`

## Rebasing

It does the same than merge. When you want to apply the changes from the
master branch to your feature branch:

    git checkout feature
    git rebase master

Imaginemos que tenemos dos branches. Un master y una feature. Si la
feature se separó de la master hace unos commits y se agrega algo a
master que ha de ser también añadido a feature podemos hacer un merge,
con él los cambios que hay en master se unirán a la feature en el estado
actual. Al hacer un rebase lo que se consigue es que la branch feature
se coloque justo después del cambio en master, como si se hubiese creado
en ese momento. ![](/wiki2/git/g1171.png){.align-center width="300"} It
applies the commits from the master branch to the feature branch, one by
one. Rebasing gives you the opportunity to alter commits if you do them
interactively (passing -i parameter):

    git checkout feature
    git rebase -i master

You\'ll be able to alter how the commits are done using the text editor
for giving instructions to GIT.

YOU NEVER SHOULD DO IT ON PUBLIC BRANCHES. It could duplicate commits
and master branches. Before you run git rebase, always ask yourself, "Is
anyone else looking at this branch?" If the answer is yes, take your
hands off the keyboard and start thinking about a non-destructive way to
make your changes

## Stash

Use git stash when you want to record the current state of the working
directory and the index, but want to go back to a clean working
directory.

The stash is a temporary area working like a stack. You can push changes
onto it via `git stash` or `git stash save`; you can pop changes from
top with `git stash pop`. You can also apply a very specific part of the
stack with `git stash apply <stash id>`. Finally you can get the list of
all the stashes with `git stash list`.

## Cherry pick

Es coger un commit, el que sea (no importa la branch), y aplicar lo que
se aplica en él en el estado actual del repositorio. Por ejemplo para
aplicar únicamente uno:

    $ git cherry-pick E

Para aplicar varios cambios:

    $ git cherry-pick C D E

## Git Hooks

En la carpeta `.git/hooks` se encuentran scripts para distintos eventos
que ocurren durante el uso de git. Si no llevan la extensión `.sample` y
son ejecutables, se ejecutarán según el momento.

## Servers

### Tips

#### Add another remote server

    $ git remote add john git@github.com:johnsomeone/someproject.git

#### See remote servers

    git remote -v 

## Subtrees

Subtrees are an alternative to submodules.

### Links

<https://medium.com/@porteneuve/mastering-git-subtrees-943d29a798ec>

<https://www.atlassian.com/blog/git/alternatives-to-git-submodule-git-subtree>

<https://developer.atlassian.com/blog/2015/05/the-power-of-git-subtree/>

<https://www.youtube.com/watch?v=t3Qhon7burE>

### Basic operations

#### Add a subtree to the current project

    # Add the new remote to the project
    git remote add -f <remote name> <remote address>
    # Attach the new code
    git subtree add --prefix <folder> <remote name> <branch> --squash

Example:

    git remote add -f cc_lib http://gitea.codi.coop/codi.cooperatiu/cc_lib.git
    git subtree add --prefix cc_lib cc_lib master --squash

#### Pull from remote

    git fetch <remote name>
    git subtree pull --prefix <path> <remote name> <branch> --squash

Example

    git fetch tpope-vim-surround master
    git subtree pull --prefix .vim/bundle/tpope-vim-surround tpope-vim-surround master --squash

#### Update the remote

*Remind to commit before!!*

    git remote add <remote_name> <remote_address>
    git subtree push --prefix=<path> <remote name> <branch>

Example:

    git remote add cc_lib http://gitea.codi.coop/codi.cooperatiu/cc_lib.git
    git subtree push --prefix=cc_lib cc_lib master

## Notes

GitLab\'s **\"merge request\"** feature is equivalent to GitHub\'s\*\*
\"pull request\"\*\* feature. Both are means of pulling changes from
another branch or fork into your branch and merging the changes with
your existing code. They are useful tools for code review and change
management.

### Inner architecture

Everything stored in git is in a file. When you create a commit it
creates a file containing your commit message and associated data (name,
email, date/time, previous commit, etc) and links it to a tree file. The
tree file contains a list of objects or other trees.

From there branches and tags are simply files containing (basically) a
SHA-1 hash which points to the commit. Using these references allows for
a lot of flexibility and speed, as creating a new branch is as simple as
creating a file with the name of the branch and the SHA-1 reference to
the commit you're branching from.

You may have heard references to the HEAD. This is simply a file
containing the SHA-1 reference of the commit you're currently pointing
to. If you're resolving a merge conflict and see HEAD, that's nothing to
do with a particular branch or necessarily a particular point on the
branch but where you currently are.

### Interactive mode

You can start the interactive mode using -i parameter:

    $ git add -i

### About .gitignore

-   <https://www.atlassian.com/git/tutorials/gitignore/>

### Problems with certificates

You can solve them by \[1\] [updating the certificate
authority](/wiki2/linux_howto#update_system_certificate_authority) or
\[2\] `export GIT_SSL_NO_VERIFY=1` or \[3\]
`git config --global http.sslverify false`.
