# Resources for Arduino

## Develop in C\\C++

### \... With Eclipse

To program an Arduino with Eclipse you just need to follow the [Arduino
manual for C\\C++](http://playground.arduino.cc/Code/Eclipse). As it
says, you need to:

1.  Install the [AVR
    plugin](http://avr-eclipse.sourceforge.net/wiki/index.php/Plugin_Download).
    Which is just to add the repository:
    <http://avr-eclipse.sourceforge.net/updatesite> and install its
    software.
2.  Create a C\\C++ project type `AVR Cross Project Application`.
3.  Code, build the project, activate the Release build configuration
    (which is the one that generates the .hex file), and upload to the
    Arduino (using the `Upload project to target device` AVR option).

Probably you will have some troubles when upload it. You should
configure your the AVRDUDE tool for your device. For a Duemilanove in
Linux a configuration (chosen project properties) that works is\...

-   AvrDude:
    -   Programmer: Atmel STK500 Version 1.x firmware.
    -   Override default port: /dev/ttyUSB0
    -   Override default baurate: 57600
    -   In advance tab: Disable device signature check.
-   Target Hardware:
    -   MCU Type: ATmega328P (which can easily be loaded from the MCU).
    -   MCU clock frequency: 16000000

#### Using a template

You just need to download [the
template](https://github.com/ricovangenugten/Arduino-Blink-Eclipse-Project)
and extract and import its two projects in your Eclipse workspace. Now
you can use the arduino library.

-   ![Arduino template for
    Eclipse](/wiki2/arduino/arduino-blink-eclipse-project-master.zip)

#### Examples

Blink:

``` c
#include <avr/io.h>
#include <util/delay.h>

int main (void) {
    long i;
    DDRB = 1 << 5;
    while (1) {
        PORTB = 1 << 5;
        _delay_ms(1000);
        PORTB = 0 << 5;
        _delay_ms(1000);
    }
}
```

Heartbeat:

``` c
#include <avr/io.h>
#include <util/delay.h>

int main (void) {
    DDRB = 1 << 5;
    while (1) {
        PORTB = 1 << 5; _delay_ms(250);
        PORTB = 0 << 5; _delay_ms(250);
        PORTB = 1 << 5; _delay_ms(250);
        PORTB = 0 << 5; _delay_ms(1000);
    }
}
```

## Links

-   <https://randoof.wordpress.com/2011/09/05/the-arduino-uno-or-duemilanove-from-one-to-the-other/>
    , Diferences between Duemilanove and Uno.

## Notes

-   The removable ATmega chip also means that when you complete a
    project and wish to use it, the chip can be removed and used in
    place alongside either a cheaper cloned version of the Arduino, or
    even make an Arduino yourself with the correct hardware, which is a
    lot cheaper than the Arduino and can be a lot smaller as well. For
    some idea of what can be achieved and for inspiration, have a look
    at [this forum
    thread](http://forum.arduino.cc/index.php/topic,8473.0.html).

### Concepts

-   A microprocessor generally does not have Ram, ROM and IO pins. It
    usually uses its pins as a bus to interface to peripherals such as
    RAM, ROM, Serial ports, Digital and Analog IO. It is expandable at
    the board level due to this.
-   A microcontroller is \'all in one\', the processor, ram, IO all on
    the one chip, as such you cannot (say) increase the amount of RAM
    available or the number of IO ports. The controlling bus is internal
    and not available to the board designer.
