# XUL

XUL es el acrónimo de XML-based User-interface Language, lenguaje basado
en XML para interfaces de usuario; corresponde a una especificación
utilizada para crear interfaces de usuario basada en XML, generalmente
se utiliza en el navegador Mozilla pero puede ser utilizada para crear
aplicaciones sobre plataformas que sepan interpretarlo

## Básicos

### Conceptos

#### Chrome

El chrome se refiere a la interfaz XUL y a todos los ficheros que la
envuelven, sería la unión del contenido \\ estructura XUL más la
apariencia CSS más los ficheros de configuración.\
Una **url chrome** no es más que una ruta donde se guardan archivos del
chrome, por ejemplo la siguiente ruta cargaría un css:

``` xml
<?xml-stylesheet href="chrome://global/skin/" type="text/css"?>
```

#### Paquetes

Un paquete es un XUL con una arquitectura concreta. Por ejemplo un
navegador podría estar definido en la siguiente ruta
`mozilla/bin/chrome/navigagor`, las noticias podrían estar en
`mozilla/bin/chrome/mailnews` y así\... Y cada paquete contendría tres
subdirectorios: `content`, `skin` y `locale` (donde se ubica el código
XUL, el CSS y la información de configuración respectivamente):

    navigator/
      content/
        default/
          navigator.xul
          ...
      skin/
        default/
          navigator.css
          nav-icon.gif
          ...
      locale/
        US-en/
          navigator.dtd

#### Apariencia

Sería el conjunto de CSS y gráficos que proporcionan el aspecto al XUL.
Digamos que el XUL sólo contiene estructura básica sobre como presentar
los controles, la apariencia serían los ficheros CSS que muestran
información avanzada sobre como representar el XUL.\
La apariencia por defecto se carga del fichero `xul.css`.

#### Controles

Son los elementos que constituyen la interfaz, menús, barras de
herramientas, botones\... El conjunto de controles XUL es conocido como
`XPToolkit`. Tendríamos, en resumen, XUL es un lenguaje para interfaces,
XPToolkit que es el conjunto de controles para XUL y luego `XPFE` que es
la parte que ve el usuario creada para proveer la multiplataforma.\
Un control actúa como un objeto en la programación orientada a objetos,
pongamos el ejemplo siguiente, un objeto `menu` con las propiedades `id`
y `value` y cada una con un valor. Dentro de este objeto podemos
encontrar otros como `popup` o `menuitem`:

``` xml
<menu id="file" value="File" >
  <popup>
    <menuitem value="New" onclick="CreateNewDoc()" />
    <menuitem value="Open" onclick="OpenDoc()" />
    <menuitem value="Close" onclick="CloseDoc()" />
  </popup>
</menu>
```

Los controles también pueden lanzar eventos, mensajes enviados desde un
objeto cuando se realiza una acción concreta, dichos eventos son
tratados por objetos manejadores\\escuchadores de eventos que realizarán
acciones cuando reciban el mensaje.

#### Modelos de objetos

El modelo de objetos del documento (DOM) es como acaba estructurandose
internamente los elementos del código, cuando un lenguaje script intenta
acceder a dichos elementos lo hace a través del DOM. El AOM es una
extensión del DOM para una interfaz XUL a partir de una jerarquía de
objetos (browser, menu, menuitem\...).

#### Tecnología XP

Existe el XPCOM que es un enlace a otros lenguajes que proporciona un
modelo de objetos multiplataforma basado en COM (interfaces
independientes de la plataforma a partir de las cuales los objetos
pueden acceder a los servicios).\
`XPIDL` es el lenguaje que define las interfaces multiplataforma y
contiene el cuerpo de los servicios `XPCOM` al cual se conecta a partir
de `XPConnect` y este está creado en Javascript. Gracias a ello se puede
acceder a partir de otros lenguajes como C++.

#### El motor Gecko

Es el motor de renderizado de ventanas de mozilla, lo que hace es leer
un archivo XUL y crear, a partir de él, la interface.

### Básico

### Controles

## Otros

### Herramientas

### Notas
