# XML

Un documento XML contiene datos en texto plano; este lenguaje es
únicamente una especificación a partir de la cual se forman otros como
el [XHTML](/tags/html) o se crean protocolos de comunicación o datos
estructurados de una forma concreta. Esta especificación se basa en las
siguientes normas:

1.  La primera línea debe indicar su codificación y versión (*ejemplo
    1*).
2.  Existirá un único elemento raíz (en el *ejemplo 2* es *note*).
3.  Se distinguirán las mayúsculas de las minúsculas.
4.  Todo elemento deberá cerrarse. Es admisible un elemento sin
    contenido, que se autocierre: `<br />`
5.  Los elementos deberán ser correctamente anidados. La siguiente
    anidación es incorrecta: `<a><b>hola</a></b>`, la correcta es:
    `<a><b>hola</b></a>`.
6.  Todo elemento, excepto el raíz, estará anidado en otro.
7.  No se podrán omitir las comillas, pero estás podrán ser dobles o
    simples. Esto es incorrecto: `<a p=1>`, lo correcto es: `<a p="1">`.
8.  Varios espacios se contarán como uno solo.
9.  Los elementos pueden contener datos como propiedades\\atributos (en
    el *ejemplo 3* sería el *id* de *prod*), como otros elementos o como
    texto.
10. Los nombres de los elementos no pueden empezar por un número o
    carácter extraño, ni contener espacios ni empezar con las letras
    `xml`.

*Ejemplo 1:*

``` xml
<?xml version="1.0" encoding="ISO-8859-1"?>
```

//Ejemplo 2: * `<?xml version="1.0" encoding="ISO-8859-1"?>
<note>
<to>Tove</to>
<from>Jani</from>
<heading>Reminder</heading>
<body>Don't forget me this weekend!</body>
</note>
`{.xml} *Ejemplo 3: //

``` xml
<?xml version="1.0" encoding="ISO-8859-1"?>
<book>
 <title>My First XML</title>
 <prod id="33-657" media="paper"></prod>
 <chapter>Introduction to XML
  <para>What is HTML</para>
  <para>What is XML</para>
 </chapter>
 <chapter>XML Syntax
  <para>Elements must have a closing tag</para>
  <para>Elements must be properly nested</para>
 </chapter>
</book>
```

Un documento xml podrá definir un dtd que lo valide en cuanto a formato,
para ello y como segunda línea se añadirá algo parecido a:

``` xml
<!DOCTYPE note SYSTEM "InternalNote.dtd">
```

## Asignación de un estilo

### Mediante CSS

Podemos asignar un estilo a un documento XML básico añadiendo la línea
siguiente:

``` xml
<?xml-stylesheet type="text/css" href="cd_catalog.css"?>
```

Donde **href** indica el archivo .css correspondiente a [la hoja de
estilos](/tags/html#css). Un ejemplo sería el siguiente archivo xml:

``` xml
<?xml version="1.0" encoding="ISO-8859-1"?>
<?xml-stylesheet type="text/css" href="cd_catalog.css"?>
<CATALOG>
  <CD>
    <TITLE>Empire Burlesque</TITLE>
    <ARTIST>Bob Dylan</ARTIST>
    <COUNTRY>USA</COUNTRY>
    <COMPANY>Columbia</COMPANY>
    <PRICE>10.90</PRICE>
    <YEAR>1985</YEAR>
  </CD>
  <CD>
    <TITLE>Hide your heart</TITLE>
    <ARTIST>Bonnie Tyler</ARTIST>
    <COUNTRY>UK</COUNTRY>
    <COMPANY>CBS Records</COMPANY>
    <PRICE>9.90</PRICE>
    <YEAR>1988</YEAR>
  </CD>
</CATALOG>
```

Con el siguiente archivo css:

``` css
CATALOG
{
background-color: #ffffff;
width: 100%;
}
CD
{
display: block;
margin-bottom: 30pt;
margin-left: 0;
}
TITLE
{
color: #FF0000;
font-size: 20pt;
}
ARTIST
{
color: #0000FF;
font-size: 20pt;
}
COUNTRY,PRICE,YEAR,COMPANY
{
display: block;
color: #000000;
margin-left: 20pt;
}
```

### Mediante XSL

:!:
